/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.sql.struct;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.sql.struct.InvalidSchemaDefinitionException;
import oracle.bpm.sql.struct.Schema;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class SchemaReader
extends DefaultHandler
implements LexicalHandler {
    private boolean auditInfo_d = false;
    private Schema.Field[] auditInfoFields_d = new Schema.Field[4];
    private String data_d;
    private String dbName;
    private Schema.Field field_d;
    private boolean finished_d = false;
    private Schema.Index index_d;
    private int nextIndex_d = 0;
    private int node_d;
    private Schema.NameValue pair_d;
    private boolean parseHeaderOnly_d = false;
    private Schema.Procedure procedure_d;
    private Schema.RawSentence rawSentence;
    private Schema schema_d;
    private Schema.Sequence sequence;
    private Schema.Statement statement_d;
    private Schema.Table table_d;
    private Properties variables = new Properties();
    private Schema.View view_d;
    private static final String BOOLEAN_TRUE = "true";
    private static final String BOOLEAN_FALSE = "false";
    private static final String TYPE_INTEGER = "integer";
    private static final String TYPE_BOOLEAN = "boolean";
    private static final String TYPE_STRING = "string";
    private static final String TYPE_BLOB = "blob";
    private static final String TYPE_BINARY = "binary";
    private static final String TYPE_CLOB = "clob";
    private static final String TYPE_SEQUENCE = "sequence";
    private static final String TYPE_CHAR = "char";
    private static final String TYPE_LONG = "long";
    private static final String TYPE_TIMESTAMP = "timestamp";
    private static final String TYPE_PASSWORD = "password";
    private static final String TYPE_DECIMAL = "decimal";
    private static final String TYPE_REAL = "real";
    private static final String TYPE_NSTRING = "nstring";
    private static final String TYPE_NCLOB = "nclob";
    private static final String TYPE_DOUBLE_754 = "double754";
    private static final String TYPE_FLOAT_754 = "float754";
    private static final String ARG_TYPE_IN = "in";
    private static final String ARG_TYPE_OUT = "out";
    private static final String ARG_TYPE_INOUT = "in/out";
    private static final String ONDELETE_CASCADE = "cascade";
    private static final String ONDELETE_SETNULL = "setnull";
    private static final String WHEN_BEFORE = "before";
    private static final String WHEN_AFTER = "after";
    private static final String TABLE_LOCKING = "table";
    private static final String ROW_LOCKING = "row";
    private static final String TAG_SCHEMA = "schema";
    private static final String TAG_TABLE = "table";
    private static final String TAG_INIT = "init";
    private static final String TAG_FIELD = "field";
    private static final String TAG_PRIMARYKEY = "primarykey";
    private static final String TAG_FOREIGNKEY = "foreignkey";
    private static final String TAG_AUDITINFO = "auditinfo";
    private static final String TAG_UNIQUE = "unique";
    private static final String TAG_PROCEDURE = "procedure";
    private static final String TAG_ARGUMENT = "argument";
    private static final String TAG_CODE = "code";
    private static final String TAG_INDEX = "index";
    private static final String TAG_INSERT = "insert";
    private static final String TAG_VIEW = "view";
    private static final String TAG_SWITCH = "switch";
    private static final String TAG_DATABASE = "database";
    private static final String TAG_SENTENCE = "sentence";
    private static final String TAG_DEFAULT = "default";
    private static final String TAG_VARIABLE = "variable";
    private static final String TAG_SEQUENCE = "sequence";
    private static final String VERSION = "version";
    private static final String TABLE_PREFIX = "table-prefix";
    private static final String FIELD_PREFIX = "field-prefix";
    private static final String NAME = "name";
    private static final String DELETE = "delete";
    private static final String TYPE = "type";
    private static final String SIZE = "size";
    private static final String RESTRICTED_SIZE = "restrictedsize";
    private static final String NOTNULL = "notnull";
    private static final String REFERENCED_FIELDS = "referencedField";
    private static final String REFERENCED_TABLE = "referencedTable";
    private static final String AUDITINFO = "auditinfo";
    private static final String INITIAL = "initial";
    private static final String ONDELETE = "ondelete";
    private static final String WHEN = "when";
    private static final String ARG_TYPE = "argtype";
    private static final String VALUE = "value";
    private static final String UNIQUE = "unique";
    private static final String CSV_FIELDS = "fields";
    private static final String INIT_CLASS = "class";
    private static final String STATEMENT = "statement";
    private static final String ALIAS_NAME = "alias";
    private static final String LOCKING = "locking";
    private static final int SCHEMA_NODE = 1;
    private static final int TABLE_NODE = 2;
    private static final int PRIMARYKEY_NODE = 4;
    private static final int FOREIGNKEY_NODE = 8;
    private static final int AUDITINFO_NODE = 16;
    private static final int UNIQUE_NODE = 32;
    private static final int PROCEDURE_NODE = 64;
    private static final int INDEX_NODE = 128;
    private static final int INSERT_NODE = 256;
    private static final int INIT_NODE = 512;
    private static final int VIEW_NODE = 1024;
    private static final int SWITCH_NODE = 2048;
    private static final int DATABASE_NODE = 4096;
    private static final int DEFAULT_NODE = 8192;
    private static final int SENTENCE_NODE = 16384;
    private static final int SEQUENCE_NODE = 32768;
    private static final boolean DEFAULT_BOOLEAN = false;
    public static final String SCHEMA_PREDEF_VARIABLE = "FUEGO.SCHEMA";

    public static void main(String[] args) {
        SchemaReader reader = new SchemaReader();
        for (int i = 0; i < args.length; ++i) {
            String fileName = args[i];
            try {
                FileInputStream is = new FileInputStream(fileName);
                Schema schema = reader.parse(is);
                System.out.println("schema = " + schema);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        this.data_d = (this.data_d == null ? "" : this.data_d) + new String(buf, offset, len);
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void endElement(String uri, String local, String name) {
        if (this.finished_d) {
            return;
        }
        if ("table".equalsIgnoreCase(name)) {
            this.node_d = 1;
            if (this.auditInfo_d) {
                for (int i = 0; i < this.auditInfoFields_d.length; ++i) {
                    this.table_d.addField(this.auditInfoFields_d[i]);
                }
            }
            this.schema_d.addTable(this.table_d);
            this.table_d = null;
            this.auditInfo_d = false;
        } else if (TAG_FIELD.equalsIgnoreCase(name)) {
            if (this.node_d == 2) {
                this.table_d.addField(this.field_d);
                this.field_d = null;
            } else if (this.node_d == 16) {
                ++this.nextIndex_d;
            } else if (this.node_d == 128) {
                this.table_d.addIndex(this.index_d);
                this.index_d = null;
            } else if (this.node_d == 256) {
                this.statement_d.values.add(this.pair_d);
                this.pair_d = null;
            }
        } else if (TAG_PRIMARYKEY.equalsIgnoreCase(name) || TAG_FOREIGNKEY.equalsIgnoreCase(name) || TAG_INIT.equalsIgnoreCase(name) || "unique".equalsIgnoreCase(name)) {
            this.node_d = 2;
        } else if ("auditinfo".equalsIgnoreCase(name)) {
            this.node_d = 1;
        } else if (TAG_SCHEMA.equalsIgnoreCase(name)) {
            this.finished_d = true;
        } else if (TAG_PROCEDURE.equalsIgnoreCase(name)) {
            this.node_d = 1;
            this.procedure_d.code = this.resolveVariables(this.data_d);
            this.schema_d.addProcedure(this.procedure_d);
            this.procedure_d = null;
        } else if (TAG_CODE.equalsIgnoreCase(name)) {
            if (this.node_d == 64 && this.procedure_d == null) {
                throw new InvalidSchemaDefinitionException(TAG_PROCEDURE, TAG_CODE);
            }
            this.procedure_d.code = this.data_d;
        } else if (TAG_INSERT.equalsIgnoreCase(name)) {
            this.node_d = 1;
            this.schema_d.addStatement(this.statement_d);
            this.statement_d = null;
        } else if (TAG_VIEW.equalsIgnoreCase(name)) {
            this.node_d = 1;
            this.schema_d.addView(this.view_d);
            this.view_d = null;
        } else if (TAG_SENTENCE.equalsIgnoreCase(name)) {
            this.rawSentence = new Schema.RawSentence(this.resolveVariables(this.data_d));
            this.schema_d.addRawSentence(this.dbName, this.rawSentence);
            this.rawSentence = null;
        } else if (TAG_DATABASE.equalsIgnoreCase(name) || TAG_DEFAULT.equalsIgnoreCase(name)) {
            this.node_d = 2048;
        } else if (TAG_SWITCH.equalsIgnoreCase(name)) {
            this.node_d = 1;
        } else if ("sequence".equalsIgnoreCase(name)) {
            this.node_d = 1;
            this.schema_d.addSequence(this.sequence);
            this.sequence = null;
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
        System.out.println("end dtd");
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    public Schema parse(String resource) throws IOException {
        return this.parse(this.getClass().getResourceAsStream(resource));
    }

    public Schema parse(InputStream inputStream) throws IOException {
        assert (inputStream != null) : "The input stream to read the schema is null";
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            saxParser.parse(inputStream, (DefaultHandler)this);
            return this.schema_d;
        }
        catch (SAXException ex) {
            if (ex.getException() != null) {
                if (ex.getException() instanceof InvalidSchemaDefinitionException) {
                    throw (InvalidSchemaDefinitionException)ex.getException();
                }
                throw new InvalidSchemaDefinitionException(ex.getException());
            }
            throw new InvalidSchemaDefinitionException(ex);
        }
        catch (ParserConfigurationException ex) {
            throw new InvalidSchemaDefinitionException(ex);
        }
    }

    public Schema parseHeaderOnly(InputStream inputStream) throws IOException {
        this.parseHeaderOnly_d = true;
        return this.parse(inputStream);
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        System.out.println("name = " + name);
    }

    @Override
    public void startDocument() {
        this.node_d = 1;
    }

    @Override
    public void startElement(String uri, String local, String name, Attributes attrs) throws SAXException {
        if (this.finished_d) {
            return;
        }
        this.data_d = "";
        if (TAG_SCHEMA.equalsIgnoreCase(name)) {
            if (this.schema_d != null) {
                throw new InvalidSchemaDefinitionException("Invalid XML structure, <schema> tag repeated");
            }
            this.schema_d = new Schema(attrs.getValue(NAME), attrs.getValue(VERSION), attrs.getValue(TABLE_PREFIX), attrs.getValue(FIELD_PREFIX));
            if (this.parseHeaderOnly_d) {
                this.finished_d = true;
            }
        } else if ("table".equalsIgnoreCase(name)) {
            String deleteValue;
            if (this.schema_d == null) {
                throw new InvalidSchemaDefinitionException(TAG_SCHEMA, "table");
            }
            if (this.node_d != 1) {
                throw new InvalidSchemaDefinitionException("A table element must only appear inside a schema element");
            }
            this.node_d = 2;
            String alias = this.resolveVariables(attrs.getValue(ALIAS_NAME));
            String tableName = this.resolveVariables(attrs.getValue(NAME));
            String realName = this.schema_d.buildTableName(tableName);
            if (alias != null) {
                if ("".equals(alias)) {
                    throw new InvalidSchemaDefinitionException("The alias can not be empty");
                }
                this.variables.setProperty(alias, realName);
            }
            this.schema_d.checkTable(realName);
            this.table_d = new Schema.Table(realName);
            String strLockType = attrs.getValue(LOCKING);
            if (strLockType != null) {
                this.table_d.lockType = SchemaReader.getLockType(strLockType);
            }
            if ((deleteValue = attrs.getValue(DELETE)) != null) {
                boolean delete = deleteValue.equalsIgnoreCase(BOOLEAN_TRUE);
                this.table_d.setDelete(delete);
            }
            if (attrs.getValue("auditinfo") != null && attrs.getValue("auditinfo").equalsIgnoreCase(BOOLEAN_TRUE)) {
                this.auditInfo_d = true;
                this.table_d.hasAuditInfo = true;
            }
        } else if (TAG_PRIMARYKEY.equalsIgnoreCase(name)) {
            if (this.table_d == null) {
                throw new InvalidSchemaDefinitionException("table", TAG_PRIMARYKEY);
            }
            this.node_d = 4;
            String fields = this.resolveVariables(attrs.getValue(CSV_FIELDS));
            if (fields != null) {
                String[] pkFields = SchemaReader.parseCSV(fields);
                for (int i = 0; i < pkFields.length; ++i) {
                    String realName = this.schema_d.buildFieldName(pkFields[i]);
                    this.schema_d.checkPrimaryKeyField(realName, this.table_d);
                    this.table_d.addToPrimaryKey(realName);
                }
            }
        } else if (TAG_INIT.equalsIgnoreCase(name)) {
            if (this.table_d == null) {
                throw new InvalidSchemaDefinitionException("table", TAG_INIT);
            }
            this.node_d = 512;
            String className = this.resolveVariables(attrs.getValue(INIT_CLASS));
            if (className != null) {
                this.table_d.addInit(className);
            }
        } else if (TAG_FOREIGNKEY.equalsIgnoreCase(name)) {
            if (this.table_d == null) {
                throw new InvalidSchemaDefinitionException("table", TAG_FOREIGNKEY);
            }
            this.node_d = 8;
        } else if ("unique".equalsIgnoreCase(name)) {
            if (this.table_d == null) {
                throw new InvalidSchemaDefinitionException("table", TAG_FOREIGNKEY);
            }
            this.node_d = 32;
        } else if (TAG_FIELD.equalsIgnoreCase(name)) {
            if (this.node_d == 2) {
                if (this.table_d == null) {
                    throw new InvalidSchemaDefinitionException("table", TAG_FIELD);
                }
                String alias = this.resolveVariables(attrs.getValue(ALIAS_NAME));
                String fieldName = this.resolveVariables(attrs.getValue(NAME));
                int type = SchemaReader.getTypeValue(attrs.getValue(TYPE));
                String realName = this.schema_d.buildFieldName(fieldName);
                if (alias != null) {
                    if ("".equals(alias)) {
                        throw new InvalidSchemaDefinitionException("The alias can not be empty");
                    }
                    this.variables.setProperty(alias, realName);
                }
                this.schema_d.checkField(realName, this.table_d);
                this.field_d = new Schema.Field(realName, type, attrs.getValue(TYPE));
                if (attrs.getValue(SIZE) != null) {
                    this.field_d.size = attrs.getValue(SIZE);
                }
                if (attrs.getValue(RESTRICTED_SIZE) != null) {
                    this.field_d.restrictedSize = attrs.getValue(RESTRICTED_SIZE);
                }
                if (attrs.getValue(NOTNULL) != null) {
                    boolean allowNull;
                    this.field_d.allowNull = allowNull = !SchemaReader.getBooleanValue(attrs.getValue(NOTNULL));
                }
                if (attrs.getValue(INITIAL) != null) {
                    this.field_d.initial = Integer.parseInt(attrs.getValue(INITIAL));
                }
            } else if (this.node_d == 4) {
                if (this.table_d == null) {
                    throw new InvalidSchemaDefinitionException(TAG_PRIMARYKEY, TAG_FIELD);
                }
                String fieldName = attrs.getValue(NAME);
                String realName = this.schema_d.buildFieldName(fieldName);
                this.schema_d.checkPrimaryKeyField(realName, this.table_d);
                this.table_d.addToPrimaryKey(realName);
            } else if (this.node_d == 8) {
                int i;
                int i2;
                if (this.table_d == null) {
                    throw new InvalidSchemaDefinitionException(TAG_FOREIGNKEY, TAG_FIELD);
                }
                String[] fields = SchemaReader.parseCSV(this.resolveVariables(attrs.getValue(NAME)));
                String referencedTable = this.schema_d.buildTableName(this.resolveVariables(attrs.getValue(REFERENCED_TABLE)));
                String[] referencedFields = SchemaReader.parseCSV(this.resolveVariables(attrs.getValue(REFERENCED_FIELDS)));
                String[] realFieldNames = this.schema_d.buildFieldNames(fields);
                String[] realReferencedFields = this.schema_d.buildFieldNames(referencedFields);
                this.schema_d.checkForeignKeyField(realFieldNames, referencedTable, realReferencedFields, this.table_d);
                Schema.Field[] fieldsArray = new Schema.Field[realFieldNames.length];
                for (i2 = 0; i2 < realFieldNames.length; ++i2) {
                    this.schema_d.checkFieldExistance(realFieldNames[i2], this.table_d);
                    fieldsArray[i2] = this.table_d.getField(realFieldNames[i2]);
                }
                for (i2 = 0; i2 < fieldsArray.length; ++i2) {
                    fieldsArray[i2].referencedTable = referencedTable;
                    fieldsArray[i2].referencedField = realReferencedFields[i2];
                }
                Schema.ForeignKey foreignKey = new Schema.ForeignKey(realFieldNames, referencedTable, realReferencedFields);
                if (attrs.getValue(ONDELETE) != null) {
                    int action;
                    foreignKey.ondelete = action = SchemaReader.getOnDeleteAction(attrs.getValue(ONDELETE));
                    for (i = 0; i < fieldsArray.length; ++i) {
                        fieldsArray[i].ondelete = action;
                    }
                }
                if (attrs.getValue(WHEN) != null) {
                    int when;
                    foreignKey.when = when = SchemaReader.getWhen(attrs.getValue(WHEN));
                    for (i = 0; i < fieldsArray.length; ++i) {
                        fieldsArray[i].when = when;
                    }
                }
                this.table_d.addForeignKey(foreignKey);
            } else if (this.node_d == 16) {
                if (this.nextIndex_d > this.auditInfoFields_d.length - 1) {
                    throw new InvalidSchemaDefinitionException("There are more than four(4) audit info fields !!!!");
                }
                String fieldName = attrs.getValue(NAME);
                int type = SchemaReader.getTypeValue(attrs.getValue(TYPE));
                String realName = this.schema_d.buildFieldName(fieldName);
                this.auditInfoFields_d[this.nextIndex_d] = new Schema.Field(realName, type, attrs.getValue(TYPE));
                if (attrs.getValue(SIZE) != null) {
                    this.auditInfoFields_d[this.nextIndex_d].size = attrs.getValue(SIZE);
                }
                if (attrs.getValue(NOTNULL) != null) {
                    boolean allowNull;
                    this.auditInfoFields_d[this.nextIndex_d].allowNull = allowNull = !SchemaReader.getBooleanValue(attrs.getValue(NOTNULL));
                }
                if (type == 9) {
                    this.auditInfoFields_d[this.nextIndex_d].isAuditInfoTimestamp = true;
                }
            } else if (this.node_d == 32) {
                if (this.table_d == null) {
                    throw new InvalidSchemaDefinitionException("unique", TAG_FIELD);
                }
                String fieldName = attrs.getValue(NAME);
                String realName = this.schema_d.buildFieldName(fieldName);
                this.schema_d.checkUniqueField(realName, this.table_d);
                this.table_d.addToUnique(realName);
            } else if (this.node_d == 128) {
                if (this.index_d == null) {
                    throw new InvalidSchemaDefinitionException(TAG_INDEX, TAG_FIELD);
                }
                String fieldName = attrs.getValue(NAME);
                this.schema_d.checkIndexField(this.index_d.name, fieldName, this.table_d);
                this.index_d.fields.add(fieldName);
            } else if (this.node_d == 256) {
                if (this.statement_d == null) {
                    throw new InvalidSchemaDefinitionException(TAG_INSERT, TAG_FIELD);
                }
                String fieldName = attrs.getValue(NAME);
                String fieldValue = attrs.getValue(VALUE);
                this.pair_d = new Schema.NameValue(fieldName, fieldValue);
            }
        } else if ("auditinfo".equalsIgnoreCase(name)) {
            this.node_d = 16;
        } else if (TAG_PROCEDURE.equalsIgnoreCase(name)) {
            if (this.schema_d == null) {
                throw new InvalidSchemaDefinitionException(TAG_SCHEMA, TAG_PROCEDURE);
            }
            if (this.node_d != 1) {
                throw new InvalidSchemaDefinitionException("A procedure element must only appear inside a schema element");
            }
            this.node_d = 64;
            String procedureName = attrs.getValue(NAME);
            this.schema_d.checkProcedure(procedureName);
            this.procedure_d = new Schema.Procedure(procedureName);
        } else if (TAG_ARGUMENT.equalsIgnoreCase(name)) {
            if (this.node_d == 64 && this.procedure_d == null) {
                throw new InvalidSchemaDefinitionException(TAG_PROCEDURE, TAG_ARGUMENT);
            }
            String argumentName = this.resolveVariables(attrs.getValue(NAME));
            int argType = SchemaReader.getArgumentType(this.resolveVariables(attrs.getValue(ARG_TYPE)));
            int type = SchemaReader.getTypeValue(this.resolveVariables(attrs.getValue(TYPE)));
            this.schema_d.checkArgument(argumentName, this.procedure_d);
            Schema.Argument argument = new Schema.Argument(argumentName, type, this.resolveVariables(attrs.getValue(TYPE)), argType);
            this.procedure_d.arguments.add(argument);
        } else if (TAG_CODE.equalsIgnoreCase(name)) {
            if (this.node_d == 64 && this.procedure_d == null) {
                throw new InvalidSchemaDefinitionException(TAG_PROCEDURE, TAG_CODE);
            }
            this.data_d = null;
        } else if (TAG_INSERT.equalsIgnoreCase(name)) {
            if (this.schema_d == null) {
                throw new InvalidSchemaDefinitionException(TAG_SCHEMA, TAG_INSERT);
            }
            if (this.node_d != 1) {
                throw new InvalidSchemaDefinitionException("An insert element must only appear inside a schema element");
            }
            this.node_d = 256;
            String tableName = this.resolveVariables(attrs.getValue(NAME));
            this.schema_d.checkStatement(tableName);
            this.statement_d = new Schema.Statement(tableName);
        } else if (TAG_INDEX.equalsIgnoreCase(name)) {
            if (this.node_d == 2 && this.table_d == null) {
                throw new InvalidSchemaDefinitionException("table", TAG_INDEX);
            }
            this.node_d = 128;
            String fields = this.resolveVariables(attrs.getValue(CSV_FIELDS));
            String indexName = attrs.getValue(NAME);
            boolean unique = SchemaReader.getBooleanValue(attrs.getValue("unique"));
            this.index_d = new Schema.Index(indexName, unique);
            this.table_d.addIndex(this.index_d);
            if (fields != null) {
                String[] indexFields = SchemaReader.parseCSV(fields);
                for (int i = 0; i < indexFields.length; ++i) {
                    String realName = this.schema_d.buildFieldName(indexFields[i]);
                    this.schema_d.checkIndexField(indexName, realName, this.table_d);
                    this.index_d.fields.add(realName);
                }
            }
        } else if (TAG_VIEW.equalsIgnoreCase(name)) {
            if (this.schema_d == null) {
                throw new InvalidSchemaDefinitionException(TAG_SCHEMA, TAG_VIEW);
            }
            if (this.node_d != 1) {
                throw new InvalidSchemaDefinitionException("A view element must only appear inside an schema element");
            }
            this.node_d = 1024;
            String viewName = attrs.getValue(NAME);
            String realViewName = this.schema_d.buildTableName(viewName);
            String viewStatement = this.resolveVariables(attrs.getValue(STATEMENT));
            this.schema_d.checkProcedure(realViewName);
            this.view_d = new Schema.View(realViewName, viewStatement);
        } else if (TAG_SWITCH.equalsIgnoreCase(name)) {
            if (this.schema_d == null) {
                throw new InvalidSchemaDefinitionException(TAG_SCHEMA, TAG_SWITCH);
            }
            if (this.node_d != 1) {
                throw new InvalidSchemaDefinitionException("A switch element must only appear inside an schema element");
            }
            this.node_d = 2048;
        } else if (TAG_DATABASE.equalsIgnoreCase(name) || TAG_DEFAULT.equalsIgnoreCase(name)) {
            if (this.schema_d == null) {
                throw new InvalidSchemaDefinitionException(TAG_SCHEMA, name);
            }
            if (this.node_d != 2048) {
                throw new InvalidSchemaDefinitionException("A " + name + " element must only appear inside a switch element");
            }
            this.node_d = TAG_DATABASE.equalsIgnoreCase(name) ? 4096 : 8192;
            this.dbName = this.resolveVariables(attrs.getValue(NAME));
            if (this.dbName == null) {
                this.dbName = TAG_DEFAULT;
            }
        } else if (TAG_SENTENCE.equalsIgnoreCase(name)) {
            if (this.schema_d == null) {
                throw new InvalidSchemaDefinitionException(TAG_SCHEMA, TAG_SENTENCE);
            }
            if (this.node_d != 4096 && this.node_d != 8192) {
                throw new InvalidSchemaDefinitionException("A sentence element must only appear inside a database or default element");
            }
        } else if (TAG_VARIABLE.equalsIgnoreCase(name)) {
            if (this.schema_d == null) {
                throw new InvalidSchemaDefinitionException(TAG_SCHEMA, TAG_VARIABLE);
            }
            String varName = this.resolveVariables(attrs.getValue(NAME));
            String varValue = this.resolveVariables(attrs.getValue(VALUE));
            if (varName == null || "".equals(varName)) {
                throw new InvalidSchemaDefinitionException("The variable name can not be null or empty");
            }
            if (varValue == null) {
                throw new InvalidSchemaDefinitionException("Missing variable value for [" + varName + "]");
            }
            this.variables.setProperty(varName, varValue);
        } else if ("sequence".equalsIgnoreCase(name)) {
            if (this.schema_d == null) {
                throw new InvalidSchemaDefinitionException(TAG_SCHEMA, "sequence");
            }
            if (this.node_d != 1) {
                throw new InvalidSchemaDefinitionException("A sequence element must only appear inside a schema element");
            }
            this.node_d = 32768;
            String sequenceName = attrs.getValue(NAME);
            this.schema_d.checkProcedure(sequenceName);
            this.sequence = new Schema.Sequence(sequenceName, this.schema_d);
        } else {
            throw new InvalidSchemaDefinitionException("Invalid element type [" + name + "]");
        }
    }

    @Override
    public void startEntity(String name) throws SAXException {
    }

    protected static String[] parseCSV(String values) {
        StringTokenizer st = new StringTokenizer(values, ",");
        StringList list = StringList.create();
        while (st.hasMoreTokens()) {
            list.add(st.nextToken().trim());
        }
        return list.toArray(new String[list.size()]);
    }

    static int getTypeValue(String typeString) {
        if (TYPE_INTEGER.equalsIgnoreCase(typeString)) {
            return 1;
        }
        if (TYPE_BOOLEAN.equalsIgnoreCase(typeString)) {
            return 2;
        }
        if (TYPE_STRING.equalsIgnoreCase(typeString)) {
            return 3;
        }
        if (TYPE_BLOB.equalsIgnoreCase(typeString)) {
            return 4;
        }
        if (TYPE_BINARY.equalsIgnoreCase(typeString)) {
            return 4;
        }
        if (TYPE_CLOB.equalsIgnoreCase(typeString)) {
            return 5;
        }
        if ("sequence".equalsIgnoreCase(typeString)) {
            return 6;
        }
        if (TYPE_CHAR.equalsIgnoreCase(typeString)) {
            return 7;
        }
        if (TYPE_LONG.equalsIgnoreCase(typeString)) {
            return 8;
        }
        if (TYPE_TIMESTAMP.equalsIgnoreCase(typeString)) {
            return 9;
        }
        if (TYPE_PASSWORD.equalsIgnoreCase(typeString)) {
            return 10;
        }
        if (TYPE_DECIMAL.equalsIgnoreCase(typeString)) {
            return 11;
        }
        if (TYPE_REAL.equalsIgnoreCase(typeString)) {
            return 12;
        }
        if (TYPE_NSTRING.equalsIgnoreCase(typeString)) {
            return 15;
        }
        if (TYPE_NCLOB.equalsIgnoreCase(typeString)) {
            return 16;
        }
        if (TYPE_FLOAT_754.equalsIgnoreCase(typeString)) {
            return 17;
        }
        if (TYPE_DOUBLE_754.equalsIgnoreCase(typeString)) {
            return 18;
        }
        throw new InvalidSchemaDefinitionException("Invalid type [" + typeString + "]");
    }

    static String resolveSchemaVariable(String text, String variableValue) {
        int beginIndex;
        if (text == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        boolean from = false;
        while (text != null && (beginIndex = text.indexOf("${", 0)) != -1) {
            int endIndex = text.indexOf("}", beginIndex);
            if (endIndex != -1) {
                String varName = text.substring(beginIndex + 2, endIndex);
                if (varName.indexOf("${") != -1) {
                    throw new InvalidSchemaDefinitionException("Invalid variable reference ${" + varName + "}");
                }
                if (!SCHEMA_PREDEF_VARIABLE.equals(varName)) continue;
                sb.append(text.substring(0, beginIndex));
                sb.append(variableValue);
                text = text.substring(endIndex + 1);
                continue;
            }
            sb.append(text);
            text = null;
        }
        if (text != null) {
            sb.append(text);
        }
        return sb.toString();
    }

    private static int getArgumentType(String argType) {
        if (ARG_TYPE_IN.equalsIgnoreCase(argType)) {
            return 0;
        }
        if (ARG_TYPE_OUT.equalsIgnoreCase(argType)) {
            return 1;
        }
        if (ARG_TYPE_INOUT.equalsIgnoreCase(argType)) {
            return 2;
        }
        throw new InvalidSchemaDefinitionException("Invalid argument type [" + argType + "]");
    }

    private static boolean getBooleanValue(String booleanString) {
        if (booleanString == null) {
            return false;
        }
        if (BOOLEAN_TRUE.equalsIgnoreCase(booleanString)) {
            return true;
        }
        if (BOOLEAN_FALSE.equalsIgnoreCase(booleanString)) {
            return false;
        }
        throw new InvalidSchemaDefinitionException("Invalid booleanvalue [" + booleanString + "]");
    }

    private static int getLockType(String lockType) {
        if ("table".equalsIgnoreCase(lockType)) {
            return 1;
        }
        if (ROW_LOCKING.equalsIgnoreCase(lockType)) {
            return 2;
        }
        throw new InvalidSchemaDefinitionException("Invalid lock type [" + lockType + "]");
    }

    private static int getOnDeleteAction(String action) {
        if (ONDELETE_CASCADE.equalsIgnoreCase(action)) {
            return 1;
        }
        if (ONDELETE_SETNULL.equalsIgnoreCase(action)) {
            return 2;
        }
        throw new InvalidSchemaDefinitionException("Invalid ondelete action [" + action + "]");
    }

    private static int getWhen(String when) {
        if (WHEN_AFTER.equalsIgnoreCase(when)) {
            return 1;
        }
        if (WHEN_BEFORE.equalsIgnoreCase(when)) {
            return 2;
        }
        throw new InvalidSchemaDefinitionException("Invalid when [" + when + "]");
    }

    private String getVariableValue(String varName) {
        String varValue = this.variables.getProperty(varName);
        if (varValue == null) {
            throw new InvalidSchemaDefinitionException("Variable [" + varName + "] does not exist");
        }
        return varValue;
    }

    private boolean isLazyResolved(String varName) {
        return SCHEMA_PREDEF_VARIABLE.equals(varName);
    }

    private String resolveVariables(String text) {
        int beginIndex;
        if (text == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        boolean from = false;
        while (text != null && (beginIndex = text.indexOf("${", 0)) != -1) {
            int endIndex = text.indexOf("}", beginIndex);
            if (endIndex != -1) {
                String varName = text.substring(beginIndex + 2, endIndex);
                if (varName.indexOf("${") != -1) {
                    throw new InvalidSchemaDefinitionException("Invalid variable reference ${" + varName + "}");
                }
                String varValue = !this.isLazyResolved(varName) ? this.getVariableValue(varName) : "${" + varName + "}";
                sb.append(text.substring(0, beginIndex));
                sb.append(varValue);
                text = text.substring(endIndex + 1);
                continue;
            }
            sb.append(text);
            text = null;
        }
        if (text != null) {
            sb.append(text);
        }
        return sb.toString();
    }
}

