/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.sql;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.bpm.components.SQLException;
import oracle.bpm.connector.ConnectorException;
import oracle.bpm.connector.JDBCHelper;
import oracle.bpm.jdbc.DatabaseManager;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.DynamicObject;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.RuntimeExceptionShell;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.SuspendableThreadLocal;
import oracle.bpm.lang.TraceableInvokeable;
import oracle.bpm.log.Log;
import oracle.bpm.runtime.Displayable;
import oracle.bpm.sql.JDBC11SQLQueryObject;
import oracle.bpm.sql.QueryObject;
import oracle.bpm.sql.SQLUtils;
import oracle.bpm.sql.StatementException;

public abstract class SQLObject
extends TraceableInvokeable
implements Serializable,
Displayable {
    protected Map<String, Object> fields;
    protected String schema;
    private boolean accessDatabase = true;
    private transient JavaClass<? extends SQLObject> javaClass;
    private List<Member> members;
    private String moduleName;
    private String sql;
    private static ThreadLocal<List<SQLObject>> openObjects = new SuspendableThreadLocal<List<SQLObject>>();
    public static final String ESCAPE_STRING = "@ESC@";
    public static final String SCHEMA_NAME = "@SCHEMA@";
    static final long serialVersionUID = 2758610414072400548L;
    static final long serialCheck = 2652357200367011943L;

    public SQLObject(String moduleName, String signature) {
        this.fields = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        this.moduleName = moduleName;
        this.parseSignature(signature);
    }

    protected SQLObject() {
    }

    public abstract void close() throws SQLException;

    public static void closeIt(SQLObject object) throws SQLException {
        if (object != null) {
            object.close();
        }
    }

    public static void closeAll() {
        List<SQLObject> objects = openObjects.get();
        if (objects != null) {
            for (SQLObject sqlobj : objects) {
                try {
                    sqlobj.close();
                }
                catch (SQLException e) {
                    Log.logSevere(e);
                }
            }
            openObjects.set(null);
        }
    }

    public static QueryObject executeQuery(String module, String schema, String sql, Object[] args, int[] types) throws SQLException {
        try {
            DatabaseManager mgr = JDBCHelper.getDatabaseManager(module);
            String statementStr = sql;
            if (schema != null) {
                String currentSchemaName = mgr.getSchemaForIntrospecting();
                statementStr = Str.replace(sql, SCHEMA_NAME, currentSchemaName != null ? currentSchemaName : schema);
            }
            QueryObject obj = !mgr.supportsJDBC20() ? new JDBC11SQLQueryObject(module, statementStr) : new QueryObject(module, statementStr);
            obj.setArguments(args, types);
            return obj;
        }
        catch (java.sql.SQLException e) {
            throw new SQLException(e);
        }
        catch (ConnectorException e) {
            if (e.getCause() instanceof java.sql.SQLException) {
                throw new SQLException((java.sql.SQLException)e.getCause());
            }
            throw new RuntimeExceptionShell(e);
        }
    }

    public static void executeUpdate(String module, String schema, String sql, Object[] args, int[] types) throws SQLException {
        try {
            Connection conn = JDBCHelper.getConnection(module);
            DatabaseManager mgr = JDBCHelper.getDatabaseManager(module);
            String statementStr = sql;
            if (schema != null) {
                String currentSchemaName = mgr.getSchemaForIntrospecting();
                statementStr = Str.replace(sql, SCHEMA_NAME, currentSchemaName != null ? currentSchemaName.toUpperCase() : schema);
            }
            Statement statement = null;
            try {
                statementStr = Str.replace(statementStr, ESCAPE_STRING, conn.getMetaData().getIdentifierQuoteString());
                statement = conn.prepareStatement(statementStr);
                if (args != null) {
                    for (int i = 0; i < args.length; ++i) {
                        SQLUtils.setParameter((PreparedStatement)statement, i + 1, args[i], types[i]);
                    }
                }
                statement.executeUpdate();
            }
            catch (StatementException e) {
                throw new SQLException(e);
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        catch (java.sql.SQLException e) {
            throw new SQLException(e);
        }
        catch (ConnectorException e) {
            if (e.getCause() instanceof java.sql.SQLException) {
                throw new SQLException((java.sql.SQLException)e.getCause());
            }
            throw new RuntimeExceptionShell(e);
        }
    }

    @Override
    public Object setAttributeValue(String signature, Object value) {
        this.setAttributeValue(signature, -1, value);
        return value;
    }

    @Override
    public void setAttributeValue(String signature, int index, Object value) {
        assert (index == -1) : "Indexed not implemented";
        this.setFieldValue(signature, value);
    }

    @Override
    public Object getAttributeValue(String signature) {
        return this.getAttributeValue(signature, null, -1);
    }

    @Override
    public Object getAttributeValue(String signature, int index) {
        return this.getAttributeValue(signature, null, index);
    }

    @Override
    public Object getAttributeValue(String signature, String setter) {
        return this.getAttributeValue(signature, setter, -1);
    }

    @Override
    public Object getAttributeValue(String signature, String setter, int index) {
        assert (index == -1) : "Indexed not implemented";
        return this.getFieldValue(signature);
    }

    public void setFieldValue(String field, Object value) {
        this.fields.put(field, value);
    }

    public Object getFieldValue(String field) {
        return this.fields.get(field);
    }

    public String getObjectName() {
        return this.sql;
    }

    public void setSQLText(String sql) {
        this.sql = sql;
    }

    public String getSQLText(String quoteString) {
        return Str.replace(this.sql, ESCAPE_STRING, quoteString);
    }

    @Override
    public Object getTarget() {
        return null;
    }

    public void setAccessDatabase(boolean accessDatabase) {
        this.accessDatabase = accessDatabase;
    }

    public boolean isAccessDatabase() {
        return this.accessDatabase;
    }

    @Override
    public DynamicObject getContentToShow() {
        DynamicObject result = DynamicObject.create();
        for (Map.Entry<String, Object> entry : this.fields.entrySet()) {
            String fieldName = entry.getKey().toString();
            if (Character.isDigit(fieldName.charAt(0))) continue;
            result.setField(fieldName, entry.getValue());
        }
        return result;
    }

    @Override
    public boolean isInstanceOf(String componentType, String signature) {
        return "sql".equals(componentType);
    }

    @Override
    public Object invoke(String signature, Object ... args) throws ComponentExecutionException {
        JavaClass<? extends SQLObject> javaClass = this.getJavaClass();
        try {
            Object result = null;
            if (this.isJavaSignature(signature)) {
                result = javaClass.invokeMethod(this, signature, args);
            } else if (args != null && args.length == 1) {
                this.setAttributeValue(signature, args[0]);
            } else {
                result = this.getAttributeValue(signature);
            }
            return result;
        }
        catch (InvocationTargetException exc) {
            throw new ComponentExecutionException(exc.getTargetException(), javaClass.getName(), signature);
        }
        catch (IllegalArgumentException exc) {
            throw new ComponentExecutionException(exc, javaClass.getName(), signature);
        }
        catch (IllegalAccessException exc) {
            throw new ComponentExecutionException(exc, javaClass.getName(), signature);
        }
    }

    public void remove() throws SQLException {
    }

    public void store() throws SQLException {
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (Map.Entry<String, Object> entry : this.fields.entrySet()) {
            if (Character.isDigit(entry.getKey().charAt(0))) continue;
            if (!first) {
                buffer.append(", ");
            } else {
                first = false;
            }
            buffer.append(entry.getKey());
            buffer.append(" = ");
            buffer.append(String.valueOf(entry.getValue()));
        }
        buffer.append("]");
        return buffer.toString();
    }

    protected int setFldParams(PreparedStatement statement) throws java.sql.SQLException {
        return this.setFldParams(statement, 1);
    }

    protected int setFldParams(PreparedStatement statement, int from) throws java.sql.SQLException {
        int position = from;
        for (Member member : this.members) {
            if (member.isReadOnly()) continue;
            SQLUtils.setParameter(statement, position++, this.fields.get(member.getName()), member.getSQLType());
        }
        return position;
    }

    protected JavaClass<? extends SQLObject> getJavaClass() {
        if (this.javaClass == null) {
            this.javaClass = JavaClass.fromClass(this.getClass());
        }
        return this.javaClass;
    }

    protected List<Member> getMembers() {
        return this.members;
    }

    protected String getModuleName() {
        return this.moduleName;
    }

    protected void loadValuesFrom(ResultSet result) throws java.sql.SQLException {
        ResultSetMetaData meta = result.getMetaData();
        for (int i = 1; i <= meta.getColumnCount(); ++i) {
            Object obj;
            String name = meta.getColumnName(i);
            String label = meta.getColumnLabel(i);
            int columnType = meta.getColumnType(i);
            String columnTypeName = meta.getColumnTypeName(i);
            int kind = SQLUtils.getKind(columnType);
            if (kind == 8) {
                byte[] bytes = result.getBytes(name);
                if (bytes != null) {
                    ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                    try {
                        ObjectInputStream is = new ObjectInputStream(stream);
                        obj = is.readObject();
                    }
                    catch (StreamCorruptedException e) {
                        obj = bytes;
                    }
                    catch (IOException e) {
                        if (Log.isDebugging()) {
                            Log.logDebug(e);
                        }
                        throw new java.sql.SQLException(e.getMessage());
                    }
                    catch (ClassNotFoundException e) {
                        if (Log.isDebugging()) {
                            Log.logDebug(e);
                        }
                        obj = bytes;
                    }
                } else {
                    obj = null;
                }
            } else {
                obj = columnType == 93 || "TIMESTAMP".equals(columnTypeName) || columnType == 91 || "DATE".equals(columnTypeName) || columnType == 92 || "TIME".equals(columnTypeName) ? result.getTimestamp(i) : result.getObject(i);
            }
            this.fields.put(name, obj);
            if (label == null) continue;
            this.fields.put(label, obj);
        }
    }

    protected void openObject() {
        List<SQLObject> objects = openObjects.get();
        if (objects == null) {
            objects = new ArrayList<SQLObject>();
        }
        objects.add(this);
        openObjects.set(objects);
    }

    protected void parseSignature(String signature) {
        StringTokenizer tokenizer = new StringTokenizer(signature, "#");
        tokenizer.nextToken();
        this.sql = tokenizer.nextToken();
        StringTokenizer membersTk = new StringTokenizer(tokenizer.nextToken(), ";");
        this.members = new ArrayList<Member>();
        while (membersTk.hasMoreTokens()) {
            String name = membersTk.nextToken();
            int sqltype = SQLUtils.stringToSQLType(membersTk.nextToken());
            this.members.add(new Member(name, sqltype));
        }
        this.members = Collections.unmodifiableList(this.members);
        tokenizer.nextToken();
        this.schema = tokenizer.nextToken();
    }

    protected void resetValues() {
        this.fields.clear();
    }

    boolean internalLoad() {
        return false;
    }

    private boolean isJavaSignature(String signature) {
        return signature.indexOf(40) != -1 || signature.indexOf(59) != -1;
    }

    protected static class Member
    implements Serializable {
        private String memberName;
        private boolean readOnly;
        private int sqltype;
        static final long serialCheck = -9039159852651795411L;
        static final long serialVersionUID = 4758314434252670849L;

        protected Member() {
        }

        Member(String name, int sqltype) {
            if (name.endsWith("(R)")) {
                name = name.substring(0, name.length() - 3);
                this.readOnly = true;
            }
            this.memberName = name;
            this.sqltype = sqltype;
        }

        public String toString() {
            return "(" + this.getName() + ", " + (this.isReadOnly() ? "read-only" : "read-write") + ", " + SQLUtils.sqlTypeToString(this.getSQLType()) + ")";
        }

        String getName() {
            return this.memberName;
        }

        boolean isReadOnly() {
            return this.readOnly;
        }

        int getSQLType() {
            return this.sqltype;
        }
    }
}

