/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.sql;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class ParsedQuery {
    private List<String> fields;
    private List<String> tables;
    private int type;
    private static final int SELECT = 0;
    private static final int INSERT = 1;
    private static final int DELETE = 2;
    private static final int UPDATE = 3;

    private ParsedQuery(List<String> fields, List<String> tables) {
        this.fields = fields;
        this.tables = tables;
    }

    public static boolean isDelete(String sql) {
        return sql.trim().toLowerCase().startsWith("delete ");
    }

    public static boolean isInsert(String sql) {
        return sql.trim().toLowerCase().startsWith("insert ");
    }

    public static boolean isSelect(String sql) {
        return sql.trim().toLowerCase().startsWith("select ");
    }

    public static boolean isUpdate(String sql) {
        return sql.trim().toLowerCase().startsWith("update ");
    }

    public static ParsedQuery parse(String query) {
        int type;
        String tables;
        int fromIndex;
        if (ParsedQuery.isSelect(query = query.trim())) {
            fromIndex = query.toLowerCase().indexOf(" from ") + 6;
            int whereIndex = ParsedQuery.indexOf(query.toLowerCase(), new String[]{" where ", " group ", " order "});
            if (whereIndex == -1) {
                whereIndex = query.length();
            }
            tables = query.substring(fromIndex, whereIndex);
            type = 0;
        } else if (ParsedQuery.isInsert(query)) {
            fromIndex = query.toLowerCase().indexOf(" into ") + 6;
            String insert = query.substring(fromIndex).trim();
            int toIndex = insert.indexOf("(");
            int spaceIndex = insert.indexOf(" ");
            if (toIndex == -1 && spaceIndex == -1) {
                return null;
            }
            toIndex = toIndex == -1 || spaceIndex == -1 ? (toIndex != -1 ? toIndex : spaceIndex) : Math.min(toIndex, spaceIndex);
            tables = insert.substring(0, toIndex);
            type = 1;
        } else if (ParsedQuery.isUpdate(query)) {
            fromIndex = 6;
            int toIndex = query.toLowerCase().indexOf(" set ");
            tables = query.substring(6, toIndex);
            type = 3;
        } else if (ParsedQuery.isDelete(query)) {
            fromIndex = query.toLowerCase().indexOf(" from ") + 6;
            int whereIndex = query.toLowerCase().indexOf(" where ");
            if (whereIndex == -1) {
                whereIndex = query.length();
            }
            tables = query.substring(fromIndex, whereIndex);
            type = 2;
        } else {
            return null;
        }
        ArrayList<String> fieldList = new ArrayList<String>();
        ArrayList<String> tableList = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(tables, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            tableList.add(token.trim());
        }
        fieldList.add("*");
        ParsedQuery parsedQuery = new ParsedQuery(fieldList, tableList);
        parsedQuery.type = type;
        return parsedQuery;
    }

    public boolean isDelete() {
        return this.type == 2;
    }

    public boolean isInsert() {
        return this.type == 1;
    }

    public boolean isSelect() {
        return this.type == 0;
    }

    public boolean isUpdate() {
        return this.type == 3;
    }

    public Iterator<String> getFields() {
        return this.fields.iterator();
    }

    public Iterator<String> getTables() {
        return this.tables.iterator();
    }

    private static int indexOf(String text, String[] words) {
        for (String word : words) {
            int index = text.toLowerCase().indexOf(word);
            if (index == -1) continue;
            return index;
        }
        return -1;
    }
}

