/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import oracle.bpm.sql.JDBCResourceMonitor;
import oracle.bpm.sql.ManagedConnection;
import oracle.bpm.sql.ResourceRef;
import oracle.bpm.util.StackTrace;

class ManagedStatement
implements Statement {
    protected ManagedConnection connection_d;
    protected JDBCResourceMonitor monitor_d;
    protected ResourceRef ref_d;
    protected Statement statement_d;

    ManagedStatement(Statement statement, ManagedConnection connection, JDBCResourceMonitor monitor, ResourceRef parent) {
        this(statement, connection, monitor, parent, null);
    }

    ManagedStatement(Statement statement, ManagedConnection connection, JDBCResourceMonitor monitor, ResourceRef parent, String sql) {
        this.statement_d = statement;
        this.monitor_d = monitor;
        this.connection_d = connection;
        this.ref_d = new ResourceRef<ManagedStatement>(this, statement, monitor.getQueue());
        this.ref_d.setStackTrace(StackTrace.getStackTrace());
        this.ref_d.setInfo(sql);
        this.ref_d.setParent(parent);
        parent.openChild(this.ref_d);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection_d;
    }

    @Override
    public void setCursorName(String s) throws SQLException {
        this.statement_d.setCursorName(s);
    }

    @Override
    public void setEscapeProcessing(boolean b) throws SQLException {
        this.statement_d.setEscapeProcessing(b);
    }

    @Override
    public void setFetchDirection(int i) throws SQLException {
        this.statement_d.setFetchDirection(i);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.statement_d.getFetchDirection();
    }

    @Override
    public void setFetchSize(int i) throws SQLException {
        this.statement_d.setFetchSize(i);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.statement_d.getFetchSize();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.statement_d.getGeneratedKeys();
    }

    @Override
    public void setMaxFieldSize(int i) throws SQLException {
        this.statement_d.setMaxFieldSize(i);
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.statement_d.getMaxFieldSize();
    }

    @Override
    public void setMaxRows(int i) throws SQLException {
        this.statement_d.setMaxRows(i);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.statement_d.getMaxRows();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.statement_d.getMoreResults();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.statement_d.getMoreResults(current);
    }

    @Override
    public void setQueryTimeout(int i) throws SQLException {
        this.statement_d.setQueryTimeout(i);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.statement_d.getQueryTimeout();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.statement_d.getResultSet();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.statement_d.getResultSetConcurrency();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.statement_d.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.statement_d.isClosed();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.statement_d.setPoolable(poolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.statement_d.isPoolable();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.statement_d.getResultSetType();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.statement_d.getUpdateCount();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.statement_d.getWarnings();
    }

    @Override
    public void addBatch(String s) throws SQLException {
        this.statement_d.addBatch(s);
    }

    @Override
    public void cancel() throws SQLException {
        this.statement_d.cancel();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.statement_d.clearBatch();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.statement_d.clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        this.ref_d.close();
        this.statement_d.close();
    }

    @Override
    public boolean execute(String stmt) throws SQLException {
        return this.statement_d.execute(stmt);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.statement_d.execute(sql, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.statement_d.execute(sql, columnIndexes);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.statement_d.execute(sql, columnNames);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.statement_d.executeBatch();
    }

    @Override
    public ResultSet executeQuery(String s) throws SQLException {
        return this.statement_d.executeQuery(s);
    }

    @Override
    public int executeUpdate(String s) throws SQLException {
        return this.statement_d.executeUpdate(s);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.statement_d.executeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.statement_d.executeUpdate(sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.statement_d.executeUpdate(sql, columnNames);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.statement_d.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.statement_d.isWrapperFor(iface);
    }
}

