/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.sql;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import oracle.bpm.sql.JDBCResourceMonitor;
import oracle.bpm.sql.ManagedPreparedStatement;
import oracle.bpm.sql.ManagedStatement;
import oracle.bpm.sql.ResourceRef;
import oracle.bpm.util.StackTrace;

final class ManagedConnection
implements Connection {
    private Connection conn_d;
    private JDBCResourceMonitor monitor_d;
    private ResourceRef ref_d;

    ManagedConnection(Connection conn, JDBCResourceMonitor monitor) {
        this.conn_d = conn;
        this.monitor_d = monitor;
        this.ref_d = this.monitor_d.registerResource(this, conn);
        this.ref_d.setStackTrace(StackTrace.getStackTrace());
    }

    @Override
    public void setAutoCommit(boolean ac) throws SQLException {
        this.conn_d.setAutoCommit(ac);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.conn_d.getAutoCommit();
    }

    @Override
    public void setCatalog(String s) throws SQLException {
        this.conn_d.setCatalog(s);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.conn_d.getCatalog();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.conn_d.isClosed();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.conn_d.setHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.conn_d.getHoldability();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.conn_d.getMetaData();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.conn_d.setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.conn_d.isReadOnly();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.conn_d.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.conn_d.setSavepoint(name);
    }

    @Override
    public void setTransactionIsolation(int i) throws SQLException {
        this.conn_d.setTransactionIsolation(i);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.conn_d.getTransactionIsolation();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> m) throws SQLException {
        this.conn_d.setTypeMap(m);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.conn_d.getTypeMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.conn_d.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.conn_d.clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        this.ref_d.close();
        this.conn_d.close();
    }

    @Override
    public void commit() throws SQLException {
        this.conn_d.commit();
    }

    @Override
    public Statement createStatement() throws SQLException {
        Statement stmt = this.conn_d.createStatement();
        return new ManagedStatement(stmt, this, this.monitor_d, this.ref_d);
    }

    @Override
    public Statement createStatement(int i, int i2) throws SQLException {
        Statement stmt = this.conn_d.createStatement(i, i2);
        return new ManagedStatement(stmt, this, this.monitor_d, this.ref_d);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.conn_d.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public String nativeSQL(String s) throws SQLException {
        return this.conn_d.nativeSQL(s);
    }

    @Override
    public CallableStatement prepareCall(String s) throws SQLException {
        return this.conn_d.prepareCall(s);
    }

    @Override
    public CallableStatement prepareCall(String s, int i, int i3) throws SQLException {
        return this.conn_d.prepareCall(s, i, i3);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.conn_d.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String s) throws SQLException {
        PreparedStatement stmt = this.conn_d.prepareStatement(s);
        return new ManagedPreparedStatement(stmt, this, this.monitor_d, this.ref_d, s);
    }

    @Override
    public PreparedStatement prepareStatement(String s, int i, int i2) throws SQLException {
        PreparedStatement stmt = this.conn_d.prepareStatement(s, i, i2);
        return new ManagedPreparedStatement(stmt, this, this.monitor_d, this.ref_d, s);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.conn_d.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.conn_d.prepareStatement(sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.conn_d.prepareStatement(sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.conn_d.prepareStatement(sql, columnNames);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.conn_d.releaseSavepoint(savepoint);
    }

    @Override
    public void rollback() throws SQLException {
        this.conn_d.rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.conn_d.rollback(savepoint);
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.conn_d.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.conn_d.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.conn_d.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.conn_d.createSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.conn_d.isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.conn_d.setClientInfo(name, value);
        }
        catch (SQLException e) {
            throw new SQLClientInfoException();
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.conn_d.setClientInfo(properties);
        }
        catch (SQLException e) {
            throw new SQLClientInfoException();
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.conn_d.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.conn_d.getClientInfo();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.conn_d.createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.conn_d.createStruct(typeName, attributes);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.conn_d.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.conn_d.isWrapperFor(iface);
    }
}

