/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.sql;

import java.sql.SQLException;
import oracle.bpm.lang.DefaultException;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.sql.InvalidUserOrPasswordException;
import oracle.bpm.sql.SchemaAlreadyExistsException;
import oracle.bpm.sql.SchemaDoesNotExistException;
import oracle.bpm.sql.UnexpectedToolException;

public class DatabaseException
extends DefaultException {
    static final long serialVersionUID = -2737177770058579076L;
    static final long serialCheck = 3397095384446452643L;

    public DatabaseException() {
    }

    public DatabaseException(String url, Throwable t) {
        super(LibMsg.SQL_00010(url, t.getMessage()), t);
    }

    public static void checkException(Exception e, String arg1, String dbmsType) throws DatabaseException {
        int pos2;
        int pos1;
        String urlWithoutPasswd = null;
        if (dbmsType.equals("ORACLE")) {
            pos1 = arg1.indexOf("/");
            pos2 = arg1.indexOf("@");
            urlWithoutPasswd = pos2 > pos1 && pos1 != -1 && pos2 != -1 ? arg1.substring(0, pos1) + arg1.substring(pos2) : arg1;
        }
        if (dbmsType.equals("DB2")) {
            pos1 = arg1.indexOf("//");
            pos1 = arg1.indexOf(":", pos1);
            pos2 = arg1.indexOf("@");
            urlWithoutPasswd = pos2 > pos1 && pos1 != -1 && pos2 != -1 ? arg1.substring(0, pos1) + arg1.substring(pos2) : arg1;
        } else if (dbmsType.equals("MSSQL") || dbmsType.equals("SYBASE")) {
            pos1 = arg1.indexOf("&password=");
            pos2 = arg1.indexOf("&", pos1 + 1);
            if (pos1 != -1 && pos2 == -1) {
                urlWithoutPasswd = arg1.substring(0, pos1);
            } else {
                if (pos1 != -1 && pos2 > pos1) {
                    urlWithoutPasswd = arg1.substring(0, pos1) + arg1.substring(pos2);
                }
                urlWithoutPasswd = arg1;
            }
        } else if (dbmsType.equals("Cloudscape")) {
            pos1 = arg1.indexOf(";password=");
            pos2 = arg1.indexOf(";", pos1 + 1);
            if (pos1 != -1 && pos2 == -1) {
                urlWithoutPasswd = arg1.substring(0, pos1);
            } else {
                if (pos1 != -1 && pos2 > pos1) {
                    urlWithoutPasswd = arg1.substring(0, pos1) + arg1.substring(pos2);
                }
                urlWithoutPasswd = arg1;
            }
        } else {
            urlWithoutPasswd = arg1;
        }
        if (e instanceof SQLException) {
            int errorCode = ((SQLException)e).getErrorCode();
            switch (errorCode) {
                case 1017: {
                    throw new InvalidUserOrPasswordException(urlWithoutPasswd, e);
                }
                case 1801: 
                case 1920: {
                    throw new SchemaAlreadyExistsException(urlWithoutPasswd, e);
                }
                case 1918: 
                case 3701: {
                    throw new SchemaDoesNotExistException(urlWithoutPasswd, e);
                }
            }
            throw new DatabaseException(urlWithoutPasswd, (Throwable)e);
        }
        throw new UnexpectedToolException(urlWithoutPasswd, e);
    }
}

