/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.sql;

import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;

public class ColumnReference {
    private String javaType;
    private String memberSignature;
    private TypeDescription memberType;
    private long modifiers;
    private String name;
    private String signature;
    private ObjectTypeDescription table;

    public ColumnReference(TypeDescription type, String memberName) {
        this(type, memberName, 12L);
    }

    public ColumnReference(ObjectTypeDescription table, MethodTypeDescription memberType, boolean qualified) {
        this.table = table;
        this.memberType = memberType.getResultType();
        this.name = memberType.getName();
        this.modifiers = memberType.getModifiers();
        String schema = "";
        String tableSchema = table.getProperty("schema");
        boolean withoutSchema = Boolean.valueOf(table.getProperty("withoutSchemaName"));
        if (!withoutSchema && tableSchema != null && !tableSchema.equals("")) {
            schema = "@SCHEMA@.";
        }
        this.signature = qualified ? schema + "@ESC@" + this.table.getProperty("caseSensitiveName") + "@ESC@" + "." + "@ESC@" + memberType.getSignature() + "@ESC@" : "@ESC@" + memberType.getSignature() + "@ESC@";
        this.memberSignature = memberType.getSignature();
        this.javaType = memberType.getResultArgument().getJavaType();
    }

    public ColumnReference(TypeDescription type, String memberName, long mods) {
        this.memberType = type;
        this.name = memberName;
        this.signature = memberName;
        this.modifiers = mods;
        this.memberSignature = memberName;
    }

    public String getJavaType() {
        return this.javaType;
    }

    public long getModifiers() {
        return this.modifiers;
    }

    public String getName() {
        return this.name;
    }

    public String getSignature() {
        if (this.signature != null && this.signature.indexOf("-") != -1) {
            return "'" + this.signature + "'";
        }
        return this.signature;
    }

    public TypeDescription getTable() {
        return this.table;
    }

    public TypeDescription getType() {
        return this.memberType;
    }

    public void addToObject(ObjectTypeDescription objType) {
        AttributeTypeDescription attr = new AttributeTypeDescription(this.getName().toLowerCase(), this.getType());
        attr.setReadSignature(this.memberSignature);
        attr.setWriteSignature(this.memberSignature);
        attr.setModifiers(this.getModifiers());
        objType.addMember(attr);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ColumnReference) {
            ColumnReference ref = (ColumnReference)obj;
            return this.getSignature().equalsIgnoreCase(ref.getSignature());
        }
        return false;
    }

    public int hashCode() {
        return this.getSignature().hashCode();
    }

    public ColumnReference rename(String newname) {
        return this.rename(newname, null);
    }

    public ColumnReference rename(String newname, String signature) {
        ColumnReference ref = new ColumnReference(this.memberType, newname);
        ref.table = this.table;
        ref.signature = signature != null ? signature : this.signature;
        ref.memberSignature = signature != null ? signature : this.memberSignature;
        ref.javaType = this.javaType;
        ref.modifiers = this.modifiers;
        return ref;
    }

    public String toString() {
        return this.signature;
    }
}

