/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.servlet.multipart;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import oracle.bpm.servlet.multipart.MultipartWrapper;
import org.apache.commons.fileupload.RequestContext;

public class Util {
    public static final String MULTIPART = "multipart/";

    public static boolean isNotMultipart(HttpServletRequest request) {
        String contentType = request.getContentType();
        HttpSession session = request.getSession(false);
        boolean isMultipartContent = Util.isMultipartContent(request);
        return contentType == null || !isMultipartContent || session == null || request instanceof MultipartWrapper;
    }

    public static MultipartWrapper createMultipartWrapper(HttpServletRequest request, String uploadDir, int maxSize) throws IOException {
        return new MultipartWrapper(request, uploadDir, maxSize);
    }

    public static boolean isMultipartContent(HttpServletRequest request) {
        if (request.getMethod() != null && !"post".equals(request.getMethod().toLowerCase())) {
            return false;
        }
        String contentType = request.getContentType();
        return contentType != null && contentType.toLowerCase().startsWith(MULTIPART);
    }

    public static boolean isMultipartContent(RequestContext ctx) {
        String contentType = ctx.getContentType();
        return contentType != null && contentType.toLowerCase().startsWith(MULTIPART);
    }
}

