/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.servlet;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;
import oracle.bpm.util.Base64;

public class HttpMessage {
    Map<String, String> cookiesReceived;
    Map<String, String> headers;
    URL servlet;
    private static final String CONTENT_TYPE = "Content-Type";
    public static final String RESPONSE_INPUTSTREAM = "RESPONSE_INPUTSTREAM";
    public static final String RESPONSE_CODE = "RESPONSE_CODE";

    public HttpMessage(URL servlet) {
        this.servlet = servlet;
    }

    public void setAuthorization(String name, String password) {
        String authorization;
        String token = name + ":" + password;
        try {
            authorization = Base64.encode(token.getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("Unexpected exception", e);
        }
        this.setHeader("Authorization", "Basic " + authorization);
    }

    public void setCookie(String name, String value) {
        String existingCookies;
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        if ((existingCookies = this.headers.get("Cookie")) == null) {
            this.setHeader("Cookie", name + "=" + value);
        } else {
            this.setHeader("Cookie", existingCookies + "; " + name + "=" + value);
        }
    }

    public Map getCookies() {
        return this.cookiesReceived;
    }

    public void setHeader(String name, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(name, value);
    }

    public InputStream sendGetMessage() throws IOException {
        return this.sendGetMessage(null);
    }

    public InputStream sendGetMessage(Properties args) throws IOException {
        String argString = args == null || args.size() <= 0 ? "" : "?" + this.toEncodedString(args);
        URL url = new URL(this.servlet.toExternalForm() + argString);
        URLConnection con = url.openConnection();
        con.setUseCaches(false);
        this.sendHeaders(con);
        InputStream returning = con.getInputStream();
        this.getCookiesFrom(con);
        return returning;
    }

    public InputStream sendMultipartPostMessage(MimeMultipart multipart) throws IOException, MessagingException {
        URLConnection con = this.servlet.openConnection();
        con.setDoInput(true);
        con.setDoOutput(true);
        con.setUseCaches(false);
        con.setRequestProperty(CONTENT_TYPE, multipart.getContentType());
        this.sendHeaders(con);
        DataOutputStream out = new DataOutputStream(con.getOutputStream());
        multipart.writeTo((OutputStream)out);
        out.flush();
        out.close();
        InputStream returning = con.getInputStream();
        this.getCookiesFrom(con);
        return returning;
    }

    public Properties sendNormalPostMessage(Properties args) throws IOException {
        URLConnection con;
        String argString = "";
        if (args != null) {
            argString = this.toEncodedString(args);
        }
        if ((con = this.servlet.openConnection()) instanceof HttpURLConnection) {
            HttpURLConnection hCon = (HttpURLConnection)con;
            hCon.setInstanceFollowRedirects(false);
            con = hCon;
        }
        con.setDoInput(true);
        con.setDoOutput(true);
        con.setUseCaches(false);
        con.setRequestProperty(CONTENT_TYPE, "application/x-www-form-urlencoded");
        this.sendHeaders(con);
        DataOutputStream out = new DataOutputStream(con.getOutputStream());
        out.writeBytes(argString);
        out.flush();
        out.close();
        Properties returning = this.getResponseProperties(con);
        this.getCookiesFrom(con);
        return returning;
    }

    public InputStream sendPostMessage(Properties args) throws IOException {
        String argString = args == null ? "" : this.toEncodedString(args);
        URLConnection con = this.servlet.openConnection();
        con.setDoInput(true);
        con.setDoOutput(true);
        con.setUseCaches(false);
        con.setRequestProperty(CONTENT_TYPE, "application/x-www-form-urlencoded");
        this.sendHeaders(con);
        DataOutputStream out = new DataOutputStream(con.getOutputStream());
        out.writeBytes(argString);
        out.flush();
        out.close();
        InputStream returning = con.getInputStream();
        this.getCookiesFrom(con);
        return returning;
    }

    public InputStream sendPostMessage(Serializable obj, Properties reqProperties) throws IOException {
        URLConnection con = this.servlet.openConnection();
        con.setDoInput(true);
        con.setDoOutput(true);
        con.setUseCaches(false);
        con.setRequestProperty(CONTENT_TYPE, "java-internal/" + obj.getClass().getName());
        if (reqProperties != null) {
            this.setRequestProperties(con, reqProperties);
        }
        this.sendHeaders(con);
        ObjectOutputStream out = new ObjectOutputStream(con.getOutputStream());
        out.writeObject(obj);
        out.flush();
        out.close();
        InputStream returning = con.getInputStream();
        this.getCookiesFrom(con);
        return returning;
    }

    public InputStream sendPostMessage(Serializable obj) throws IOException {
        return this.sendPostMessage(obj, null);
    }

    protected void getHeaderProperties(URLConnection _urlConnection, Properties _properties) {
        String key;
        int i = 1;
        while ((key = _urlConnection.getHeaderFieldKey(i)) != null) {
            _properties.put(key, _urlConnection.getHeaderField(key));
            ++i;
        }
    }

    protected void setRequestProperties(URLConnection con, Properties properties) {
        for (Object k : properties.keySet()) {
            String name = (String)k;
            con.setRequestProperty(name, properties.getProperty(name));
        }
    }

    protected Properties getResponseProperties(URLConnection _urlConnection) throws IOException {
        Properties _properties = new Properties();
        this.getHeaderProperties(_urlConnection, _properties);
        _properties.put(RESPONSE_INPUTSTREAM, _urlConnection.getInputStream());
        if (_urlConnection instanceof HttpURLConnection) {
            _properties.put(RESPONSE_CODE, "" + ((HttpURLConnection)_urlConnection).getResponseCode());
        }
        return _properties;
    }

    private void getCookiesFrom(URLConnection con) {
        String str;
        int i = 0;
        while ((str = con.getHeaderField(i)) != null) {
            if (con.getHeaderFieldKey(i) != null && con.getHeaderFieldKey(i).equals("Set-Cookie")) {
                if (this.cookiesReceived == null) {
                    this.cookiesReceived = new HashMap<String, String>();
                }
                String cookie = str.substring(0, str.indexOf(59));
                this.cookiesReceived.put(cookie.substring(0, cookie.indexOf(61)), cookie.substring(cookie.indexOf(61) + 1, cookie.length()));
            }
            ++i;
        }
    }

    private void sendHeaders(URLConnection con) {
        if (this.headers != null) {
            for (String name : this.headers.keySet()) {
                con.setRequestProperty(name, this.headers.get(name));
            }
        }
    }

    private String toEncodedString(Properties args) {
        StringBuffer buf;
        block3: {
            buf = new StringBuffer();
            Enumeration<?> names = args.propertyNames();
            String encoding = "UTF-8";
            try {
                while (names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    String value = args.getProperty(name);
                    buf.append(URLEncoder.encode(name, "UTF-8"));
                    buf.append("=");
                    buf.append(URLEncoder.encode(value, "UTF-8"));
                    if (!names.hasMoreElements()) continue;
                    buf.append("&");
                }
            }
            catch (UnsupportedEncodingException e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)"Encoding: UTF-8 not found.");
            }
        }
        return buf.toString();
    }
}

