/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lib;

import java.util.Locale;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;

public enum ExpressionMode implements I18nProvider
{
    SIMPLE(LibMsg.SIMPLE){

        @Override
        public String getId() {
            return "simple";
        }
    }
    ,
    XPATH(LibMsg.XPATH){

        @Override
        public String getId() {
            return "xpath";
        }
    }
    ,
    TEXT(LibMsg.TEXT){

        @Override
        public String getId() {
            return "text";
        }
    };

    private Msg msg;

    private ExpressionMode(Msg msg) {
        this.msg = msg;
    }

    @Override
    public String getString() {
        return this.msg.getString();
    }

    @Override
    public String getString(Locale locale) {
        return this.msg.getString(locale);
    }

    public abstract String getId();

    public static ExpressionMode fromId(String mode) {
        if ("simple".equalsIgnoreCase(mode)) {
            return SIMPLE;
        }
        if ("xpath".equalsIgnoreCase(mode)) {
            return XPATH;
        }
        if ("text".equalsIgnoreCase(mode)) {
            return TEXT;
        }
        return null;
    }
}

