/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lib;

import java.util.Locale;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;

public enum ExpressionLanguage implements I18nProvider
{
    XPATH(LibMsg.XPATH){

        @Override
        public String getId() {
            return XPATH_ID;
        }
    };

    private Msg msg;
    private static String XPATH_ID;

    private ExpressionLanguage(Msg msg) {
        this.msg = msg;
    }

    @Override
    public String getString() {
        return this.msg.getString();
    }

    @Override
    public String getString(Locale locale) {
        return this.msg.getString(locale);
    }

    public abstract String getId();

    public static ExpressionLanguage fromId(String codeLanguage) {
        if (XPATH_ID.equalsIgnoreCase(codeLanguage) || "xpath".equalsIgnoreCase(codeLanguage)) {
            return XPATH;
        }
        return null;
    }

    static {
        XPATH_ID = "http://www.w3.org/1999/XPath";
    }
}

