/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import oracle.bpm.lang.AbstractTypeUUID;
import oracle.bpm.lang.XmlElementType;
import org.jetbrains.annotations.NotNull;

public class XmlUUID
extends AbstractTypeUUID {
    private XmlElementType elemType;

    private XmlUUID(@NotNull XmlElementType elemType, @NotNull String namespace, @NotNull String name) {
        if (elemType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/XmlUUID.<init> must not be null");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/lang/XmlUUID.<init> must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/lang/XmlUUID.<init> must not be null");
        }
        super(namespace, name);
        this.elemType = elemType;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static XmlUUID parse(@NotNull String uuid) {
        if (uuid == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/XmlUUID.parse must not be null");
        }
        String[] strings = uuid.split("\\|");
        if (strings.length != 3) {
            throw new IllegalArgumentException("Invalid xml id: '" + uuid + "'");
        }
        String elemTypeCode = strings[0];
        String namespace = strings[1];
        String name = strings[2];
        XmlElementType elemType = XmlElementType.valueFromCharCode(elemTypeCode.charAt(0));
        XmlUUID xmlUUID = XmlUUID.create(elemType, namespace, name);
        if (xmlUUID == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/XmlUUID.parse must not return null");
        }
        return xmlUUID;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public XmlElementType getElemType() {
        XmlElementType xmlElementType = this.elemType;
        if (xmlElementType == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/XmlUUID.getElemType must not return null");
        }
        return xmlElementType;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String getId() {
        String string = this.elemType.getCharCode() + "|" + this.getNamespace() + "|" + this.getNativeName();
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/XmlUUID.getId must not return null");
        }
        return string;
    }

    @Override
    protected char getTypeId() {
        return this.elemType.getCharCode();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    static XmlUUID create(@NotNull XmlElementType elemType, @NotNull String namespace, @NotNull String name) {
        if (elemType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/XmlUUID.create must not be null");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/lang/XmlUUID.create must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/lang/XmlUUID.create must not be null");
        }
        XmlUUID xmlUUID = new XmlUUID(elemType, namespace, name);
        if (xmlUUID == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/XmlUUID.create must not return null");
        }
        return xmlUUID;
    }
}

