/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.util.List;
import javax.xml.namespace.QName;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.NamespacedTypeDescription;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.TypeUUID;
import oracle.bpm.lang.UUIDFactory;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.lang.XmlElementType;
import oracle.bpm.lang.XmlUUID;
import oracle.bpm.type.SchemaObjectFactory;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.type.utils.XmlUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlTypeDescription
extends NamespacedTypeDescription {
    private boolean attributesAreQualified;
    private boolean elementsAreQualified;
    private final XmlElementType xmlElementType;

    protected XmlTypeDescription(@NotNull String name, @NotNull String namespace, @Nullable String location, @NotNull XmlElementType xmlElementType, int kind) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/XmlTypeDescription.<init> must not be null");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/lang/XmlTypeDescription.<init> must not be null");
        }
        if (xmlElementType == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/lang/XmlTypeDescription.<init> must not be null");
        }
        this(name, namespace, location, xmlElementType, UUIDFactory.createXmlId(xmlElementType, namespace, name), kind);
    }

    private XmlTypeDescription(@NotNull XObjectTypeDescription modeledXO, @NotNull String module, boolean isCallback) {
        if (modeledXO == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/XmlTypeDescription.<init> must not be null");
        }
        if (module == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/lang/XmlTypeDescription.<init> must not be null");
        }
        this(modeledXO.getName(), XmlTypeDescription.buildNamespace(module, modeledXO.getName(), isCallback), XmlTypeDescription.buildLocation(module, modeledXO.getName(), isCallback), XmlElementType.ELEMENT, 11);
        this.setNativeName(modeledXO.getName());
        String typeName = this.getNativeName() + "Type";
        XmlUUID typeUUID = UUIDFactory.createXmlId(XmlElementType.TYPE, this.getNamespace(), typeName);
        this.setProperty("element.type.id", typeUUID.getId());
        String namespace = this.getNamespace();
        XmlTypeDescription complexType = new XmlTypeDescription(typeName, namespace, this.getLocation(), XmlElementType.TYPE, 11);
        this.addSuperType(new SuperType(complexType, 0x800000L));
    }

    private XmlTypeDescription(@NotNull String name, @NotNull String namespace, @Nullable String location, @NotNull XmlElementType xmlElementType, @NotNull TypeUUID uuid, int kind) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/XmlTypeDescription.<init> must not be null");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/lang/XmlTypeDescription.<init> must not be null");
        }
        if (xmlElementType == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/lang/XmlTypeDescription.<init> must not be null");
        }
        if (uuid == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of oracle/bpm/lang/XmlTypeDescription.<init> must not be null");
        }
        super(name, namespace, location, kind);
        this.setComponentType(ComponentType.XML.getText());
        this.xmlElementType = xmlElementType;
        this.setId(uuid.getId());
    }

    public static XmlTypeDescription createForBpmObjectSchema(@NotNull XObjectTypeDescription xotd, @NotNull String module, boolean isCallback) {
        if (xotd == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/XmlTypeDescription.createForBpmObjectSchema must not be null");
        }
        if (module == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/lang/XmlTypeDescription.createForBpmObjectSchema must not be null");
        }
        return new XmlTypeDescription(xotd, module, isCallback);
    }

    public static XmlTypeDescription createForExternalXml(@NotNull String name, @NotNull String namespace, @Nullable String location, @NotNull XmlElementType xmlElementType, @NotNull TypeUUID uuid) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/XmlTypeDescription.createForExternalXml must not be null");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/lang/XmlTypeDescription.createForExternalXml must not be null");
        }
        if (xmlElementType == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/lang/XmlTypeDescription.createForExternalXml must not be null");
        }
        if (uuid == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of oracle/bpm/lang/XmlTypeDescription.createForExternalXml must not be null");
        }
        return new XmlTypeDescription(name, namespace, location, xmlElementType, uuid, 11);
    }

    public static XmlTypeDescription createForExternalXml(@NotNull String name, @NotNull String namespace, @Nullable String location, @NotNull XmlElementType xmlElementType) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/XmlTypeDescription.createForExternalXml must not be null");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/lang/XmlTypeDescription.createForExternalXml must not be null");
        }
        if (xmlElementType == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/lang/XmlTypeDescription.createForExternalXml must not be null");
        }
        return new XmlTypeDescription(name, namespace, location, xmlElementType, 11);
    }

    public static XmlTypeDescription createPointerToType(@NotNull String name, @NotNull String namespace, @NotNull TypeRef realType) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/XmlTypeDescription.createPointerToType must not be null");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/lang/XmlTypeDescription.createPointerToType must not be null");
        }
        if (realType == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/lang/XmlTypeDescription.createPointerToType must not be null");
        }
        return XmlTypeDescription.createPointerType(name, namespace, realType, XmlElementType.TYPE);
    }

    public static XmlTypeDescription createPointerToElement(@NotNull String name, @NotNull String namespace, @NotNull TypeRef realType) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/XmlTypeDescription.createPointerToElement must not be null");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/lang/XmlTypeDescription.createPointerToElement must not be null");
        }
        if (realType == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/lang/XmlTypeDescription.createPointerToElement must not be null");
        }
        return XmlTypeDescription.createPointerType(name, namespace, realType, XmlElementType.ELEMENT);
    }

    public static XmlTypeDescription createPointerToAttribute(@NotNull AttributeTypeDescription att) {
        if (att == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/XmlTypeDescription.createPointerToAttribute must not be null");
        }
        String name = att.getNativeName();
        String namespace = att.getProperty("namespace");
        TypeRef realType = att.getTypeRef();
        return XmlTypeDescription.createPointerType(name, namespace, realType, XmlElementType.ATTRIBUTE);
    }

    public static XmlTypeDescription createPointerToAttGroup(@NotNull TypeDescription attGroup, @NotNull String namespace, @NotNull String name) {
        if (attGroup == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/XmlTypeDescription.createPointerToAttGroup must not be null");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/lang/XmlTypeDescription.createPointerToAttGroup must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/lang/XmlTypeDescription.createPointerToAttGroup must not be null");
        }
        TypeRef realType = attGroup.getRef();
        return XmlTypeDescription.createPointerType(name, namespace, realType, XmlElementType.ATTGROUP);
    }

    public static XmlTypeDescription createPointerToGroup(@NotNull TypeDescription group, @NotNull String namespace, @NotNull String name) {
        if (group == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/XmlTypeDescription.createPointerToGroup must not be null");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/lang/XmlTypeDescription.createPointerToGroup must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/lang/XmlTypeDescription.createPointerToGroup must not be null");
        }
        TypeRef realType = group.getRef();
        return XmlTypeDescription.createPointerType(name, namespace, realType, XmlElementType.GROUP);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public XmlElementType getXmlElementType() {
        XmlElementType xmlElementType = this.xmlElementType;
        if (xmlElementType == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/XmlTypeDescription.getXmlElementType must not return null");
        }
        return xmlElementType;
    }

    public boolean isElement() {
        return this.getXmlElementType() == XmlElementType.ELEMENT;
    }

    public boolean isElementsAreQualified() {
        return this.elementsAreQualified;
    }

    public void setElementsAreQualified(boolean elementsAreQualified) {
        this.elementsAreQualified = elementsAreQualified;
    }

    public boolean isAttributesAreQualified() {
        return this.attributesAreQualified;
    }

    public boolean isWsdlInlineObject() {
        String value = this.getProperty("wsdl.inline.object");
        return Boolean.TRUE.toString().equals(value);
    }

    @Override
    public boolean isSchemaObject() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public SchemaObject asSchemaObject() {
        SchemaObject schemaObject = SchemaObjectFactory.createForXmlType(this);
        if (schemaObject == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/XmlTypeDescription.asSchemaObject must not return null");
        }
        return schemaObject;
    }

    public void setAttributesAreQualified(boolean attributesAreQualified) {
        this.attributesAreQualified = attributesAreQualified;
    }

    @Override
    public void addMember(MethodTypeDescription member) {
        super.addMember(member);
        if (member.isAttribute() && Str.isEmpty(member.getNativeName())) {
            member.setNativeName(member.getName());
        }
    }

    public boolean isPointer() {
        return this.getTransientProperty("real.type") != null;
    }

    @Override
    protected boolean isAssignableFromImpl(@NotNull TypeDescription that) {
        if (that == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/XmlTypeDescription.isAssignableFromImpl must not be null");
        }
        if (that.isNull()) {
            return true;
        }
        if (!(that instanceof XmlTypeDescription || that.isPredefined() || that.isBpmObject())) {
            return false;
        }
        if (that.isBpmObject()) {
            XmlTypeDescription otd = TypeUtils.getModelObject(that.asBpmObject());
            if (otd == null) {
                return false;
            }
            that = otd;
        }
        if (this.equals(that)) {
            return true;
        }
        TypeDescription thisType = this.getType(this);
        TypeDescription thatType = this.getType(that);
        if (thisType != null && thatType != null) {
            if (XmlUtils.isSFS(thisType.asSchemaObject().getNamespace()) && XmlUtils.isSFS(thatType.asSchemaObject().getNamespace())) {
                return thisType.isAssignableFrom(thatType);
            }
            return thisType.equals(thatType);
        }
        return false;
    }

    private static XmlTypeDescription createPointerType(@NotNull String name, @NotNull String namespace, @NotNull TypeRef realType, @NotNull XmlElementType elementType) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/XmlTypeDescription.createPointerType must not be null");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/lang/XmlTypeDescription.createPointerType must not be null");
        }
        if (realType == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/lang/XmlTypeDescription.createPointerType must not be null");
        }
        if (elementType == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/lang/XmlTypeDescription.createPointerType must not be null");
        }
        XmlTypeDescription pointerType = new XmlTypeDescription(name, namespace, null, elementType, 11);
        pointerType.addModifier(0x2000000L);
        pointerType.setTransientProperty("real.type", realType);
        return pointerType;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static String buildLocation(@NotNull String module, @NotNull String name, boolean isCallback) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/XmlTypeDescription.buildLocation must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/lang/XmlTypeDescription.buildLocation must not be null");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("/");
        builder.append("businessCatalog");
        builder.append("/");
        builder.append(module.replace('.', '/'));
        if (!isCallback) {
            builder.append('/');
            builder.append(name);
        }
        builder.append(".xsd");
        String string = builder.toString();
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/XmlTypeDescription.buildLocation must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static String buildNamespace(@NotNull String module, @NotNull String name, boolean isCallback) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/XmlTypeDescription.buildNamespace must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/lang/XmlTypeDescription.buildNamespace must not be null");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("http://xmlns.oracle.com/bpm/bpmobject/");
        builder.append(module.replace('.', '/'));
        if (!isCallback) {
            builder.append('/');
            builder.append(name);
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/XmlTypeDescription.buildNamespace must not return null");
        }
        return string;
    }

    @Nullable
    private QName getType(@NotNull SchemaObject so) {
        if (so == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/XmlTypeDescription.getType must not be null");
        }
        if (so.isElement()) {
            return so.getElementTypeQName();
        }
        if (so.isType()) {
            return new QName(so.getNamespace(), so.getName());
        }
        return null;
    }

    @Nullable
    private TypeDescription getType(@NotNull TypeDescription td) {
        if (td == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/XmlTypeDescription.getType must not be null");
        }
        SchemaObject so = td.asSchemaObject();
        if (so.isElement() && so.getElementTypeId() != null) {
            List<SuperType> list = td.getSuperTypes();
            if (!list.isEmpty()) {
                return list.get(0).getType();
            }
        } else if (so.isType()) {
            return td;
        }
        return null;
    }
}

