/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.io.PrintStream;
import java.io.PrintWriter;
import oracle.bpm.util.ExceptionFormatter;

public class VirtualException
extends Exception {
    public String exceptionClass;
    public String message;
    public String stackTrace;
    static final long serialVersionUID = 5291919995202094126L;
    static final long serialCheck = 7807665476234084941L;

    public VirtualException() {
    }

    public VirtualException(Throwable t) {
        super("Virtualized<" + t.getClass().getName() + ">");
        this.exceptionClass = t.getClass().getName();
        this.stackTrace = ExceptionFormatter.fullTechLevel(t);
        this.message = t.getMessage() != null ? t.getMessage() : "<No message available>";
    }

    public VirtualException(String aExceptionClass, String aMessage, String aStackTrace) {
        super("Virtualized<" + aExceptionClass + ">");
        this.exceptionClass = aExceptionClass;
        this.stackTrace = aStackTrace;
        this.message = aMessage;
    }

    @Override
    public void printStackTrace(PrintWriter pw) {
        pw.println(this.stackTrace);
    }

    @Override
    public void printStackTrace(PrintStream ps) {
        this.printStackTrace(new PrintWriter(ps));
    }
}

