/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.security.Principal;
import oracle.bpm.log.Log;
import oracle.bpm.util.Properties;

public class User
implements Principal,
Serializable {
    private String dn_d;
    private String home_d;
    private String mail_d;
    private String name_d;
    private String ou_d;
    private String passwd_d;
    private String principal_d;
    private Properties properties_d;
    private boolean receiveMail_d;
    private String uid_d;
    static final long serialVersionUID = 7734467055073952625L;
    private static User localUser_sd;
    static final long serialCheck = 3445305093431931460L;

    private User() {
    }

    public static User getLocalUser() {
        if (localUser_sd != null) {
            return localUser_sd;
        }
        localUser_sd = new User();
        try {
            User.localUser_sd.uid_d = System.getProperty("user.name");
            User.localUser_sd.home_d = System.getProperty("user.home");
        }
        catch (SecurityException security) {
            User.localUser_sd.uid_d = "guest";
            User.localUser_sd.home_d = null;
        }
        localUser_sd.loadProperties();
        return localUser_sd;
    }

    public static User createUser_(String id, String name) {
        User user = new User();
        user.name_d = name;
        user.uid_d = id;
        user.loadProperties();
        return user;
    }

    public final void setDN(String dn) {
        this.dn_d = dn;
    }

    public final String getDN() {
        return this.dn_d;
    }

    public final String getId() {
        return this.uid_d;
    }

    public final String getMailAddress() {
        return null;
    }

    public final String getMailHostName() {
        return null;
    }

    @Override
    public final String getName() {
        return this.name_d;
    }

    public final void setOU(String ou) {
        this.ou_d = ou;
    }

    public final String getOU() {
        return this.ou_d;
    }

    public final void setPasswd(String passwd) {
        this.passwd_d = passwd;
    }

    public final String getPasswd() {
        return this.passwd_d;
    }

    public void setMail(String mail) {
        this.mail_d = mail;
    }

    public String getMail() {
        return this.mail_d;
    }

    public final void setPrincipal(String principal) {
        this.principal_d = principal;
    }

    public final String getPrincipal() {
        return this.principal_d;
    }

    public final String getProperty(String name) {
        return this.properties_d == null ? null : this.properties_d.getProperty(name);
    }

    public void setReceiveMail(boolean receiveMail) {
        this.receiveMail_d = receiveMail;
    }

    public boolean getReceiveMail() {
        return this.receiveMail_d;
    }

    @Override
    public final String toString() {
        return "[name=" + this.getName() + ", id=" + this.getId() + "]";
    }

    final String getHome() {
        return this.home_d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties() {
        block7: {
            if (this.home_d == null || this.home_d.equals("")) {
                return;
            }
            String propFile = this.home_d + File.separator + ".fuego" + File.separator + ".properties";
            try {
                FileInputStream in = new FileInputStream(propFile);
                try {
                    this.properties_d = new Properties();
                    this.properties_d.load(in);
                }
                finally {
                    in.close();
                }
            }
            catch (FileNotFoundException noFile) {
            }
            catch (IOException err) {
                if (!Log.isDebugging()) break block7;
                Log.logDebug(err + " when reading properties from " + propFile);
                Log.logDebug(err);
            }
        }
    }
}

