/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import oracle.bpm.io.StreamUtils;

public class TypeResource {
    protected byte[] loadedContent;
    protected String loadedText;
    private String contentType;
    private String id;

    protected TypeResource() {
    }

    protected TypeResource(byte[] loadedContent) {
        this.loadedContent = loadedContent;
    }

    protected TypeResource(String loadedText) {
        this.loadedText = loadedText;
    }

    public boolean isBinary() {
        String contentType = this.getContentType();
        return !contentType.startsWith("text/");
    }

    public Object getContent() throws IOException {
        return this.isBinary() ? this.getBinaryContent() : (byte[])this.getTextContent();
    }

    public Reader getContentAsReader() {
        if (this.isBinary()) {
            throw new UnsupportedOperationException("Not supported for binary content");
        }
        if (this.loadedText != null) {
            return new StringReader(this.loadedText);
        }
        throw new UnsupportedOperationException();
    }

    public InputStream getContentAsStream() {
        if (!this.isBinary()) {
            throw new UnsupportedOperationException("Not supported for text content");
        }
        if (this.loadedContent != null) {
            return new ByteArrayInputStream(this.loadedContent);
        }
        throw new UnsupportedOperationException();
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    private byte[] getBinaryContent() throws IOException {
        if (!this.isBinary()) {
            throw new UnsupportedOperationException("Not supported for text content");
        }
        if (this.loadedContent == null) {
            this.loadedContent = this.loadBinary();
        }
        return this.loadedContent;
    }

    private String getTextContent() throws IOException {
        if (this.isBinary()) {
            throw new UnsupportedOperationException("Not supported for binary content");
        }
        if (this.loadedText == null) {
            this.loadedText = this.loadText();
        }
        return this.loadedText;
    }

    private byte[] loadBinary() throws IOException {
        assert (this.isBinary()) : "Must be binary";
        return StreamUtils.readBytes(this.getContentAsStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadText() throws IOException {
        assert (!this.isBinary()) : "Must be text";
        Reader reader = null;
        try {
            int count;
            reader = this.getContentAsReader();
            StringBuffer stringBuffer = new StringBuffer();
            char[] buffer = new char[1024];
            while ((count = reader.read(buffer)) != -1) {
                stringBuffer.append(buffer, 0, count);
            }
            String string = stringBuffer.toString();
            return string;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }
}

