/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.components.ProcessInstance;
import oracle.bpm.lang.Int;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.lang.Time;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.log.Log;
import oracle.bpm.util.ObjectWatch;
import org.jetbrains.annotations.NonNls;

public abstract class TraceableInvokeable
extends Invokeable {
    private static boolean tracing = false;
    private static Map<String, List<String[]>> currentInvocations = null;
    private static Map<String, Map<String, Object>> invocationStatistics = null;
    static final long serialVersionUID = 1309857568609687787L;
    static final long serialCheck = 1399772747826200026L;

    public static void disableTracing() {
        tracing = false;
        currentInvocations = null;
        invocationStatistics = null;
    }

    public static void enableTracing() {
        if (!tracing) {
            tracing = true;
            currentInvocations = new HashMap<String, List<String[]>>();
            invocationStatistics = new HashMap<String, Map<String, Object>>();
            ObjectWatch.register("components", "current_invocations", "Current Invocations", currentInvocations);
            ObjectWatch.register("components", "stats", "Invocations Stats", invocationStatistics);
        }
    }

    @Override
    protected boolean isTracing() {
        return tracing;
    }

    @Override
    protected void beginTrace(@NonNls String method, String component, Time started) {
        String methodName = method.indexOf(")") != -1 ? method.substring(1, method.lastIndexOf(")") - 1) : method;
        Log.logInfo(LibMsg.BEGIN_TRACE(methodName, component));
        ProcessInstance pinst = null;
        try {
            pinst = ProcessInstance.getCurrent();
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        String inst = "";
        String process = "";
        if (pinst != null) {
            if (pinst.processInstanceInterface() != null) {
                inst = pinst.getId().getNumber() + "-";
            }
            process = ProcessInstance.getProcess().getId() + '-';
        }
        String thread = "-" + Thread.currentThread() + "-";
        String invocationKey = process + inst + component + "." + methodName + thread;
        List<String[]> invocations = currentInvocations.get(invocationKey);
        String[] id = new String[2];
        id[1] = started.toString();
        if (invocations != null) {
            String[] s = invocations.get(invocations.size() - 1);
            id[0] = String.valueOf(Integer.parseInt(s[0]) + 1);
            invocations.add(id);
        } else {
            invocations = new ArrayList<String[]>();
            id[0] = "0";
            invocations.add(id);
            currentInvocations.put(invocationKey, invocations);
        }
    }

    @Override
    protected void endTrace(@NonNls String method, String component, Time start) {
        Interval elapsed = Time.now().sub(start);
        ProcessInstance pinst = null;
        try {
            pinst = ProcessInstance.getCurrent();
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        String inst = "";
        String process = "";
        if (pinst != null) {
            if (pinst.processInstanceInterface() != null) {
                inst = pinst.getId().getNumber() + "-";
            }
            process = ProcessInstance.getProcess().getId() + '-';
        }
        String thread = "-" + Thread.currentThread() + "-";
        String methodName = method.indexOf(")") != -1 ? method.substring(1, method.lastIndexOf(")") - 1) : method;
        Log.logInfo(LibMsg.END_TRACE(methodName, component, elapsed.toString()));
        String invocationKey = process + inst + component + "." + methodName + thread;
        List<String[]> invocations = currentInvocations.get(invocationKey);
        if (invocations != null) {
            if (invocations.size() == 1) {
                currentInvocations.remove(invocationKey);
            } else {
                invocations.remove(invocations.size() - 1);
            }
            String statsKey = "Instance".equals(component) ? process + component + "." + methodName : component + "." + methodName;
            Map<String, Object> stats = invocationStatistics.get(statsKey);
            if (stats == null) {
                stats = new HashMap<String, Object>();
                stats.put("max", elapsed);
                stats.put("min", elapsed);
                stats.put("avg", elapsed);
                stats.put("amount", Int.ONE);
                stats.put("total", elapsed);
            } else {
                Interval min;
                Interval max = (Interval)stats.get("max");
                if (elapsed.compareTo(max) > 0) {
                    stats.put("max", elapsed);
                }
                if (elapsed.compareTo(min = (Interval)stats.get("min")) < 0) {
                    stats.put("min", elapsed);
                }
                Integer count = (Integer)stats.get("amount");
                count = Int.inc(count);
                stats.put("amount", count);
                Interval total = (Interval)stats.get("total");
                total = total.add(elapsed);
                stats.put("total", total);
                stats.put("avg", Interval.valueOf(total.getTotalMicroseconds() / (long)count.intValue()));
            }
            invocationStatistics.put(statsKey, stats);
        }
    }
}

