/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.SortedSet;
import oracle.bpm.lang.ArrayDelegate;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.CollectionTypeDescription;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.IllegalTypeException;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.RuntimeExceptionShell;
import oracle.bpm.lang.SuperType;
import oracle.bpm.type.Argument;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SetTypeDescription
extends CollectionTypeDescription {
    @Nullable
    private ObjectTypeDescription objectType;

    public SetTypeDescription(TypeRef elemType, Class setClass) {
        super(19, setClass.getName());
        this.isOrdered = SortedSet.class.isAssignableFrom(setClass);
        this.elementType = elemType;
    }

    public SetTypeDescription(TypeRef elemType, boolean ordered) {
        super(19, ordered ? "java.util.SortedSet" : "java.util.Set");
        this.isOrdered = ordered;
        this.elementType = elemType;
    }

    private SetTypeDescription(String elemText, ComponentCatalog catalog, boolean ordered) throws IllegalTypeException {
        super(19, ordered ? "java.util.SortedSet" : "java.util.Set");
        assert (elemText != null);
        this.elementText = elemText;
        this.catalog = catalog;
    }

    public static SetTypeDescription createLazySet(String elemText, ComponentCatalog catalog) throws IllegalTypeException {
        return new SetTypeDescription(elemText, catalog, false);
    }

    @Override
    public String getImplementationType() {
        return this.isOrdered() ? "java.util.TreeSet" : "java.util.LinkedHashSet";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public ObjectTypeDescription asObject() {
        ObjectTypeDescription result = this.objectType;
        if (result == null) {
            this.objectType = result = new SetObjectTypeDescription(this.getText());
            result.addSyntheticMethods();
            result.setSuperTypes(SuperType.getAnySuperTypeList());
        }
        ObjectTypeDescription objectTypeDescription = result;
        if (objectTypeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/SetTypeDescription.asObject must not return null");
        }
        return objectTypeDescription;
    }

    private class SetObjectTypeDescription
    extends ObjectTypeDescription {
        SetObjectTypeDescription(String text) {
            super(text, 11, false);
        }

        @Override
        public Class getJavaClass() {
            return SetTypeDescription.this.getJavaClass();
        }

        @Override
        public String getJavaType() {
            return "oracle.bpm.lang.ArrayDelegate";
        }

        @Override
        public Object invokeMethod(String methodSignature, Object target, Object[] args) throws ComponentExecutionException {
            String methodName;
            Set set = (Set)target;
            String delegated = null;
            if (methodSignature.charAt(0) == 'L') {
                int index = methodSignature.indexOf(59);
                delegated = methodSignature.substring(0, index);
                methodSignature = methodSignature.substring(index + 1);
            }
            if ("remove".equals(methodName = JavaClass.getMethodNameFromSignature(methodSignature))) {
                set.remove(args[0]);
                return null;
            }
            if (delegated != null) {
                Class<ArrayDelegate> cl = ArrayDelegate.class;
                Class[] argTypes = new Class[]{Set.class};
                try {
                    Method m = cl.getMethod(methodName, argTypes);
                    return m.invoke(null, args);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeExceptionShell(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeExceptionShell(e);
                }
                catch (InvocationTargetException e) {
                    throw new ComponentExecutionException(e, cl, methodName);
                }
            }
            throw new RuntimeException("No such method: " + methodSignature);
        }

        @Override
        protected void addSyntheticMethods() {
            AttributeTypeDescription attribute = new AttributeTypeDescription("length", TypeFactory.getPrimitiveInt(32), 8L);
            attribute.setReadSignature("Msize()I");
            this.addMember(attribute);
            MethodTypeDescription method = new MethodTypeDescription("delete");
            method.setResultType(TypeFactory.getVoid());
            method.setSignature("Mremove(Ljava.lang.Object;)V");
            method.addArgument(new Argument("element", SetTypeDescription.this.getElementType(), 1L));
            this.addMember(method);
            method = new MethodTypeDescription("length");
            method.setModifiers(0x800000L);
            method.setResultType(TypeFactory.getPrimitiveInt(32));
            String delegated = "Loracle.bpm.lang.ArrayDelegate;";
            method.setSignature("Loracle.bpm.lang.ArrayDelegate;Mlength(Ljava.util.Set;)I");
            this.addMember(method);
            this.addMember(this.createClearMethod());
        }

        private MethodTypeDescription createClearMethod() {
            MethodTypeDescription method = new MethodTypeDescription("clear");
            method.setModifiers(0x800000L);
            method.setResultType(TypeFactory.getVoid());
            String delegated = "Loracle.bpm.lang.ArrayDelegate;";
            method.setSignature("Loracle.bpm.lang.ArrayDelegate;Mclear(Ljava.util.Set;)V");
            return method;
        }
    }
}

