/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.component.Component;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.DescriptionEnabled;
import oracle.bpm.lang.EnumTypeDescription;
import oracle.bpm.lang.Id;
import oracle.bpm.lang.Initialization;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.JavaClassResolver;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.Module;
import oracle.bpm.lang.Name;
import oracle.bpm.lang.NameString;
import oracle.bpm.lang.PropertyBag;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.TypeResource;
import oracle.bpm.type.AmbiguousTypeNameException;
import oracle.bpm.type.Argument;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeFinder;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.type.impl.TypeDescriptionImpl;
import oracle.bpm.util.MemberUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectTypeDescription
extends TypeDescriptionImpl
implements DescriptionEnabled,
PropertyBag {
    protected String name;
    protected TypeRef parent;
    private long classModifiers;
    private String componentType;
    private Set<TypeRef> declaredDependencies;
    private String description;
    private TypeRef elementType;
    private List<TypeRef> innerTypes;
    private Class javaclass;
    private JavaClassResolver javaClassResolver;
    private long lastModifiedTime;
    private ComponentCatalog loader;
    private boolean localEnabled;
    private StringList memberNames;
    private List<MethodTypeDescription> memberTypes;
    private Map<String, String> properties;
    private TypeRef ref;
    private boolean remote;
    private List<TypeResource> resources;
    private String signature;
    private List<SuperType> superTypes;
    private Map<String, Object> transientProperties;
    private Map<String, String> unmodifiableUsages;
    private Map<String, String> usages;
    private String versionID;
    public static final String TYPE_ID = "typeId";
    public static final String SUPERTYPE_PROPERTY = "superType";
    public static final String DESCRIPTION_PROPERTY = "description";
    private static final String CATALOG_OBJECT_TYPE_ID = "object";
    public static final NameComparator NAME_COMPARATOR = new NameComparator();
    public static final AttributeByPosition ATTRIBUTE_BY_POSITION_COMPARATOR = new AttributeByPosition();
    private static AttributeTypeDescription TIMEOUT_ATTRIBUTE;
    public static final String TIMEOUT_NAME = "timeout";
    public static final String TIMEOUT_SIGNATURE = "Atimeout;";
    public static final String GENERATE_STUBS = "generateStubs";
    public static final String GENERATE_BIT_SETS = "generateBitSets";
    public static final String JAVA_PACKAGE = "package";
    public static final String JAVA_PACKAGE_PREFIX = "packagePrefix";
    public static final String JAVA_CLASS_NAME = "javaClassName";
    public static final String INVOKEABLE_CLASS_NAME = "invokeableClassName";
    public static final String SERIAL_VERSION_ID = "javaSerialId";
    public static final String METHOD_PREFIX = "methodPrefix";
    public static final String CONFIGURATION_NAME = "configName";
    public static final String EJB_JCL_CONFIG_NAME = "jclConfigName";
    public static final String EJB_HOME = "ejbHome";
    public static final String INIT_ALL_FIELDS = "initAllFields";
    public static final String NATIVE_NAME = "nativeName";
    public static final String CUSTOMIZE_READ_OBJECT = "customizeReadObject";
    public static final String CUSTOMIZE_OBJECT_SERIALIZATION = "customizeObjectSerialization";

    public ObjectTypeDescription(@NotNull String cName) {
        if (cName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/ObjectTypeDescription.<init> must not be null");
        }
        this(cName, 11, false);
    }

    public ObjectTypeDescription(@NotNull String cName, int kind, boolean primitive) {
        if (cName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/ObjectTypeDescription.<init> must not be null");
        }
        this(cName, kind, -1, primitive);
    }

    protected ObjectTypeDescription(@NotNull String cName, int kind, int scale, boolean primitive) {
        if (cName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/ObjectTypeDescription.<init> must not be null");
        }
        super(kind, -1, scale, primitive);
        this.componentType = CATALOG_OBJECT_TYPE_ID;
        this.declaredDependencies = new HashSet<TypeRef>();
        this.description = "";
        this.localEnabled = true;
        this.memberNames = StringList.create();
        this.memberTypes = new ArrayList<MethodTypeDescription>();
        this.name = cName;
    }

    public final void setCatalog(ComponentCatalog catalog) {
        this.loader = catalog;
    }

    @Override
    public final ComponentCatalog getCatalog() {
        ComponentCatalog result = this.loader;
        if (result == null && this.isInnerType()) {
            result = this.getParent().getCatalog();
        }
        return result;
    }

    public Set<TypeRef> getDependencies() {
        MethodTypeDescription[] members;
        HashSet<TypeRef> dependencies = new HashSet<TypeRef>();
        for (SuperType superType : this.getSuperTypes()) {
            dependencies.add(superType.getTypeRef());
        }
        for (MethodTypeDescription member : members = this.getMembers(10)) {
            for (Argument arg : member.getArguments()) {
                dependencies.add(arg.getTypeRef());
            }
            dependencies.add(member.getResultArgument().getTypeRef());
        }
        if (this.isInnerType()) {
            dependencies.add(this.getParentRef());
        }
        dependencies.addAll(this.declaredDependencies);
        return dependencies;
    }

    public void declareDependency(TypeRef dependency) {
        if ((dependency = dependency.getRef()) instanceof TypeDescription) {
            TypeRef[] parameters;
            TypeDescription type = dependency.get();
            TypeDescription eType = type.getElementType();
            TypeDescription iType = type.getIndexType();
            if (eType != null) {
                this.declareDependency(eType);
            }
            if (iType != null) {
                this.declareDependency(iType);
            }
            if ((parameters = dependency.get().getTypeParameters()) != null) {
                for (TypeRef param : parameters) {
                    this.declareDependency(param);
                }
            }
        } else {
            this.declaredDependencies.add(dependency);
        }
    }

    @Override
    public boolean isEnum() {
        return super.isEnum() || this.findEnumTD() != null;
    }

    @Override
    public EnumTypeDescription asEnum() {
        TypeDescription enumTD;
        if (!super.isEnum() && (enumTD = this.findEnumTD()) != null) {
            return enumTD.asEnum();
        }
        return super.asEnum();
    }

    public void removeDependency(TypeRef dependency) {
        this.declaredDependencies.remove(dependency);
    }

    public void clearDeclaredDependencies() {
        this.declaredDependencies.clear();
    }

    public final boolean isDefault() {
        return TypeUtils.belongsToDefaultCatalog(this);
    }

    public void setElementType(TypeRef ref) {
        this.elementType = ref;
    }

    @Override
    public boolean isOrdered() {
        return super.isOrdered() || this.isJavaSortedMap();
    }

    @Override
    public boolean isMap() {
        return super.isMap() || this.isJavaMap();
    }

    @Override
    public boolean isArray() {
        return super.isArray() || this.isJavaList() || this.isJavaMap();
    }

    @Override
    public TypeDescription getIndexType() {
        if (this.isJavaMap()) {
            TypeRef[] parameters = this.getTypeParameters();
            return parameters != null && parameters.length > 0 ? parameters[0].get() : TypeFactory.getAny();
        }
        return super.getIndexType();
    }

    @Override
    public TypeDescription getElementType() {
        if (this.elementType == null) {
            TypeRef[] parameters = this.getTypeParameters();
            this.elementType = this.isJavaMap() ? (parameters != null && parameters.length > 1 ? parameters[1] : TypeFactory.getAny()) : (this.isJavaList() ? (parameters != null && parameters.length > 0 ? parameters[0] : TypeFactory.getAny()) : super.getElementType());
        }
        return this.elementType == null ? null : this.elementType.get();
    }

    public boolean hasConstructors() {
        return this.getMemberIndex(this.getName()) != -1;
    }

    @Override
    public TypeRef getElementTypeRef() {
        return this.elementType;
    }

    @Override
    public boolean isXmlObject() {
        return ComponentType.XML.getText().equals(this.getComponentType());
    }

    @Override
    public final String getId() {
        return this.getProperty(TYPE_ID);
    }

    public void setLastModifiedTime(long lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    @Override
    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final void setLocalEnabled(boolean enabled) {
        this.localEnabled = enabled;
    }

    public final boolean isLocalEnabled() {
        return this.localEnabled;
    }

    public final MethodTypeDescription getMemberBySignature(String sgn) {
        MethodTypeDescription result = null;
        if (sgn != null) {
            int count = this.getMemberCount();
            block0: for (int i = 0; i < count; ++i) {
                MethodTypeDescription member = this.getMember(i);
                do {
                    if (!Any.equals(sgn, member.getSignature()) && !Any.equals(sgn, member instanceof AttributeTypeDescription ? member.asAttribute().getWriteSignature() : null)) continue;
                    result = member;
                    continue block0;
                } while ((member = member.getNextMethod()) != null);
            }
        }
        return result;
    }

    @Override
    public final long getModifiers() {
        return this.classModifiers;
    }

    public void addModifier(long modifier) {
        this.setModifiers(this.getModifiers() | modifier);
    }

    @Override
    public final void setProperty(String name, String value) {
        assert (!name.equals(CONFIGURATION_NAME) || !ComponentType.XML.getText().equals(this.getComponentType()));
        if (value == null) {
            this.getProperties().remove(name);
        } else {
            this.getProperties().put(name, value);
        }
    }

    public Object getTransientProperty(String key) {
        return this.getTransientProperties().get(key);
    }

    public void setTransientProperty(String key, Object value) {
        this.getTransientProperties().put(key, value);
    }

    public Map<String, Object> getTransientProperties() {
        if (this.transientProperties == null) {
            this.transientProperties = new TreeMap<String, Object>();
        }
        return this.transientProperties;
    }

    public void setTransientProperties(Map<String, Object> properties) {
        this.transientProperties = properties;
    }

    @Override
    public final String getProperty(String nm) {
        return this.properties == null ? null : this.properties.get(nm);
    }

    @Override
    public boolean isComparable(TypeDescription type) {
        return this.equals(type) && Modifier.isComparable(this.getModifiers());
    }

    public final void setComponentType(@NotNull String componentType) {
        if (componentType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/ObjectTypeDescription.setComponentType must not be null");
        }
        this.componentType = componentType;
    }

    @Override
    public final String getComponentType() {
        return this.componentType;
    }

    @Override
    public final void setDescription(String desc) {
        if (!Any.equals(this.description, desc)) {
            this.description = desc;
            this.firePropertyChanged(DESCRIPTION_PROPERTY);
            this.fireTypeChanged();
        }
    }

    @Override
    public final String getDescription() {
        return this.description;
    }

    @Override
    public final boolean isInvokeable() {
        return Modifier.isInvokeable(this.getModifiers());
    }

    public final void setId(String id) {
        this.setProperty(TYPE_ID, id);
    }

    public final ObjectTypeDescription getInnerType(int index) {
        TypeRef type = this.getInnerTypeRef(index);
        return type.get().asObject();
    }

    public final int getInnerTypeCount() {
        return this.innerTypes != null ? this.innerTypes.size() : 0;
    }

    public boolean hasInnerTypes() {
        return this.getInnerTypeCount() > 0;
    }

    public final TypeRef getInnerTypeRef(int index) {
        if (this.innerTypes == null || index < 0 || index >= this.innerTypes.size()) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return this.innerTypes.get(index);
    }

    public List<TypeRef> getInnerTypeRefs() {
        if (this.innerTypes == null) {
            return Collections.emptyList();
        }
        return this.innerTypes;
    }

    @Override
    public final boolean isInterface() {
        return Modifier.isInterface(this.classModifiers);
    }

    public final boolean isRemoteEnabled() {
        return ComponentType.JAVA.getText().equals(this.getComponentType());
    }

    public final TypeResource getResource(int index) {
        return this.resources.get(index);
    }

    public final int getResourceCount() {
        return this.resources != null ? this.resources.size() : 0;
    }

    public final void addResource(TypeResource resource) {
        if (this.resources == null) {
            this.resources = new ArrayList<TypeResource>();
        }
        this.resources.add(resource);
    }

    public final void addUsage(String typeName) {
        if (this.usages == null) {
            this.usages = new TreeMap<String, String>();
        }
        this.usages.put(this.name, TypeUtils.shortName(typeName));
    }

    public final String findUsage(String nm) {
        return this.usages != null ? this.usages.get(nm) : null;
    }

    public Map<String, String> getUsages() {
        Map<String, String> result;
        if (this.usages == null) {
            result = Collections.emptyMap();
        } else {
            if (this.unmodifiableUsages == null) {
                this.unmodifiableUsages = Collections.unmodifiableMap(this.usages);
            }
            result = this.unmodifiableUsages;
        }
        return result;
    }

    @Override
    public boolean isCloneable() {
        return Modifier.isCloneable(this.classModifiers) && !this.isRemote();
    }

    public boolean isComparable() {
        return Modifier.isComparable(this.getModifiers());
    }

    public final void setJavaClass(Class javaclass) {
        this.javaclass = javaclass;
    }

    public void setJavaClassResolver(JavaClassResolver javaClassResolver) {
        this.javaClassResolver = javaClassResolver;
    }

    public MethodTypeDescription getMember(int memberIndex) {
        assert (this.existsMember(memberIndex)) : "Index out of bound: " + memberIndex + ", type: " + this.getText() + ", memberCount: " + this.getMemberCount();
        MethodTypeDescription result = this.memberTypes.get(memberIndex);
        assert (this.checkMemberName(memberIndex, result)) : "Member has not the expected name: " + result + " != " + (String)this.memberNames.get(memberIndex);
        return result;
    }

    public final MethodTypeDescription getMember(String nm, int requiredKind) {
        int memberIndex = this.getMemberIndex(nm, requiredKind);
        return memberIndex != -1 ? this.getMember(memberIndex) : null;
    }

    public Object getAttributeValue(String sgn, Object target) throws ComponentExecutionException {
        if (target instanceof Invokeable) {
            Invokeable object = (Invokeable)target;
            return object.getAttributeValue(sgn);
        }
        return null;
    }

    public String getJavaPackage() {
        String javaPackage = this.getProperty(JAVA_PACKAGE);
        if (javaPackage == null) {
            TypeDescription parentType = this.getParent();
            javaPackage = parentType != null ? parentType.getText() : null;
            String prefix = this.getProperty(JAVA_PACKAGE_PREFIX);
            if (prefix != null) {
                javaPackage = Str.isEmpty(javaPackage) ? prefix : prefix + '.' + javaPackage;
            }
        }
        return javaPackage;
    }

    @Override
    public String getJavaSignature() {
        return 'L' + this.getJavaType() + ';';
    }

    @Override
    public MethodTypeDescription getMemberType(int number) {
        return this.getMember(number);
    }

    public final MethodTypeDescription getMemberTypeBySignature(String sgn) {
        if (sgn != null) {
            Iterator<MethodTypeDescription> i$ = this.memberTypes.iterator();
            while (i$.hasNext()) {
                for (MethodTypeDescription current = i$.next(); current != null; current = current.getNextMethod()) {
                    if (Any.equals(sgn, current.getSignature())) {
                        return current;
                    }
                    if (!current.isAttribute() || !Any.equals(sgn, current.asAttribute().getWriteSignature())) continue;
                    return current;
                }
            }
        }
        return null;
    }

    public final MethodTypeDescription[] getMemberTypes(int reqKind, long includeFlags, long excludeFlags) {
        ArrayList<MethodTypeDescription> array = new ArrayList<MethodTypeDescription>();
        int count = this.getMemberCount();
        for (int i = 0; i < count; ++i) {
            for (MethodTypeDescription current = this.getMember(i); current != null; current = current.getNextMethod()) {
                boolean mustInclude;
                long m = current.getModifiers();
                boolean bl = mustInclude = includeFlags == 0L || (m & includeFlags) != 0L;
                if (!mustInclude || (m & excludeFlags) != 0L || current.getKind() != reqKind && reqKind != -1) continue;
                array.add(current);
            }
        }
        return array.toArray(new MethodTypeDescription[array.size()]);
    }

    public final MethodTypeDescription[] getMembers(int requiredKind) {
        return this.getMembers(requiredKind, 0L, 0L);
    }

    public final MethodTypeDescription[] getMembers(int reqKind, long includeFlags, long excludeFlags) {
        ArrayList<MethodTypeDescription> result = new ArrayList<MethodTypeDescription>();
        for (MethodTypeDescription mtd : this.memberTypes) {
            long m = mtd.getModifiers();
            boolean mustInclude = includeFlags == 0L || (m & includeFlags) != 0L;
            if (!mustInclude || (m & excludeFlags) != 0L || mtd.getKind() != reqKind && reqKind != -1) continue;
            result.add(mtd);
        }
        return result.toArray(new MethodTypeDescription[result.size()]);
    }

    public final MethodTypeDescription[] getMembers(int reqKind, long includeFlags, long excludeFlags, TypeFinder.Scope scope) {
        return this.getMembers(reqKind, includeFlags, excludeFlags, scope, false);
    }

    public final MethodTypeDescription[] getMembers(int reqKind, long includeFlags, long excludeFlags, TypeFinder.Scope scope, boolean excludeHiddenSuperTypes) {
        MethodTypeDescription[] members;
        ArrayList<MethodTypeDescription> allMembers = new ArrayList<MethodTypeDescription>();
        if (scope.isCurrent()) {
            members = this.getMembers(reqKind, includeFlags, excludeFlags);
            allMembers.addAll(Arrays.asList(members));
        }
        if (scope.isInherited()) {
            for (SuperType superType : this.getSuperTypes()) {
                if (superType.isDelegated() || excludeHiddenSuperTypes && superType.isHidden()) continue;
                members = superType.getObjectType().getMembers(reqKind, includeFlags, excludeFlags, TypeFinder.Scope.DEFAULT);
                allMembers.addAll(Arrays.asList(members));
            }
        }
        if (scope.isDelegated()) {
            for (SuperType superType : this.getSuperTypes()) {
                if (!superType.isDelegated() || excludeHiddenSuperTypes && superType.isHidden()) continue;
                members = superType.getObjectType().getMembers(reqKind, includeFlags, excludeFlags, TypeFinder.Scope.DEFAULT);
                allMembers.addAll(Arrays.asList(members));
            }
        }
        return allMembers.toArray(new MethodTypeDescription[allMembers.size()]);
    }

    public void setModifiers(long modifiers) {
        this.classModifiers = modifiers;
        this.fireTypeChanged();
    }

    public Module getModule() {
        return null;
    }

    public final void setName(String name) {
        MethodTypeDescription mtd;
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        String currentName = this.getName();
        if (!Any.equals(name, currentName) && (mtd = this.getMember(this.getName(), 14)) != null) {
            this.renameMember(mtd, name);
            while (mtd != null) {
                mtd.setResultType(this);
                mtd = mtd.getNextMethod();
            }
        }
        if (this.parent != null) {
            ObjectTypeDescription objType = this.parent.get().asObject();
            TypeRef foundType = objType.findInnerType(name);
            if (foundType != null && foundType.equals(this)) {
                objType.removeInnerType(this);
                this.name = name;
                objType.addInnerType(this);
            } else {
                this.name = name;
            }
        } else {
            this.name = name;
        }
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final TypeRef getParentRef() {
        return this.parent;
    }

    @Override
    public int getNextMemberIndex(String nm, int from, int requiredKind) {
        int index = this.indexOf(nm, from + 1);
        return index < 0 ? -1 : this.searchMember(index, nm, requiredKind);
    }

    public void setParent(TypeRef parent) {
        if (parent == this) {
            throw new IllegalArgumentException(parent.toString());
        }
        this.parent = parent;
    }

    @Override
    public void setProperties(Map<String, String> map) {
        this.properties = map;
    }

    @Override
    public Map<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new TreeMap<String, String>();
        }
        return this.properties;
    }

    public final void setRemote(boolean remote) {
        MethodTypeDescription member;
        this.remote = remote;
        if (remote) {
            this.addModifier(0x10000000L);
        }
        if (TIMEOUT_ATTRIBUTE == null) {
            TIMEOUT_ATTRIBUTE = new AttributeTypeDescription(TIMEOUT_NAME, TypeFactory.getInterval(), 0x100000004L);
            TIMEOUT_ATTRIBUTE.setWriteSignature(TIMEOUT_SIGNATURE);
            TIMEOUT_ATTRIBUTE.setSignature(TIMEOUT_SIGNATURE);
            TIMEOUT_ATTRIBUTE.setDescription("The period of time the method runs until timeout occurs");
        }
        int index = this.indexOf(TIMEOUT_NAME, 0);
        if (this.isRemote() && index < 0) {
            AttributeTypeDescription member2 = TIMEOUT_ATTRIBUTE.clone();
            member2.setParent(null);
            this.addMember(member2);
        } else if (index >= 0 && (member = this.getMember(index)).hasModifiers(0x100000000L)) {
            this.removeMember(index);
        }
    }

    public final boolean isRemote() {
        return this.remote;
    }

    public final void setSignature(String signature) {
        this.signature = signature;
    }

    public String getConfigName() {
        TypeDescription parentType;
        String config = this.getProperty(CONFIGURATION_NAME);
        if (config == null && (parentType = this.getParent()) != null) {
            config = parentType.asObject().getConfigName();
        }
        return config;
    }

    public String getFuegoPackageName(TypeDescription typeDesc) {
        String ret = "";
        TypeDescription parentType = typeDesc.getParent();
        if (parentType != null && parentType != this) {
            ret = this.getFuegoPackageName(parentType) + '.';
        }
        return ret + typeDesc.getName();
    }

    @Override
    public String getJavaType() {
        String javaClass = this.getProperty(JAVA_CLASS_NAME);
        if (javaClass != null) {
            return javaClass;
        }
        if (this.isInvokeable()) {
            return Invokeable.class.getName();
        }
        String result = null;
        String pkg = this.getJavaPackage();
        if (pkg != null) {
            String type;
            String separator = ".";
            TypeDescription parentType = this.getParent();
            String string = type = parentType != null ? parentType.asObject().getComponentType() : null;
            if (ComponentType.XOBJECT.getText().equals(type)) {
                separator = "$";
            }
            result = pkg + separator + this.getName();
        }
        return result;
    }

    public String getNativeName() {
        return this.getProperty(NATIVE_NAME);
    }

    public void setNativeName(String nativeName) {
        this.setProperty(NATIVE_NAME, nativeName);
    }

    @Override
    public String getQualifiedName() {
        return this.getText();
    }

    @Override
    public String getSignature() {
        return this.signature != null ? this.signature : this.getName();
    }

    @Override
    public List<SuperType> getSuperTypes() {
        if (this.superTypes != null) {
            return this.superTypes;
        }
        return Collections.emptyList();
    }

    public final void setSuperTypes(SuperType[] superTypes) {
        ArrayList<SuperType> list = new ArrayList<SuperType>();
        list.addAll(Arrays.asList(superTypes));
        this.setSuperTypes(list);
    }

    public final void setSuperTypes(List<SuperType> superTypes) {
        this.superTypes = superTypes;
        this.fireRelationAdded(SUPERTYPE_PROPERTY, null);
    }

    public final void removeAllSuperTypes() {
        if (this.superTypes != null) {
            this.superTypes.clear();
        }
        this.fireRelationRemoved(SUPERTYPE_PROPERTY, null);
    }

    public final void setVersionID(String vid) {
        this.versionID = vid;
    }

    public final String getVersionID() {
        String result = this.versionID;
        if (Str.isEmpty(result)) {
            result = Id.getTypeVersionId();
        }
        return result;
    }

    public final String getOriginalVersionID() {
        return this.versionID;
    }

    public void setRef(TypeRef ref) {
        this.ref = ref;
    }

    @Override
    public TypeRef getRef() {
        return this.ref != null ? this.ref : this;
    }

    public final int addInnerType(@NotNull TypeRef type) {
        int insertPoint;
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/ObjectTypeDescription.addInnerType must not be null");
        }
        assert (type != this) : "Cannot add '" + type.getText() + "' to itself.";
        if (this.innerTypes == null) {
            this.innerTypes = new ArrayList<TypeRef>();
        }
        if ((insertPoint = Collections.binarySearch(this.innerTypes, type, NAME_COMPARATOR)) >= 0) {
            throw new IllegalArgumentException("Attempt to add duplicated inner type '" + type.getText() + "' to '" + this.getText() + "'");
        }
        insertPoint = -insertPoint - 1;
        this.innerTypes.add(insertPoint, type.getRef());
        if (type instanceof ObjectTypeDescription) {
            ObjectTypeDescription otd = (ObjectTypeDescription)type;
            otd.setParent(this.getRef());
            if (otd.getCatalog() == null) {
                otd.setCatalog(this.getCatalog());
            }
        }
        this.fireTypeChanged();
        return insertPoint;
    }

    public void setAttributeValue(String signature, Object value, Object target) throws ComponentExecutionException {
        if (target instanceof Invokeable) {
            Invokeable object = (Invokeable)target;
            object.setAttributeValue(signature, value);
        }
    }

    @Override
    public String getText() {
        String parentText;
        String text = this.getName();
        TypeRef parentType = this.getParentRef();
        if (parentType != null && (parentText = parentType.getText()) != null && parentText.length() > 0) {
            text = parentText.concat(".").concat(text);
        }
        return text;
    }

    public void addMember(MethodTypeDescription member) {
        this.addMember(member, true);
    }

    public void addSuperType(SuperType superType) {
        if (this.superTypes == null) {
            this.superTypes = new ArrayList<SuperType>(3);
        }
        this.superTypes.add(superType);
        superType.setParent(this);
        this.fireRelationAdded(SUPERTYPE_PROPERTY, superType);
        this.fireTypeChanged();
    }

    public final void removeSuperType(SuperType superType) {
        this.getSuperTypes().remove(superType);
        this.fireRelationRemoved(SUPERTYPE_PROPERTY, superType);
        this.fireTypeChanged();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public ObjectTypeDescription asObject() {
        ObjectTypeDescription objectTypeDescription = this;
        if (objectTypeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/ObjectTypeDescription.asObject must not return null");
        }
        return objectTypeDescription;
    }

    public final MethodTypeDescription createConstructor() {
        MethodTypeDescription mtd = new MethodTypeDescription(this.getName(), 64L);
        mtd.setResultType(this);
        mtd.setSignature('K' + this.getJavaType() + "()");
        return mtd;
    }

    @Override
    public ObjectTypeDescription clone() {
        ObjectTypeDescription target = (ObjectTypeDescription)super.clone();
        target.memberNames = this.memberNames.clone();
        target.memberTypes = new ArrayList<MethodTypeDescription>();
        for (MethodTypeDescription method : this.memberTypes) {
            MethodTypeDescription mtd = method.clone();
            mtd.setParent(target);
            target.memberTypes.add(mtd);
        }
        if (this.superTypes != null) {
            target.superTypes = new ArrayList<SuperType>();
            for (SuperType superType : this.superTypes) {
                target.superTypes.add(superType.clone());
            }
        }
        target.classModifiers = this.classModifiers;
        target.componentType = this.componentType;
        target.description = this.description;
        target.documentation = this.documentation == null ? null : this.documentation.clone();
        target.useCaseDocumentation = this.useCaseDocumentation == null ? null : this.useCaseDocumentation.clone();
        target.elementType = this.elementType;
        target.javaclass = this.javaclass;
        target.loader = this.loader;
        target.localEnabled = this.localEnabled;
        target.innerTypes = null;
        target.properties = this.properties == null ? null : new TreeMap<String, String>(this.properties);
        target.parent = null;
        target.ref = null;
        target.remote = this.remote;
        target.resources = this.resources == null ? null : new ArrayList<TypeResource>(this.resources);
        target.signature = this.signature;
        target.versionID = this.versionID;
        return target;
    }

    @Override
    public boolean isBpmObject() {
        return ComponentType.XOBJECT.getText().equals(this.getComponentType());
    }

    @Override
    public boolean equality(TypeDescription type) {
        return type.isAssignableFrom(this) || this.isAssignableFrom(type) || super.equality(type);
    }

    @Override
    public boolean equals(Object value) {
        if (this == value) {
            return true;
        }
        if (value == null) {
            return false;
        }
        if (!(value instanceof ObjectTypeDescription)) {
            return false;
        }
        ObjectTypeDescription type = (ObjectTypeDescription)value;
        return this.getKind() == type.getKind() && this.getText().equals(type.getText()) && this.getComponentType().equals(type.getComponentType());
    }

    @Override
    public boolean equivalent(TypeDescription type) {
        return this.equals(type);
    }

    public final boolean existsMember(int number) {
        return number >= 0 && number < this.getMemberCount();
    }

    @Override
    public Initialization getInitialization() {
        return this.hasDefaultInit() && this.getJavaType() != null ? Initialization.DEFAULT_CONSTRUCTOR : Initialization.NULL;
    }

    public Class getJavaClass() {
        if (this.javaclass == null) {
            try {
                String javaType = this.getJavaType();
                if (javaType != null) {
                    JavaClassResolver resolver = this.getJavaClassResolver();
                    this.javaclass = resolver != null ? resolver.resolve(javaType) : JavaClass.loadByJavaType(javaType);
                }
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Could not load '" + this.getJavaType() + "'");
            }
        }
        return this.javaclass;
    }

    public JavaClassResolver getJavaClassResolver() {
        return this.javaClassResolver;
    }

    public AttributeTypeDescription findAttributeByPosition(int position) {
        AttributeTypeDescription result = null;
        int count = this.getMemberCount();
        for (int i = 0; i < count; ++i) {
            AttributeTypeDescription attr;
            MethodTypeDescription member = this.getMemberType(i);
            if (!member.isAttribute() || (attr = member.asAttribute()).getPosition() != position) continue;
            result = attr;
            break;
        }
        return result;
    }

    public final TypeRef findInnerType(String nm) {
        TypeRef type;
        block3: {
            int dot;
            block2: {
                if (this.innerTypes == null) {
                    return null;
                }
                dot = nm.indexOf(46);
                type = null;
                if (dot != -1) break block2;
                int index = Collections.binarySearch(this.innerTypes, new NameString(nm), NAME_COMPARATOR);
                if (index < 0) break block3;
                type = this.innerTypes.get(index);
                break block3;
            }
            int count = this.getInnerTypeCount();
            for (int i = 0; i < count; ++i) {
                TypeRef innerType = this.getInnerTypeRef(i);
                String innerName = innerType.getName();
                if (!nm.startsWith(innerName) || !nm.substring(0, dot).equals(innerName)) continue;
                ObjectTypeDescription otd = innerType.get().asObject();
                type = otd.findInnerType(nm.substring(dot + 1));
                break;
            }
        }
        return type;
    }

    public int findNewPosition() {
        int position = 1;
        for (MethodTypeDescription member : this.getMembers(18)) {
            position = Math.max(position, member.asAttribute().getPosition() + 1);
        }
        return position;
    }

    @Override
    public boolean hasDefaultInit() {
        MethodTypeDescription constr = this.getMember(this.getName(), 14);
        return !this.isInterface() && !this.isAbstract() && constr != null && constr.getArgumentCount() == 0 && !Modifier.isPrivate(constr.getModifiers());
    }

    public boolean hasPrimaryKey() {
        int count = this.getMemberCount();
        for (int i = 0; i < count; ++i) {
            MethodTypeDescription member = this.getMember(i);
            if (!Modifier.isPrimaryKey(member.getModifiers())) continue;
            return true;
        }
        return false;
    }

    public void invalidate() {
        this.parent = null;
        this.superTypes = null;
        this.memberNames.clear();
        this.memberTypes.clear();
        this.innerTypes = null;
        this.loader = null;
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        List<StackTraceElement> stack = Arrays.asList(stackTrace);
        String stackString = stack.toString().replaceAll(",", "\n\t");
        this.setName("INVALIDATED_REFERENCE_TO<" + this.getName() + "> Invalidated at: \n\t" + stackString);
    }

    @Override
    public Object invokeMethod(String methodSignature, Object target, Object[] args) throws ComponentExecutionException {
        Object result = null;
        if (target instanceof Invokeable) {
            Invokeable object = (Invokeable)target;
            try {
                result = object.invoke(methodSignature, args);
            }
            catch (InvocationTargetException e) {
                throw new ComponentExecutionException(e, this.getName(), JavaClass.getMethodNameFromSignature(methodSignature));
            }
        }
        Class cl = target != null ? target.getClass() : this.getJavaClass();
        try {
            if (cl == null) {
                throw new IllegalStateException("Could not load java class for '" + this.getText() + "'");
            }
            if (methodSignature.charAt(0) == 'L') {
                cl = MemberUtils.delegateCall(methodSignature, cl);
                methodSignature = methodSignature.substring(methodSignature.indexOf(";") + 1);
            }
            JavaClass jclass = JavaClass.fromClass(cl);
            switch (methodSignature.charAt(0)) {
                case 'K': {
                    result = jclass.newInstance(methodSignature, args);
                    break;
                }
                case 'A': {
                    if (args == null || args.length == 0) {
                        result = jclass.getAttributeValue(methodSignature, target);
                        break;
                    }
                    jclass.setAttributeValue(methodSignature, args[0], target);
                    result = null;
                    break;
                }
                case 'M': {
                    result = jclass.invokeMethod(target, methodSignature, args);
                    break;
                }
                default: {
                    assert (false) : methodSignature;
                    break;
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new ComponentExecutionException(e, this.getName(), JavaClass.getMethodNameFromSignature(methodSignature));
        }
        catch (IllegalStateException e) {
            throw new ComponentExecutionException(e, this.getName(), JavaClass.getMethodNameFromSignature(methodSignature));
        }
        catch (IllegalArgumentException e) {
            throw new ComponentExecutionException(e, this.getName(), JavaClass.getMethodNameFromSignature(methodSignature));
        }
        catch (InvocationTargetException e) {
            throw new ComponentExecutionException(e, this.getName(), JavaClass.getMethodNameFromSignature(methodSignature));
        }
        catch (NoSuchMethodException e) {
            throw new ComponentExecutionException(e, this.getName(), JavaClass.getMethodNameFromSignature(methodSignature));
        }
        catch (InstantiationException e) {
            throw new ComponentExecutionException(e, this.getName(), JavaClass.getMethodNameFromSignature(methodSignature));
        }
        return result;
    }

    @Override
    public Object newInstance() throws ComponentExecutionException {
        try {
            if (this.isInvokeable()) {
                MethodTypeDescription constructor = this.findMember(this.getName());
                String config = this.getConfigName();
                String className = this.getSignature();
                return Component.instantiateDynamic(this.getComponentType(), config, this.getText(), className, constructor.getSignature(), null);
            }
            Class cl = this.getJavaClass();
            return cl != null ? cl.newInstance() : null;
        }
        catch (ExceptionInInitializerError e) {
            throw new ComponentExecutionException(e.getException(), this.getText(), "Constructor");
        }
        catch (InstantiationException e) {
            throw new ComponentExecutionException(e, this.getText(), "Constructor");
        }
        catch (IllegalAccessException e) {
            throw new ComponentExecutionException(e, this.getText(), "Constructor");
        }
        catch (ClassNotFoundException e) {
            throw new ComponentExecutionException(e, this.getText(), "Constructor");
        }
    }

    public void packAttributePositions() {
        int position = 1;
        for (AttributeTypeDescription attr : this.getAttributesByPosition()) {
            attr.setPosition(position++);
        }
    }

    public SortedSet<AttributeTypeDescription> getAttributesByPosition() {
        TreeSet<MethodTypeDescription> attrByPosition = new TreeSet<MethodTypeDescription>(ATTRIBUTE_BY_POSITION_COMPARATOR);
        for (MethodTypeDescription member : this.memberTypes) {
            if (!member.isAttribute()) continue;
            attrByPosition.add(member.asAttribute());
        }
        return attrByPosition;
    }

    public final void removeInnerType(TypeRef type) {
        if (type == null) {
            throw new IllegalArgumentException("Attempt to remove a null type");
        }
        if (this.innerTypes != null) {
            boolean removed = this.innerTypes.remove(type);
            if (!removed) {
                String innerText = type.getText();
                int length = this.innerTypes.size();
                for (int i = 0; i < length; ++i) {
                    if (!innerText.equals(this.innerTypes.get(i).getText())) continue;
                    this.innerTypes.remove(i);
                    break;
                }
            }
            if (type instanceof ObjectTypeDescription) {
                ObjectTypeDescription otd = (ObjectTypeDescription)type;
                otd.setParent(null);
            }
        }
        this.fireTypeChanged();
    }

    public final void removeMember(MethodTypeDescription member) {
        int position;
        int index = this.getMemberIndex(member.getName(), member.getKind());
        if (index == -1) {
            return;
        }
        MethodTypeDescription prev = null;
        for (MethodTypeDescription current = this.getMemberType(index); current != null; current = current.getNextMethod()) {
            if (current == member) {
                current.setParent(null);
                if (prev != null) {
                    prev.setNextMethod(current.getNextMethod());
                    break;
                }
                prev = current;
                if ((current = current.getNextMethod()) == null) {
                    this.removeMember(index);
                } else {
                    this.memberNames.set(index, current.getName());
                    this.memberTypes.set(index, current);
                }
                prev.setNextMethod(null);
                break;
            }
            prev = current;
        }
        if (member.isAttribute() && (position = member.getPosition()) != -1) {
            this.packAttributePositions();
        }
        this.fireRelationRemoved("members", member);
        this.fireTypeMemberRemoved(member);
        this.fireTypeChanged();
    }

    public MethodTypeDescription findMemberByProperty(String nm, String value) {
        return this.findMemberByProperty(nm, value, -1);
    }

    public MethodTypeDescription findMemberByProperty(String nm, String value, int requiredKind) {
        MethodTypeDescription result = null;
        int count = this.getMemberCount();
        for (int i = 0; i < count; ++i) {
            MethodTypeDescription member = this.getMember(i);
            if (!Any.equals(member.getProperty(nm), value) || requiredKind != -1 && requiredKind != member.getKind()) continue;
            result = member;
            break;
        }
        return result;
    }

    public List<MethodTypeDescription> findMembersByProperty(String nm, String value) {
        return this.findMembersByProperty(nm, value, -1);
    }

    public List<MethodTypeDescription> findMembersByProperty(String nm, String value, int requiredKind) {
        ArrayList<MethodTypeDescription> result = new ArrayList<MethodTypeDescription>();
        int count = this.getMemberCount();
        for (int i = 0; i < count; ++i) {
            MethodTypeDescription member = this.getMember(i);
            if (!Any.equals(member.getProperty(nm), value) || requiredKind != -1 && requiredKind != member.getKind()) continue;
            result.add(member);
        }
        return result;
    }

    public void removeResource(TypeResource resource) {
        if (this.resources != null) {
            this.resources.remove(resource);
        }
    }

    public void renameMember(MethodTypeDescription member, String newName) {
        if (member != null) {
            assert (member.getParent() == this) : "Member does not belong to '" + this.getText() + "': " + member;
            int index = this.getMemberIndex(member.getName(), member.getKind());
            assert (index >= 0) : "Member does not belong to this type: " + member;
            member = this.getMemberType(index);
            this.removeMember(index);
            for (MethodTypeDescription current = member; current != null; current = current.getNextMethod()) {
                current.setName(newName);
            }
            this.addMember(member, false);
        }
        this.fireTypeChanged();
    }

    public final void replaceInnerAt(int index, TypeRef innerRef) {
        assert (this.innerTypes != null) : this.getName();
        this.innerTypes.set(index, innerRef);
        this.fireTypeChanged();
    }

    public void replaceInnerWithSameText(@NotNull TypeRef addedType) {
        if (addedType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/ObjectTypeDescription.replaceInnerWithSameText must not be null");
        }
        String typeRefText = addedType.getText();
        for (int i = 0; i < this.getInnerTypeCount(); ++i) {
            if (!this.getInnerTypeRef(i).getText().equals(typeRefText)) continue;
            this.replaceInnerAt(i, addedType);
            break;
        }
    }

    @Override
    public String toString() {
        String type = this.getComponentType();
        return (type != null ? type.toUpperCase() : "OBJECT") + "(" + this.getText() + ")";
    }

    public List<MethodTypeDescription> getAttributes() {
        ArrayList<MethodTypeDescription> result = new ArrayList<MethodTypeDescription>();
        for (MethodTypeDescription mtd : this.getMembers(18)) {
            result.add(mtd.asAttribute());
        }
        return result;
    }

    public List<MethodTypeDescription> getMethods() {
        ArrayList<MethodTypeDescription> result = new ArrayList<MethodTypeDescription>();
        result.addAll(Arrays.asList(this.getMembers(14)));
        return result;
    }

    public boolean hasMethod(String methodName) {
        return this.existsMember(this.getMemberIndex(methodName, 14));
    }

    public List<MethodTypeDescription> getPublicMethods() {
        ArrayList<MethodTypeDescription> result = new ArrayList<MethodTypeDescription>();
        for (MethodTypeDescription method : this.getMethods()) {
            do {
                if (method.isHidden()) continue;
                if (method.isConstructor()) {
                    if (method.getArgumentCount() != 0) continue;
                    result.add(method);
                    continue;
                }
                result.add(method);
            } while ((method = method.getNextMethod()) != null);
        }
        return result;
    }

    public String dump() {
        StringBuilder sf = new StringBuilder();
        sf.append(this.toString()).append("\n");
        String prefix = "\t";
        for (MethodTypeDescription att : this.getMembers(18)) {
            sf.append(prefix).append(att.toString()).append("\n");
        }
        for (MethodTypeDescription method : this.getMembers(14)) {
            sf.append(prefix).append(method.toString()).append("\n");
            sf.append(method.getCodeText()).append("\n");
        }
        return sf.toString();
    }

    public String proposeInnerTypeName(String proposedName) {
        String newName = proposedName;
        int i = 1;
        while (this.hasInnerType(newName)) {
            newName = proposedName + i;
            ++i;
        }
        return newName;
    }

    public boolean hasInnerType(String innerTypeName) {
        return this.findInnerType(innerTypeName) != null;
    }

    @Override
    public boolean isIntrospectedObject() {
        String s = this.getComponentType();
        return !CATALOG_OBJECT_TYPE_ID.equals(s) && !ComponentType.XOBJECT.getText().equals(s) && !this.isDefault();
    }

    @Override
    public boolean isIterable() {
        return super.isIterable() || this.isJavaMap() || this.isJavaList();
    }

    public void removeAllInnerTypes() {
        if (this.innerTypes != null) {
            this.innerTypes.clear();
        }
    }

    public boolean isJavaList() {
        return this.isStrictSubtypeOf("Java.Util.List");
    }

    public boolean isJavaMap() {
        return this.isStrictSubtypeOf("Java.Util.Map");
    }

    @Override
    protected StringList getMemberNames() {
        return this.memberNames;
    }

    protected List<MethodTypeDescription> getMemberTypes() {
        return this.memberTypes;
    }

    @Override
    protected boolean isAssignableFromImpl(TypeDescription source) {
        boolean assignable;
        boolean bl = assignable = (source = source.asObject()) == this || source.equals(this) || source.isObject() && this.equals(TypeFactory.getRootObject());
        if (!assignable) {
            for (SuperType superType : source.getSuperTypes()) {
                if (superType.isDelegated()) continue;
                TypeDescription parentType = superType.getType();
                if (parentType == source) {
                    String errorMsg = "Cyclic inheritance in '" + source.getText() + "'";
                    System.out.println("Error = " + errorMsg);
                    break;
                }
                if (!this.isAssignableFrom(parentType)) continue;
                assignable = true;
                break;
            }
        }
        return assignable;
    }

    @Override
    protected boolean isStrictSubtypeImpl(TypeDescription type) {
        return type.getKind() != 15 && type.isAssignableFrom(this);
    }

    protected void addSyntheticMethods() {
    }

    protected synchronized void loadMembers() {
    }

    @Override
    protected TypeDescription promoteImpl(TypeDescription type) {
        if (this.equals(type)) {
            return this;
        }
        if (!type.isObject()) {
            return TypeFactory.getAny();
        }
        if (this.isStrictSubtype(type)) {
            return type;
        }
        if (type.isStrictSubtype(this)) {
            return this;
        }
        if (type instanceof ObjectTypeDescription) {
            TypeDescription supertyp;
            List<SuperType> types = type.asObject().getSuperTypes();
            TypeDescription typeDescription = supertyp = !types.isEmpty() ? types.get(0).getType() : null;
            while (supertyp != null && !supertyp.isAssignableFrom(this)) {
                types = supertyp.getSuperTypes();
                supertyp = !types.isEmpty() ? types.get(0).getType() : null;
            }
            if (supertyp != null) {
                return supertyp;
            }
        }
        return TypeFactory.getAny();
    }

    protected MethodTypeDescription removeMember(int index) {
        MethodTypeDescription oldMember;
        this.memberNames.remove(index);
        for (MethodTypeDescription mtd = oldMember = this.memberTypes.remove(index); mtd != null; mtd = mtd.getNextMethod()) {
            mtd.setParent(null);
        }
        return oldMember;
    }

    protected void removeMembers() {
        MethodTypeDescription member = this.getMember(TIMEOUT_NAME, 18);
        this.memberNames.clear();
        this.memberTypes.clear();
        if (member != null) {
            this.addMember(member);
        }
    }

    protected int searchMember(int from, String nm, int requiredKind) {
        int memberCount = this.getMemberCount();
        int result = -1;
        for (int i = from; i < memberCount; ++i) {
            MethodTypeDescription member = this.getMemberType(i);
            if (!member.getName().equals(nm) || requiredKind != -1 && member.getKind() != requiredKind) continue;
            assert (i >= 0 && i < memberCount) : "Invalid result index: " + i + ", memberCount: " + memberCount;
            result = i;
            break;
        }
        return result;
    }

    @Nullable
    private TypeDescription findEnumTD() {
        for (SuperType superType : this.getSuperTypes()) {
            TypeDescription type = superType.getType();
            if (!type.isEnum()) continue;
            return type;
        }
        return null;
    }

    private void addMember(MethodTypeDescription member, boolean fireEvents) {
        int insertPoint;
        int count;
        if (member.getName() == null) {
            throw new IllegalArgumentException("Attempt to add a member without name to: " + this);
        }
        if (member.getParent() != null) {
            throw new IllegalArgumentException("Cannot add member to '" + this.getText() + "' beacuse it is already added in other type : " + member);
        }
        String nm = member.getName();
        if (nm.equals(this.getName())) {
            member.setModifiers(member.getModifiers() | 0x2000000L);
        }
        if ((count = this.memberNames.size()) > 0 && ((String)this.memberNames.get(count - 1)).compareTo(nm) < 0) {
            insertPoint = count;
        } else {
            insertPoint = this.indexOf(nm, 0);
            if (insertPoint < 0) {
                insertPoint = -insertPoint - 1;
            } else {
                MethodTypeDescription old = this.memberTypes.get(insertPoint);
                if (old.isMethod() && member.isMethod()) {
                    for (MethodTypeDescription m = old; m != null; m = m.getNextMethod()) {
                        if (!m.matchArguments(member)) continue;
                        throw new IllegalArgumentException("Duplicated member: " + member.getName() + ", old: " + m.getName());
                    }
                    this.memberTypes.set(insertPoint, MethodTypeDescription.appendMethod(old, member));
                    insertPoint = -1;
                } else {
                    if (old.getKind() == member.getKind()) {
                        throw new IllegalArgumentException("Duplicated attribute: " + member.getName() + ", old: " + old.getName());
                    }
                    ++insertPoint;
                }
            }
        }
        if (insertPoint >= 0) {
            this.memberNames.add(insertPoint, nm);
            this.memberTypes.add(insertPoint, member);
        }
        if (member.isAttribute() && member.asAttribute().getPosition() == -1) {
            member.asAttribute().setPosition(this.findNewPosition());
        }
        member.setParentToAll(this);
        if (fireEvents) {
            this.fireRelationAdded("members", member);
            this.fireTypeMemberAdded(member);
            this.fireTypeChanged();
        }
    }

    private boolean checkMemberName(int memberIndex, MethodTypeDescription result) {
        String methodName = (String)this.memberNames.get(memberIndex);
        return result.getName().equals(methodName);
    }

    private boolean isStrictSubtypeOf(String type) {
        TypeRef typeRef;
        ComponentCatalog catalog = this.getCatalog();
        if (catalog == null) {
            catalog = TypeUtils.getDefaultCatalog();
        }
        try {
            typeRef = catalog.find(type);
        }
        catch (AmbiguousTypeNameException e) {
            throw new IllegalStateException("Ambiguous type name '" + type + "'");
        }
        return typeRef != null && typeRef.get().isAssignableFrom(this);
    }

    private boolean isJavaSortedMap() {
        return this.isStrictSubtypeOf("Java.Util.SortedMap");
    }

    private int indexOf(String nm, int from) {
        int index = this.memberNames.binarySearch(nm);
        if (index >= 0) {
            while (index >= 0 && ((String)this.memberNames.get(index)).equals(nm)) {
                --index;
            }
            index = ((String)this.memberNames.get(from)).equals(nm) ? from : ++index;
        }
        return index;
    }

    private static class NameComparator
    implements Comparator<Name> {
        private NameComparator() {
        }

        @Override
        public int compare(Name o1, Name o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    public static class AttributeByPosition
    implements Comparator<MethodTypeDescription> {
        @Override
        public int compare(MethodTypeDescription a1, MethodTypeDescription a2) {
            return a1.getPosition() - a2.getPosition();
        }
    }
}

