/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.lang.ModuleLoadingException;
import oracle.bpm.lang.ModuleProperties;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.ValidationException;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.log.Log;
import oracle.bpm.util.PropertyBuilder;

public abstract class Module {
    protected String name;
    protected List namesCache;
    protected boolean namesloaded = false;
    protected String password;
    protected String user;
    public static final int NONE = 0;
    public static final int ENUM = 16;
    public static final int COMPONENT = 1;
    private static Map<String, ModuleFactory> factories = new HashMap<String, ModuleFactory>();
    private static boolean loaded = false;

    protected Module(String name) {
        this.name = name;
        this.namesCache = new ArrayList();
    }

    public abstract String getType();

    public abstract void validate() throws ValidationException, ModuleLoadingException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Module forName(String moduleType, String moduleName) {
        if (!loaded) {
            Module.loadModules();
        }
        Map<String, ModuleFactory> map = factories;
        synchronized (map) {
            ModuleFactory factory = factories.get(moduleType);
            if (factory == null) {
                assert (false) : "ModuleFactory for type = [" + moduleType + "] name = [" + moduleName + "] not found";
                return null;
            }
            ModuleProperties properties = new ModuleProperties(moduleType, moduleName);
            return factory.forName(moduleName, properties);
        }
    }

    public static ModuleFactory getFactory(String moduleType) {
        if (!loaded) {
            Module.loadModules();
        }
        return factories.get(moduleType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerFactory(String type, ModuleFactory factory) {
        Map<String, ModuleFactory> map = factories;
        synchronized (map) {
            factories.put(type, factory);
        }
    }

    public String getClassName(int i) throws ModuleLoadingException {
        if (!this.namesloaded) {
            this.loadNames();
        }
        return (String)this.namesCache.get(i);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getType() + ":" + this.name;
    }

    protected synchronized void loadNames() throws ModuleLoadingException {
    }

    private static synchronized void loadModules() {
        block6: {
            if (loaded) {
                return;
            }
            loaded = true;
            InputStream in = Module.class.getResourceAsStream("Module.properties");
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            try {
                String className;
                while ((className = reader.readLine()) != null) {
                    try {
                        Class.forName(className);
                    }
                    catch (ClassNotFoundException e) {
                        LibMsg.MODULE_LOADING_FAILED(className).logSevere();
                        Log.logSevere(e);
                    }
                }
            }
            catch (IOException e) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError((Object)e);
            }
        }
    }

    public static abstract class ModuleFactory {
        private List<PropertyBuilder> propertyBuilders = new ArrayList<PropertyBuilder>();

        public abstract ObjectTypeDescription createEmptyObjectTypeDescription(String var1);

        public boolean isHidden() {
            return false;
        }

        public PropertyBuilder getPropertyBuilder(int number) {
            return this.propertyBuilders.get(number);
        }

        public String getPropertyName(int number) {
            return this.getPropertyBuilder(number).getPropertyName();
        }

        public StringList getPropertyNames() {
            StringList names = StringList.create();
            for (PropertyBuilder builder : this.propertyBuilders) {
                names.add(builder.getPropertyName());
            }
            return names;
        }

        public Module forName(String moduleName, ModuleProperties properties) {
            return null;
        }

        protected void addProperty(String name, Class type, Object defaultValue) {
            this.propertyBuilders.add(PropertyBuilder.defaultBuilder(name, type, defaultValue));
        }
    }
}

