/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.bpm.adapter.Adaptable;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.DelegatedMethodTypeDescription;
import oracle.bpm.lang.DescriptionEnabled;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.PropertyBag;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.observers.ObjectPropertyListener;
import oracle.bpm.type.Argument;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.SourceCode;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeFinder;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.type.Validation;
import oracle.bpm.type.Variable;
import oracle.bpm.type.impl.TypeDescriptionImpl;
import oracle.bpm.util.Identifier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MethodTypeDescription
extends TypeDescriptionImpl
implements DescriptionEnabled,
PropertyBag {
    protected TypeRef parent;
    private ObjectPropertyListener argListener;
    private List<Argument> arguments;
    private List<Validation> checkCode = null;
    private SourceCode code = null;
    private String description;
    private List<Validation> ensureCode = null;
    private List<TypeRef> exceptions;
    private boolean fullParsing = false;
    private Collection<Variable> localVariables;
    private long modifiers;
    private String name;
    private MethodTypeDescription next;
    private Map<String, String> properties;
    private String replacement;
    private List<Validation> requireCode = null;
    private Argument result;
    private String signature;
    private String template;
    private Map<String, Object> transientProperties;
    private static final Pattern OLD_ARG_PATTERN = Pattern.compile("arg(\\d+)");
    public static final String NAME_PROPERTY = "name";
    public static final String TYPE_PROPERTY = "type";
    public static final String SIGNATURE_PROPERTY = "signature";
    public static final String HAS_GETTER_PROPERTY = "hasGetter";
    public static final String HAS_SETTER_PROPERTY = "hasSetter";
    public static final String CODE_PROPERTY = "code";
    public static final String ARGUMENT_PROPERTY = "argument";
    public static final String VARIABLE_PROPERTY = "variable";
    public static final String DEPRECATED_MESSAGE = "deprecatedMessage";
    private static final Argument[] ARGUMENT_ARRAY = new Argument[0];
    private static final Validation[] VALIDATION_ARRAY = new Validation[0];
    private static final Set<String> membersFromObject = new HashSet<String>();
    public static final String BUSINESS_RULE_CODE_PROPERTY_NAME = "rule.code";
    public static final String DESCRIPTION_PROPERTY = "description";

    public MethodTypeDescription(String name) {
        this(name, 0L);
    }

    public MethodTypeDescription(String name, long modifiers) {
        this(14, name);
        this.setModifiers(modifiers);
    }

    protected MethodTypeDescription(int kind, String name) {
        super(kind, -1, -1, false);
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.name = name;
        this.argListener = new ObjectPropertyListener(){

            @Override
            public void propertyChanged(Object object, String propertyName) {
                MethodTypeDescription.this.firePropertyChanged(MethodTypeDescription.SIGNATURE_PROPERTY);
            }
        };
    }

    public static MethodTypeDescription createMain() {
        MethodTypeDescription result = new MethodTypeDescription("main");
        result.fullParsing = true;
        result.modifiers = 32832L;
        return result;
    }

    public static MethodTypeDescription appendMethod(MethodTypeDescription a, MethodTypeDescription b) {
        assert (a != b) : "Cannot append a method to itself";
        if (a.compareTo(b) > 0) {
            b.next = a;
            return b;
        }
        MethodTypeDescription m = a;
        while (m.next != null && m.next.compareTo(b) <= 0) {
            m = m.next;
        }
        b.next = m.next;
        m.next = b;
        return a;
    }

    public void getArgText(StringBuffer text) {
        int argc = this.getArgumentCount();
        if (argc > 0) {
            text.append('(');
            for (int i = 0; i < argc; ++i) {
                Argument arg = this.getArgument(i);
                if (arg.isOptional()) {
                    text.append("optional ");
                }
                if (arg.isIn()) {
                    text.append("in");
                }
                if (arg.isOut()) {
                    text.append("out");
                }
                text.append(' ');
                String argName = arg.getName();
                if (argName == null || "".equals(argName)) {
                    argName = "arg" + (i + 1);
                }
                text.append(argName);
                text.append(" : ");
                text.append(arg.getTypeRef().getText());
                if (i + 1 >= argc) continue;
                text.append(", ");
            }
            text.append(')');
        }
    }

    public Argument getArgument(int i) {
        return this.arguments != null ? this.arguments.get(i) : null;
    }

    public int getArgument(String argName) {
        if (argName != null) {
            int argc = this.getArgumentCount();
            for (int i = 0; i < argc; ++i) {
                if (!Any.equals(argName, this.getArgument(i).getName())) continue;
                return i;
            }
        }
        return -1;
    }

    public int getArgumentCount() {
        return this.arguments != null ? this.arguments.size() : 0;
    }

    public void setArguments(Argument[] arguments) {
        this.removeAllArguments();
        if (arguments != null) {
            int length = arguments.length;
            for (int i = 0; i < length; ++i) {
                this.addArgument(arguments[i]);
            }
        }
    }

    public Argument[] getArguments() {
        if (this.arguments == null) {
            return ARGUMENT_ARRAY;
        }
        return this.arguments.toArray(new Argument[this.arguments.size()]);
    }

    @Override
    public ComponentCatalog getCatalog() {
        ComponentCatalog result = null;
        TypeDescription typeDescription = this.getParent();
        if (typeDescription != null) {
            result = typeDescription.getCatalog();
        }
        return result;
    }

    public boolean isDelegated() {
        return false;
    }

    public DelegatedMethodTypeDescription asDelegated() {
        throw new UnsupportedOperationException("Method '" + this.getText() + "' is not a delegated method");
    }

    public Validation[] getCheckCode() {
        return this.checkCode == null ? VALIDATION_ARRAY : this.checkCode.toArray(new Validation[this.checkCode.size()]);
    }

    public void setCode(SourceCode code) {
        SourceCode prev = this.code;
        this.code = code;
        if (!Any.equals(code, prev)) {
            if (this.isAttribute()) {
                this.firePropertyChanged(HAS_GETTER_PROPERTY);
            } else if (this.isMethod()) {
                this.firePropertyChanged(CODE_PROPERTY);
            }
        }
    }

    public void setCode(String code, String language) {
        this.setCode(code != null ? code.toCharArray() : null, language);
    }

    public void setCode(char[] code, String language) {
        if (code == null) {
            this.code = null;
        } else if (this.code == null) {
            this.code = SourceCode.create(code, language);
        } else {
            this.code.setText(code);
            this.code.setOffset(0);
            this.code.setLength(code.length);
            this.code.setLanguage(language);
        }
    }

    public SourceCode getCode() {
        return this.code;
    }

    public String getCodeLanguage() {
        return this.code != null ? this.code.getLanguage() : "Fuego";
    }

    public char[] getCodeText() {
        return this.code != null ? this.code.getText() : null;
    }

    public boolean isConst() {
        return Modifier.isConst(this.getModifiers());
    }

    public boolean isReadOnly() {
        return Modifier.isReadOnly(this.getModifiers());
    }

    @Override
    public boolean isConstructor() {
        TypeDescription obj = this.getParent();
        return obj != null && this.getName().equals(obj.getName());
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
        this.firePropertyChanged(DESCRIPTION_PROPERTY);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public Validation[] getEnsureCode() {
        return this.ensureCode == null ? VALIDATION_ARRAY : this.ensureCode.toArray(new Validation[this.ensureCode.size()]);
    }

    public TypeDescription getException(int number) {
        TypeRef exception = this.exceptions.get(number);
        return exception.get();
    }

    public int getExceptionCount() {
        return this.exceptions != null ? this.exceptions.size() : 0;
    }

    public List<TypeRef> getExceptions() {
        if (this.exceptions == null) {
            this.exceptions = new ArrayList<TypeRef>();
        }
        return this.exceptions;
    }

    public void setExceptions(List<TypeRef> exceptions) {
        this.exceptions = exceptions;
    }

    public TypeRef setException(int pos, TypeRef ref) {
        return this.getExceptions().set(pos, ref);
    }

    public boolean isForceArgQualification() {
        return false;
    }

    public void setFullParsing(boolean fullParsing) {
        this.fullParsing = fullParsing;
    }

    public boolean isFullParsing() {
        return this.fullParsing;
    }

    public boolean isFunction() {
        int argc = this.getArgumentCount();
        for (int i = 0; i < argc; ++i) {
            Argument arg = this.getArgument(i);
            if (!arg.isOut()) continue;
            return false;
        }
        return this.getResultType().getKind() != 0;
    }

    public int getInputArgumentCount() {
        int inputArgc = 0;
        if (this.arguments != null) {
            for (Argument argument : this.arguments) {
                if (!argument.isIn()) continue;
                ++inputArgc;
            }
        }
        return inputArgc;
    }

    @Override
    public String getJavaSignature() {
        String prefix = this.getPrefix();
        StringBuilder signature = new StringBuilder();
        boolean isConstructor = this.isConstructor();
        TypeDescription parent = this.getParent();
        if (isConstructor) {
            signature.append('K');
            signature.append(parent.getJavaType());
        } else {
            signature.append('M');
            signature.append(prefix);
            signature.append(this.getName());
        }
        signature.append('(');
        if (parent != null) {
            TypeDescription topLevelClass = parent.getParent();
            boolean isStatic = Modifier.isStatic(parent.getModifiers());
            if (topLevelClass != null) {
                String componentType = topLevelClass.asObject().getComponentType();
                if (isConstructor && !isStatic && ComponentType.XOBJECT.getText().equals(componentType)) {
                    signature.append(topLevelClass.getJavaSignature());
                }
            }
        }
        int argc = this.getArgumentCount();
        for (int i = 0; i < argc; ++i) {
            signature.append(this.getArgument(i).getJavaSignature());
        }
        signature.append(')');
        if (!isConstructor) {
            signature.append(this.getResultArgument().getJavaSignature());
        }
        return signature.toString();
    }

    @Override
    @NonNls
    public String getJavaType() {
        return this.getResultType().getJavaType();
    }

    public void setModifiers(long modifiers) {
        if (this.modifiers != modifiers) {
            this.modifiers = modifiers;
            this.fireTypeChanged();
        }
    }

    @Override
    public long getModifiers() {
        return this.modifiers;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        TypeDescription parent = this.getParent();
        if (parent != null) {
            parent.asObject().renameMember(this, name);
        } else {
            this.name = name;
        }
        this.firePropertyChanged(NAME_PROPERTY);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getNativeName() {
        return this.getProperty("nativeName");
    }

    public void setNativeName(String name) {
        this.setProperty("nativeName", name);
    }

    public MethodTypeDescription getNextMethod() {
        return this.next;
    }

    public MethodTypeDescription getNextOrSuperMethod() {
        return this.next != null ? this.next : this.getParent().findMethod(this.getName(), TypeFinder.Scope.ALL_INHERITED);
    }

    public int getOutputArgumentCount() {
        int outputArgc = 0;
        if (this.arguments != null) {
            for (Argument argument : this.arguments) {
                if (!argument.isOut()) continue;
                ++outputArgc;
            }
        }
        return outputArgc;
    }

    public void setParent(TypeDescription newParent) {
        assert (this.parent == null || newParent == null || this.parent == newParent) : "Attempt to change parent for member '" + this + "' from '" + this.parent + "' to '" + newParent + "'";
        this.parent = newParent;
    }

    @Override
    public TypeRef getParentRef() {
        return this.parent;
    }

    public int getPosition() {
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public String getPrefix() {
        ObjectTypeDescription type;
        String prefix = "";
        if (this.parent != null && (prefix = (type = this.parent.get().asObject()).getProperty("methodPrefix")) == null && (prefix = this.getProperty("methodPrefix")) == null) {
            String name = this.getName();
            if (membersFromObject.contains(name)) return "_";
            if (!Identifier.belongsToJava(name)) return "";
            return "_";
        }
        String string = prefix;
        if (string == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/MethodTypeDescription.getPrefix must not return null");
        return string;
    }

    @Override
    public void setProperties(Map<String, String> map) {
        this.properties = map;
    }

    @Override
    public Map<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new TreeMap<String, String>();
        }
        return this.properties;
    }

    public Object getTransientProperty(String key) {
        return this.getTransientProperties().get(key);
    }

    public void setTransientProperty(String key, Object value) {
        this.getTransientProperties().put(key, value);
    }

    public Map<String, Object> getTransientProperties() {
        if (this.transientProperties == null) {
            this.transientProperties = new TreeMap<String, Object>();
        }
        return this.transientProperties;
    }

    @Override
    public void setProperty(String name, String value) {
        if (value == null) {
            if (this.properties != null) {
                this.properties.remove(name);
            }
        } else {
            this.getProperties().put(name, value);
        }
    }

    @Override
    public String getProperty(String name) {
        return this.properties != null ? this.properties.get(name) : null;
    }

    @Override
    public String getQualifiedName() {
        String name = this.getName();
        TypeRef parent = this.getParentRef();
        if (parent != null) {
            name = parent.getText() + "." + name;
        }
        return name;
    }

    public void setReplacement(String replacement) {
        this.replacement = replacement;
    }

    public String getReplacement() {
        return this.replacement;
    }

    public Validation[] getRequireCode() {
        return this.requireCode == null ? VALIDATION_ARRAY : this.requireCode.toArray(new Validation[this.requireCode.size()]);
    }

    public Argument getResultArgument() {
        if (this.result == null) {
            this.result = new ResultArgument();
            this.result.setParent(this);
        }
        return this.result;
    }

    public void getResultText(StringBuffer text) {
        TypeRef retType = this.getResultArgument().getTypeRef();
        String retText = retType.getText();
        if (!retText.equals("Void")) {
            text.append(" : ");
            text.append(retText);
        }
    }

    public void setResultType(TypeRef resultType) {
        TypeRef prevType = this.getResultArgument().getTypeRef();
        if (prevType != resultType) {
            this.getResultArgument().setType(resultType);
            this.firePropertyChanged(TYPE_PROPERTY);
            this.fireTypeChanged();
        }
    }

    public TypeDescription getResultType() {
        return this.getResultArgument().getType();
    }

    public TypeRef getResultTypeRef() {
        return this.getResultArgument().getTypeRef();
    }

    public void setReturnArgument(Argument ret) {
        if (this.isMethod() && (!ret.isReturnValue() || ret.isOut())) {
            throw new IllegalArgumentException(ret.toString());
        }
        assert (ret.getTypeRef() != null) : "Type for result argument cannot be null";
        if (this.result != null) {
            this.result.setParent(null);
        }
        ret.setParent(this);
        this.result = ret;
    }

    public void setSignature(String value) {
        if (!this.belongsToFuegoObject()) {
            this.signature = value;
        }
    }

    @Override
    public String getSignature() {
        if (this.belongsToFuegoObject()) {
            return this.getJavaSignature();
        }
        return this.signature;
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getTemplate() {
        return this.template;
    }

    @Override
    public String getText() {
        StringBuffer text = new StringBuffer(this.getName());
        this.getArgText(text);
        this.getResultText(text);
        return text.toString();
    }

    @Override
    public boolean equality(TypeDescription b) {
        boolean result = false;
        if (b instanceof MethodTypeDescription) {
            MethodTypeDescription that = b.asMethod();
            result = this.getParent().equality(that.getParent()) && this.getText().equals(b.getText());
        }
        return result;
    }

    public boolean hasVariables() {
        return this.localVariables != null && !this.localVariables.isEmpty();
    }

    public void setVariables(Collection<Variable> variables) {
        this.localVariables = new ArrayList<Variable>(variables);
    }

    public Collection<Variable> getVariables() {
        TreeSet<Variable> variables = new TreeSet<Variable>(new Comparator<Variable>(){

            @Override
            public int compare(Variable left, Variable right) {
                return left.compareTo(right);
            }
        });
        if (this.localVariables != null) {
            variables.addAll(this.localVariables);
        }
        return variables;
    }

    public void setVisible(boolean visible) {
        long mods = this.getModifiers();
        mods = visible ? (mods &= 0xFFFFFFFFFDFFFFFFL) : (mods |= 0x2000000L);
        this.setModifiers(mods);
    }

    public boolean isVisible() {
        boolean hidden = Modifier.isHidden(this.getModifiers());
        if (this.parent != null) {
            hidden |= Modifier.isHidden(this.parent.getModifiers());
        }
        return !hidden;
    }

    public Argument addArgument(Argument arg) {
        String argName = arg.getName();
        if (!Str.isEmpty(argName) && this.findArgument(argName) != null) {
            throw new IllegalArgumentException("Duplicated argument: " + arg.toString());
        }
        arg.setParent(this);
        if (this.arguments == null) {
            this.arguments = new ArrayList<Argument>(3);
        }
        this.arguments.add(arg);
        this.fireRelationAdded(ARGUMENT_PROPERTY, arg);
        arg.addPropertyObserver(TYPE_PROPERTY, this.argListener);
        arg.addPropertyObserver(NAME_PROPERTY, this.argListener);
        return arg;
    }

    public void addCheckCode(String code, String language) {
        this.addCheckCode(new Validation(code.toCharArray(), 0, code.length(), language));
    }

    public void addCheckCode(Validation validation) {
        if (this.checkCode == null) {
            this.checkCode = new ArrayList<Validation>(2);
        }
        this.checkCode.add(validation);
    }

    public void addEnsureCode(String code, String language) {
        this.addEnsureCode(new Validation(code.toCharArray(), 0, code.length(), language));
    }

    public void addEnsureCode(Validation validation) {
        if (this.ensureCode == null) {
            this.ensureCode = new ArrayList<Validation>(2);
        }
        this.ensureCode.add(validation);
    }

    public void addException(TypeRef exc) {
        if (this.exceptions == null) {
            this.exceptions = new ArrayList<TypeRef>(3);
        }
        this.exceptions.add(exc);
    }

    public void addModifiers(long modifier) {
        this.setModifiers(this.getModifiers() | modifier);
    }

    public boolean hasGetter() {
        return this.hasModifiers(8L);
    }

    public boolean hasSetter() {
        return this.hasModifiers(4L);
    }

    public void addRequireCode(String code, String language) {
        this.addRequireCode(new Validation(code.toCharArray(), 0, code.length(), language));
    }

    public void addRequireCode(Validation validation) {
        if (this.requireCode == null) {
            this.requireCode = new ArrayList<Validation>(2);
        }
        this.requireCode.add(validation);
    }

    public void addVariable(Variable localVariable) {
        if (this.localVariables == null) {
            this.localVariables = new ArrayList<Variable>();
        }
        this.localVariables.add(localVariable);
        localVariable.setParent(this);
        this.fireRelationAdded(VARIABLE_PROPERTY, localVariable);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public ObjectTypeDescription asObject() {
        if ($assertionsDisabled) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/MethodTypeDescription.asObject must not return null");
        }
        throw new AssertionError((Object)("Attempt to call asObject over " + this.getClass() + " : " + this));
    }

    public boolean belongsToFuegoObject() {
        return this.parent != null && this.parent.get().isBpmObject();
    }

    public void clearCheckCode() {
        if (this.checkCode != null) {
            this.checkCode.clear();
        }
    }

    public void clearModifier(long modifier) {
        this.setModifiers(this.getModifiers() & (modifier ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public void clearRequireCode() {
        if (this.requireCode != null) {
            this.requireCode.clear();
        }
    }

    @Override
    public MethodTypeDescription clone() {
        MethodTypeDescription resultMember = (MethodTypeDescription)this.abstractClone();
        resultMember.parent = null;
        resultMember.arguments = null;
        for (Argument arg : this.getArguments()) {
            resultMember.addArgument(arg.copy());
        }
        resultMember.localVariables = null;
        for (Variable variable : this.getVariables()) {
            resultMember.addVariable(variable.clone());
        }
        Argument argument = resultMember.result = this.result != null ? this.result.copy() : null;
        if (resultMember.result != null) {
            resultMember.result.setParent(resultMember);
        }
        if (this.next != null) {
            resultMember.next = this.next.clone();
        }
        resultMember.code = SourceCode.copy(this.code);
        if (this.requireCode != null) {
            resultMember.requireCode = new ArrayList<Validation>(this.requireCode.size());
            for (int i = 0; i < this.requireCode.size(); ++i) {
                Validation reqElem = Validation.copy(this.requireCode.get(i));
                resultMember.requireCode.add(reqElem);
            }
        }
        if (this.ensureCode != null) {
            resultMember.ensureCode = new ArrayList<Validation>(this.ensureCode.size());
            for (int i = 0; i < this.ensureCode.size(); ++i) {
                Validation ensElem = Validation.copy(this.ensureCode.get(i));
                resultMember.ensureCode.add(ensElem);
            }
        }
        if (this.checkCode != null) {
            resultMember.checkCode = new ArrayList<Validation>(this.checkCode.size());
            for (int i = 0; i < this.checkCode.size(); ++i) {
                Validation checkElem = Validation.copy(this.checkCode.get(i));
                resultMember.checkCode.add(checkElem);
            }
        }
        return resultMember;
    }

    @Override
    public int compareTo(Object object) {
        if (object instanceof MethodTypeDescription) {
            return this.getName().compareTo(((MethodTypeDescription)object).getName());
        }
        return -1;
    }

    public void copyModifiableAttributesFrom(MethodTypeDescription m) {
        this.setTemplate(m.getTemplate());
        this.setDescription(m.getDescription());
        this.setName(m.getName());
    }

    @Override
    public boolean equals(Object value) {
        if (this == value) {
            return true;
        }
        if (value == null) {
            return false;
        }
        if (!(value instanceof MethodTypeDescription)) {
            return false;
        }
        MethodTypeDescription type = (MethodTypeDescription)value;
        return type.getKind() == this.getKind() && this.getName().equals(type.getName()) && this.matchArguments(type) && this.getResultArgument().equals(type.getResultArgument());
    }

    @Override
    public boolean equivalent(TypeDescription type) {
        return this.equals(type);
    }

    public Argument findArgument(String name) {
        if (name != null) {
            int argc = this.getArgumentCount();
            for (int i = 0; i < argc; ++i) {
                Argument arg = this.getArgument(i);
                if (!Any.equals(arg.getName(), name)) continue;
                return arg;
            }
        }
        return null;
    }

    public Argument findClosestArgument(String name, int maxDistance) {
        int argIndex;
        int argc = this.getArgumentCount();
        Matcher matcher = OLD_ARG_PATTERN.matcher(name);
        if (maxDistance == 0 && matcher.matches() && (argIndex = Integer.parseInt(matcher.group(1)) - 1) >= 0 && argIndex < argc) {
            return this.getArgument(argIndex);
        }
        int hint = -1;
        int minDistance = 0;
        for (int i = 0; i < argc; ++i) {
            Argument arg = this.getArgument(i);
            int dist = TypeUtils.memberDistance(name, arg.getName());
            if (dist >= minDistance && hint != -1) continue;
            hint = i;
            minDistance = dist;
        }
        return hint != -1 && minDistance <= maxDistance ? this.getArgument(hint) : null;
    }

    public Variable findVariable(String name) {
        Variable result = null;
        for (Variable var : this.getVariables()) {
            if (!name.equals(var.getName())) continue;
            result = var;
            break;
        }
        return result;
    }

    public boolean hasProperties() {
        return this.properties != null && this.properties.size() > 0;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.name.hashCode();
        result = 37 * result + (this.arguments != null ? ((Object)this.arguments).hashCode() : 0);
        result = 37 * result + this.getResultArgument().hashCode();
        return result;
    }

    public Object invoke(Object obj, Object[] args) throws ComponentExecutionException {
        return this.getParent().invokeMethod(this.getSignature(), obj, args);
    }

    public void setNextMethod(MethodTypeDescription mtd) {
        assert (this.next != mtd || mtd == null) : "Cannot add a method next to itself";
        assert (mtd == null || mtd.getKind() == this.getKind()) : "Invalid next member: " + mtd;
        this.next = mtd;
        while (mtd != null) {
            mtd.setParent(this.getParent());
            mtd = mtd.getNextMethod();
        }
    }

    public boolean matchArguments(MethodTypeDescription method) {
        return this.matchArguments(method, true);
    }

    public boolean matchArguments(MethodTypeDescription method, boolean checkName) {
        int argc = this.getArgumentCount();
        if (argc != method.getArgumentCount()) {
            return false;
        }
        for (int i = 0; i < argc; ++i) {
            if (this.getArgument(i).match(method.getArgument(i), checkName)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean overrides(MethodTypeDescription method) {
        return this.getName().equals(method.getName()) && this.matchArguments(method);
    }

    @Override
    public TypeDescription promoteImpl(TypeDescription type) {
        if (this.equals(type)) {
            return this;
        }
        return null;
    }

    public void removeAllArguments() {
        int argc = this.getArgumentCount();
        for (int i = 0; i < argc; ++i) {
            Argument argument = this.getArgument(i);
            argument.setParent(null);
            argument.removePropertyObserver(TYPE_PROPERTY, this.argListener);
            argument.removePropertyObserver(NAME_PROPERTY, this.argListener);
        }
        if (this.arguments != null) {
            this.arguments.clear();
        }
        this.fireTypeChanged();
    }

    public void removeAllVariables() {
        if (this.localVariables != null) {
            this.localVariables.clear();
        }
    }

    public void removeArgument(int index) {
        Argument argument = this.arguments.remove(index);
        this.fireRelationRemoved(ARGUMENT_PROPERTY, argument);
        argument.removePropertyObserver(TYPE_PROPERTY, this.argListener);
        argument.removePropertyObserver(NAME_PROPERTY, this.argListener);
    }

    public void removeArgument(Argument argument) {
        this.fireRelationRemoved(ARGUMENT_PROPERTY, this.arguments.remove(argument));
        argument.removePropertyObserver(TYPE_PROPERTY, this.argListener);
        argument.removePropertyObserver(NAME_PROPERTY, this.argListener);
    }

    @Override
    public String toString() {
        return this.parent + "." + this.getText();
    }

    public Iterable<MethodTypeDescription> overloaded() {
        return new Iterable<MethodTypeDescription>(){

            @Override
            public Iterator<MethodTypeDescription> iterator() {
                return new Iterator<MethodTypeDescription>(){
                    private MethodTypeDescription current;
                    {
                        this.current = MethodTypeDescription.this;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.current != null;
                    }

                    @Override
                    public MethodTypeDescription next() {
                        if (this.current == null) {
                            throw new NoSuchElementException();
                        }
                        MethodTypeDescription result = this.current;
                        this.current = this.current.getNextMethod();
                        return result;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public void setStatic(boolean b) {
        if (b) {
            this.addModifiers(64L);
        } else {
            this.clearModifier(64L);
        }
    }

    public boolean isExpression() {
        return this.hasModifiers(0x1000000000L);
    }

    public void setParentToAll(ObjectTypeDescription newParent) {
        this.setParent(newParent);
        MethodTypeDescription nextMethod = this.getNextMethod();
        if (nextMethod != null) {
            nextMethod.setParentToAll(newParent);
        }
    }

    public MethodTypeDescription findIn(TypeDescription parent) {
        return this.findIn(parent, TypeFinder.Scope.DEFAULT);
    }

    public MethodTypeDescription findIn(TypeDescription parent, TypeFinder.Scope scope) {
        return TypeFinder.findMemberImpl(parent, this.getName(), this.getKind(), scope);
    }

    public void removeVariable(String name) {
        if (this.localVariables != null) {
            Iterator<Variable> it = this.localVariables.iterator();
            while (it.hasNext()) {
                Variable variable = it.next();
                if (!name.equals(variable.getName())) continue;
                it.remove();
                this.fireRelationRemoved(VARIABLE_PROPERTY, variable);
                break;
            }
        }
    }

    private int compareTo(MethodTypeDescription b) {
        int argcB;
        int argc = this.getArgumentCount();
        if (argc < (argcB = b.getArgumentCount())) {
            return -1;
        }
        if (argc > argcB) {
            return 1;
        }
        boolean hiddenA = this.isHidden();
        boolean hiddenB = b.isHidden();
        if (hiddenA) {
            return hiddenB ? 0 : 1;
        }
        if (hiddenB) {
            return -1;
        }
        Argument[] args = this.getArguments();
        Argument[] argsB = this.getArguments();
        int comparison = 0;
        for (int i = 0; i < args.length && comparison == 0; ++i) {
            String argType = args[i].getTypeRef().getText();
            String argTypeB = argsB[i].getTypeRef().getText();
            comparison = argType.compareTo(argTypeB);
        }
        return comparison;
    }

    static {
        for (Method method : Object.class.getDeclaredMethods()) {
            if (!java.lang.reflect.Modifier.isFinal(method.getModifiers())) continue;
            membersFromObject.add(method.getName());
        }
    }

    private class ResultArgument
    extends Argument {
        ResultArgument() {
            super("return", TypeFactory.getVoid(), 16L);
        }

        @Override
        public void setModifiers(long mods) {
            assert (!MethodTypeDescription.this.isMethod() || !Modifier.isOut(mods)) : "Invalid modifier for result argument: " + Modifier.getText(mods);
            super.setModifiers(mods);
        }

        @Override
        public void setType(TypeRef type) {
            assert (type != null) : "Cannot set null as result type.";
            super.setType(type);
        }
    }

    public static class MethodRef
    implements Adaptable {
        private MethodTypeDescription method;
        private String signature;
        private TypeRef type;

        public MethodRef(MethodTypeDescription method) {
            TypeDescription methodParent = method.getParent();
            this.type = methodParent != null ? methodParent.getRef() : null;
            this.signature = method.getSignature();
            this.method = method;
            if (method != this.get()) {
                throw new IllegalArgumentException();
            }
        }

        public MethodTypeDescription get() {
            ObjectTypeDescription objectType;
            MethodTypeDescription newMethod;
            boolean parentIsNull;
            MethodTypeDescription result = this.method;
            boolean bl = parentIsNull = result.getParent() == null || result.getParent().getCatalog() == null;
            if (parentIsNull && this.type != null && (newMethod = (objectType = this.type.get().asObject()).getMemberBySignature(this.signature)) != null) {
                result = newMethod;
            }
            this.method = result;
            return result;
        }

        @Override
        public <T> T as(Class<T> targetType) {
            MethodTypeDescription mtd = this.get();
            if (targetType.isInstance(mtd)) {
                return targetType.cast(mtd);
            }
            return null;
        }
    }
}

