/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.EnumType;
import oracle.bpm.lang.EnumTypeDescription;
import oracle.bpm.lang.Initialization;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeMappings;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.impl.TypeDescriptionImpl;
import oracle.bpm.util.ArrayUtils;

public class JavaEnumTypeDescription
extends ObjectTypeDescription
implements EnumTypeDescription {
    private JavaEnumTypeDescription complement;
    private List<String> labels;
    private boolean nativeEnum;
    private List<String> nativeNames;
    private String originalClass;
    private boolean sequential;
    private List<Integer> values;
    private static final int[] EMPTY_INTS = new int[0];
    private static final String VALUEOF = "valueOf";
    public static final String VALUES_FIELD = "VALUES";
    private static final String FACTORY_NAME = "valueOf";

    public JavaEnumTypeDescription(String name, String[] labels) {
        this(name, labels, null, true, true);
    }

    public JavaEnumTypeDescription(String name, String[] labels, int[] values) {
        this(name, labels, values, false, true);
    }

    private JavaEnumTypeDescription() {
        super("", 17, true);
        this.setComponentType(ComponentType.ENUMERATION.getText());
    }

    private JavaEnumTypeDescription(String name, String[] labels, int[] values, boolean sequential, boolean primitive) {
        this(name, labels, null, values, sequential, primitive);
    }

    private JavaEnumTypeDescription(String name, String[] labels, String[] nativeNames, int[] values, boolean sequential, boolean primitive) {
        super(name, 17, primitive);
        this.sequential = sequential;
        this.setComponentType(ComponentType.ENUMERATION.getText());
        if (labels != null) {
            List<String> labelsList = Arrays.asList(labels);
            if (values != null) {
                List<Integer> valuesList = JavaEnumTypeDescription.asList(values);
                if (labelsList.size() > valuesList.size()) {
                    labelsList = labelsList.subList(0, valuesList.size());
                } else if (valuesList.size() > labelsList.size()) {
                    valuesList = valuesList.subList(0, labelsList.size());
                }
                this.values = new ArrayList<Integer>(valuesList);
            }
            this.labels = new ArrayList<String>(labelsList);
            if (nativeNames != null) {
                List<String> nativeNamesList = Arrays.asList(nativeNames);
                this.nativeNames = new ArrayList<String>(nativeNamesList);
            }
            for (int i = 0; i < labelsList.size(); ++i) {
                this.createEnumAttribute(i);
            }
        }
    }

    public static JavaEnumTypeDescription create(String name, String description) {
        JavaEnumTypeDescription result = new JavaEnumTypeDescription(name, null);
        result.setDescription(description);
        return result;
    }

    public static JavaEnumTypeDescription create(String name, Class<? extends Enum> cl) {
        JavaEnumTypeDescription result = null;
        try {
            assert (cl.isEnum()) : "Class is not an enum: " + cl;
            Enum[] values = cl.getEnumConstants();
            String[] labels = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                labels[i] = values[i].name();
            }
            result = new JavaEnumTypeDescription(name, labels, null, true, false);
            result.setComponentType(ComponentType.JAVA.getText());
            result.setOriginalClass(cl.getName());
            result.setId(cl.getName());
            result.setNativeEnum(true);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static ObjectTypeDescription createDeprecated(String name, Class cl) {
        JavaEnumTypeDescription result;
        int[] values;
        String[] labels;
        assert (EnumType.class.isAssignableFrom(cl)) : "Class is not an enum: " + cl;
        Field[] fields = cl.getDeclaredFields();
        int j = 0;
        if (fields == null) {
            labels = ArrayUtils.EMPTY_STRING_ARRAY;
            values = EMPTY_INTS;
        } else {
            int len = fields.length;
            labels = new String[len];
            values = new int[len];
            int constant = 25;
            for (Field field : fields) {
                TypeDescription td;
                if ((field.getModifiers() & 0x19) != 25 || (td = TypeMappings.getType(field.getType().getName())) == null || !td.isInt()) continue;
                try {
                    values[j] = field.getInt(null);
                    labels[j] = field.getName();
                    ++j;
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
            }
        }
        int[] svalues = new int[j];
        System.arraycopy(values, 0, svalues, 0, j);
        Arrays.sort(svalues);
        boolean sequential = svalues.length > 0;
        for (int i = 0; i < j; ++i) {
            if (svalues[i] == i) continue;
            sequential = false;
            break;
        }
        String[] enumLabels = new String[j];
        if (sequential) {
            for (int i = 0; i < j; ++i) {
                enumLabels[values[i]] = labels[i];
            }
            result = new JavaEnumTypeDescription(name, enumLabels);
        } else {
            System.arraycopy(labels, 0, enumLabels, 0, j);
            result = new JavaEnumTypeDescription(name, enumLabels, values);
        }
        result.setComponentType(ComponentType.JAVA.getText());
        result.originalClass = cl.getName();
        return result;
    }

    public static ObjectTypeDescription createObject() {
        return new JavaEnumTypeDescription();
    }

    @Override
    public void addItem(String nm) {
        this.addItem(nm, null);
    }

    @Override
    public void addItem(String nm, Integer value) {
        this.addItem(nm, value, null);
    }

    @Override
    public void addItem(String nm, Integer value, String nativeName) {
        if (this.labels == null) {
            this.labels = new ArrayList<String>();
            this.nativeNames = new ArrayList<String>();
            if (value == null) {
                this.sequential = true;
                this.values = null;
            } else {
                this.values = new ArrayList<Integer>();
                this.sequential = false;
            }
        } else if (value == null) assert (this.sequential) : "Attempt to add a value '" + value + "' for item '" + nm + "' from non-sequential enum '" + this.getText() + '\'';
        this.labels.add(nm);
        this.nativeNames.add(nativeName);
        if (value != null) {
            this.values.add(value);
        }
        this.createEnumAttribute(this.labels.size() - 1);
    }

    @Override
    public boolean equality(TypeDescription type) {
        return type.isEnum() && type.getName().equals(this.getName()) || type.getKind() == 9;
    }

    @Override
    public boolean equals(Object value) {
        if (this == value) {
            return true;
        }
        if (value == null) {
            return false;
        }
        if (!(value instanceof JavaEnumTypeDescription)) {
            return false;
        }
        JavaEnumTypeDescription td = (JavaEnumTypeDescription)value;
        return td.isPrimitive() == this.isPrimitive() && this.equality(td);
    }

    @Override
    public TypeDescription getHolderType() {
        return this.isNativeEnum() ? TypeFactory.getAny() : (this.isPrimitive() ? TypeFactory.getPrimitiveInt(32) : TypeFactory.getInt(32));
    }

    @Override
    public Initialization getInitialization() {
        return Initialization.ZERO;
    }

    @Override
    public Class getJavaClass() {
        return this.isNativeEnum() ? super.getJavaClass() : (this.isPrimitive() ? Integer.TYPE : Integer.class);
    }

    @Override
    public String getJavaSignature() {
        return JavaClass.getSignature(this.getJavaClass());
    }

    @Override
    public String getJavaType() {
        return this.isNativeEnum() ? this.originalClass : (this.isPrimitive() ? Integer.TYPE.getName() : Integer.class.getName());
    }

    @Override
    public String[] getLabels() {
        return this.labels == null ? null : this.labels.toArray(new String[this.labels.size()]);
    }

    public String[] getNativeNames() {
        return this.nativeNames == null ? null : this.nativeNames.toArray(new String[this.nativeNames.size()]);
    }

    @Override
    public int getNextMemberIndex(String nm, int from, int requiredKind) {
        return super.searchMember(0, nm, requiredKind);
    }

    public String getOriginalClass() {
        return this.originalClass;
    }

    @Override
    public int getValue(int i) {
        return this.sequential ? i : this.values.get(i);
    }

    public int[] getValues() {
        if (this.values == null) {
            return null;
        }
        int len = this.values.size();
        int[] result = new int[len];
        for (int i = 0; i < len; ++i) {
            result[i] = this.values.get(i);
        }
        return result;
    }

    @Override
    public boolean hasDefaultInit() {
        return true;
    }

    @Override
    public boolean isComparable(TypeDescription type) {
        return this.equality(type);
    }

    @Override
    public boolean isExternal() {
        return this.originalClass != null;
    }

    @Override
    public boolean isIterable() {
        return true;
    }

    @Override
    public boolean isNativeEnum() {
        return this.nativeEnum;
    }

    @Override
    public boolean isSequential() {
        return this.sequential;
    }

    @Override
    public Object newInstance(String value) {
        Object result = null;
        if (!this.isNativeEnum()) {
            result = Integer.valueOf(value);
        } else {
            Class clazz = this.getJavaClass();
            try {
                Method factory = clazz.getDeclaredMethod("valueOf", String.class);
                result = factory.invoke(null, value);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public Object newInstance(long value) {
        Long result = null;
        if (this.isNativeEnum()) {
            Class clazz = this.getJavaClass();
            try {
                Field valuesField = clazz.getDeclaredField(VALUES_FIELD);
                List list = (List)valuesField.get(null);
                result = list.get((int)value);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        } else {
            result = value;
        }
        return result;
    }

    @Override
    public TypeDescription primitiveEquivalent(boolean v) {
        JavaEnumTypeDescription result = this;
        if (!this.isNativeEnum() && this.isPrimitive() != v) {
            if (this.complement == null) {
                this.complement = new JavaEnumTypeDescription(this.getName(), this.getLabels(), this.getNativeNames(), this.getValues(), this.sequential, v);
                this.complement.setParent(this.getParent());
                this.complement.complement = this;
            }
            result = this.complement;
        }
        return result;
    }

    @Override
    public void removeMembers() {
        super.removeMembers();
        this.labels = null;
        this.values = null;
        this.nativeNames = null;
    }

    @Override
    public void renameMember(MethodTypeDescription member, String newName) {
        String oldName = member.getName();
        super.renameMember(member, newName);
        if (this.labels == null || !member.isAttribute()) {
            return;
        }
        int index = this.labels.indexOf(oldName);
        if (index == -1) {
            return;
        }
        this.labels.set(index, newName);
        if (!this.isNativeEnum()) {
            return;
        }
        index = this.getMemberIndex(newName, member.getKind());
        if (index == -1) {
            return;
        }
        this.setDefaultValue(this.getMemberType(index).asAttribute(), index);
    }

    public void setNativeEnum(boolean nativeEnum) {
        if (nativeEnum != this.nativeEnum) {
            this.nativeEnum = nativeEnum;
            if (nativeEnum) {
                this.setPrimitive(false);
            }
            this.setDefaultValues();
        }
    }

    public void setOriginalClass(String originalClass) {
        this.originalClass = originalClass;
    }

    @Override
    public void setParent(TypeRef parent) {
        super.setParent(parent);
        if (this.complement != null) {
            this.complement.parent = parent;
        }
    }

    @Override
    public void setSequential(boolean b) {
        if (b != this.sequential) {
            this.sequential = b;
            if (!this.isNativeEnum()) {
                this.setDefaultValues();
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.isPrimitive()) {
            result.append('p');
        } else if (this.isNativeEnum()) {
            result.append("Native");
        }
        result.append("Enum ");
        result.append(this.getName());
        result.append('(');
        if (this.labels != null) {
            for (int i = 0; i < this.labels.size(); ++i) {
                if (i > 0) {
                    result.append(',');
                }
                result.append(this.labels.get(i));
            }
        }
        result.append(')');
        return result.toString();
    }

    @Override
    protected boolean isAssignableFromImpl(TypeDescription source) {
        Unknown unknown = source instanceof Unknown ? (Unknown)source : null;
        return this.equality(source) || unknown != null && this.getMemberIndex(unknown.getText()) != -1;
    }

    @Override
    protected boolean isStrictSubtypeImpl(TypeDescription type) {
        return type.isPrimitive() == this.isPrimitive() && (type.isInt() && type.getLength() == 32 || this.equality(type));
    }

    @Override
    protected MethodTypeDescription removeMember(int index) {
        int idx;
        MethodTypeDescription oldMember = super.removeMember(index);
        if (this.labels != null && oldMember.isAttribute() && oldMember.isConst() && (idx = this.labels.indexOf(oldMember.getName())) != -1) {
            this.labels.remove(idx);
            if (this.nativeNames != null) {
                this.nativeNames.remove(idx);
            }
            if (this.values != null) {
                this.values.remove(idx);
            }
            if (!this.isNativeEnum() && this.isSequential()) {
                this.setDefaultValues();
            }
        }
        return oldMember;
    }

    static boolean isDefaultFactory(String name, MethodTypeDescription member) {
        boolean result = false;
        if (name.equals("valueOf")) {
            switch (member.getArgumentCount()) {
                case 1: {
                    result = member.getArgument(0).getType().isString();
                    break;
                }
                case 2: {
                    result = Class.class.equals(member.getArgument(0).getType().getJavaClass());
                    result = result && member.getArgument(1).getType().isString();
                }
            }
        }
        return result;
    }

    private static List<Integer> asList(int[] array) {
        int len = array.length;
        ArrayList<Integer> result = new ArrayList<Integer>(len);
        for (int i = 0; i < len; ++i) {
            result.add(array[i]);
        }
        return result;
    }

    private void setDefaultValues() {
        if (this.labels != null && !this.labels.isEmpty()) {
            for (MethodTypeDescription member : this.getMemberTypes()) {
                String memberName;
                int index;
                if (!member.isAttribute() || !member.isConst() || (index = this.labels.indexOf(memberName = member.getName())) == -1) continue;
                this.setDefaultValue(member.asAttribute(), index);
            }
        }
    }

    private void setDefaultValue(AttributeTypeDescription attribute, int index) {
        attribute.setDefaultValue(this.isNativeEnum() ? attribute.getName() : (this.isSequential() ? Integer.toString(index) : String.valueOf(this.values.get(index))));
    }

    private void createEnumAttribute(int index) {
        String nativeName;
        String nm = this.labels.get(index);
        AttributeTypeDescription attribute = new AttributeTypeDescription(nm, this);
        attribute.makeConst();
        this.setDefaultValue(attribute, index);
        if (this.nativeNames != null && (nativeName = this.nativeNames.get(index)) != null) {
            attribute.setProperty("nativeName", nativeName);
        }
        assert (attribute.isConst());
        attribute.setParent(this);
        this.getMemberNames().add(nm);
        this.getMemberTypes().add(attribute);
    }

    public static class Unknown
    extends TypeDescriptionImpl {
        private String id;

        public Unknown(String id) {
            super(-1, -1, -1, false);
            this.id = id;
        }

        @Override
        public String getText() {
            return this.id;
        }
    }
}

