/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import oracle.bpm.lang.TypeDescription;

public enum Initialization {
    NULL("null"),
    FALSE("false"),
    ZERO("0"),
    EMPTY_STRING("\"\""),
    ZERO_CONSTRUCTOR(null),
    DEFAULT_CONSTRUCTOR(null),
    CREATE(null),
    EMPTY_ARRAY(null);

    private String initString;

    private Initialization(String initString) {
        this.initString = initString;
    }

    public String getInitString() {
        return this.initString;
    }

    public String javaInitString(TypeDescription td) {
        if (this == EMPTY_ARRAY) {
            return "new " + td.getElementType().getImplementationType() + "[0]";
        }
        if (this == FALSE && !td.isPrimitive()) {
            return "Boolean.FALSE";
        }
        String type = td.getImplementationType();
        if (this == DEFAULT_CONSTRUCTOR) {
            return "new " + type + "()";
        }
        if (this == CREATE) {
            return type + ".create()";
        }
        if (this == ZERO_CONSTRUCTOR) {
            return "new " + type + "()";
        }
        if (this == FALSE && !td.isPrimitive()) {
            return "Boolean.FALSE";
        }
        if (this == EMPTY_ARRAY) {
            return "new " + type + "[0]";
        }
        return this.initString;
    }
}

