/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.jdbc;

import java.sql.SQLException;
import oracle.bpm.jdbc.DatabaseManager;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.log.Log;
import oracle.bpm.util.Utilities;

public abstract class FaultTolerantResource {
    private boolean retry;
    protected static final int MAX_RETRY_DEFAULT = 3;
    protected static final int ELAPSE_TIME = 12000;
    protected static int retryTimes_sd = 3;

    protected FaultTolerantResource(boolean retry) {
        this.retry = retry;
    }

    public static int getConnectionRetries() {
        return retryTimes_sd;
    }

    public static void setRetryTimes(int retryTimes) {
        retryTimes_sd = retryTimes;
    }

    public static int getRetryTimes() {
        return retryTimes_sd;
    }

    protected abstract String getResourceName();

    protected abstract boolean isUnderlyingConnectionDirty();

    protected abstract void cleanUnderlyingConnection();

    protected abstract void recreateConnection(int var1) throws SQLException;

    protected abstract DatabaseManager getDatabaseManager();

    protected boolean isCommunicationFailure(SQLException e) {
        return this.getDatabaseManager().isCommunicationFailure(e);
    }

    protected boolean canRetry() {
        return this.retry;
    }

    protected void handleExceptions(SQLException originalException, int attempt) throws SQLException {
        if (this.isCommunicationFailure(originalException) && this.canRetry()) {
            Log.logInfo(originalException);
            Utilities.sleep(12000L);
            boolean canRetry = true;
            for (int i = 0; i < FaultTolerantResource.getConnectionRetries() && canRetry; ++i) {
                try {
                    Log.logWarning(LibMsg.RECONNECT(this.getResourceName(), i));
                    this.recreateConnection(i);
                    break;
                }
                catch (SQLException reconnectException) {
                    canRetry = false;
                    Log.logInfo(reconnectException);
                    if (!this.isCommunicationFailure(reconnectException)) continue;
                    canRetry = true;
                    Utilities.sleep(12000 * i + 1);
                    continue;
                }
            }
        }
        this.cleanUnderlyingConnection();
        throw originalException;
    }
}

