/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class DerbyManager {
    private static Map<String, Integer> connectedURLs = new HashMap<String, Integer>();

    public static void addConnectionUsage(String url) {
        Integer usageCount = connectedURLs.get(url);
        if (usageCount == null) {
            connectedURLs.put(url, 1);
        } else {
            connectedURLs.put(url, usageCount + 1);
        }
    }

    public static Connection createDB(String url) throws SQLException {
        return DerbyManager.createDB(url, null, null);
    }

    public static Connection createDB(String url, String user, String password) throws SQLException {
        System.out.println("CREATE url = " + url);
        Connection conn = DriverManager.getConnection(url + ";create=true");
        if (user != null && password != null && !user.equals("") && !password.equals("")) {
            Statement st = conn.createStatement();
            st.execute("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.connection.requireAuthentication','true')");
            st.execute("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.authentication.provider','BUILTIN')");
            st.execute("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.user." + user + "','" + password + "')");
            try {
                st.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
        }
        return conn;
    }

    public static boolean removeConnectionUsage(String url, Properties properties) {
        Integer usageCount = connectedURLs.get(url);
        if (usageCount != null) {
            if (usageCount <= 1) {
                DerbyManager.shutdownDatabase(url, properties);
                connectedURLs.remove(url);
                return true;
            }
            connectedURLs.put(url, usageCount - 1);
        }
        return false;
    }

    public static void shutdown(String url, Properties properties) {
        Integer usageCount = connectedURLs.get(url);
        if (usageCount == null || usageCount <= 0) {
            DerbyManager.shutdownDatabase(url, properties);
        }
    }

    private static void shutdownDatabase(String url, Properties properties) {
        block2: {
            try {
                DriverManager.getConnection(url + ";shutdown=true", properties);
            }
            catch (SQLException e) {
                if (e.getSQLState().equals("08006") || e.getSQLState().equals("XJ004")) break block2;
                System.out.println("e.getErrorCode() = " + e.getErrorCode());
                System.out.println("e.getSQLState() = " + e.getSQLState());
                System.out.println("e = " + e);
            }
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (connectedURLs.size() > 0) {
                    for (String key : connectedURLs.keySet()) {
                        System.out.println("Derby url [" + key + "] that remained with [" + connectedURLs.get(key) + "] connections without closing them!");
                    }
                }
            }
        });
    }
}

