/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.connector.ConnectorTransaction;
import oracle.bpm.connector.JDBCHelper;
import oracle.bpm.connector.impl.BaseJDBCConnector;
import oracle.bpm.connector.spi.JDBCConnectorInterface;
import oracle.bpm.jdbc.DatabaseCollationSupport;
import oracle.bpm.jdbc.FaultTolerantConnection;
import oracle.bpm.jdbc.TableInitializer;
import oracle.bpm.lang.Cast;
import oracle.bpm.lang.Kind;
import oracle.bpm.lang.RuntimeExceptionShell;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.log.Log;
import oracle.bpm.sql.DatabaseException;
import oracle.bpm.sql.DriverNotFoundException;
import oracle.bpm.sql.struct.Schema;

public abstract class DatabaseManager {
    protected BaseJDBCConnector connector_d;
    protected Connection systemConnection_d;
    private DatabaseCollationSupport databaseCollationSupport = null;
    private JDBCConnectorInterface jdbcConnectorInterface_d;
    public static final String DO_NOT_PASS_TABLE_TO_UPPERCASE = "doNotPassTableToUppercase";
    public static final String DO_NOT_CREATE_PROCEDURES = "doNotCreateProcedure";
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final int TABLE_SCHEM = 2;
    private static final int TABLE_NAME = 3;

    public DatabaseManager(BaseJDBCConnector connector) {
        this.connector_d = connector;
    }

    protected DatabaseManager(JDBCConnectorInterface jdbcConnectorInterface) {
        this.jdbcConnectorInterface_d = jdbcConnectorInterface;
    }

    public abstract String getCurrentTimeSQL();

    public abstract void createUser(String var1, String var2, Properties var3) throws DatabaseException;

    public abstract void dropUser(String var1, String var2, Properties var3) throws DatabaseException;

    public abstract boolean isCommunicationFailure(SQLException var1);

    public static void unlockConnection(Connection connection) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAddColumnsSQLCommand(String tableName, List<Schema.Field> columnList) throws SQLException, ClassNotFoundException {
        try {
            this.connect();
            String schemaName = this.getSchemaNameToAddColumns();
            ArrayList<Schema.Field> newColumns = new ArrayList<Schema.Field>();
            ArrayList<Schema.Field> modifiedColumns = new ArrayList<Schema.Field>();
            this.classifyColumns(schemaName, tableName, columnList, newColumns, modifiedColumns);
            if (newColumns.size() > 0 || modifiedColumns.size() > 0) {
                try {
                    String[] stringArray = this.getAddColumns(schemaName, tableName, newColumns, modifiedColumns);
                    return stringArray;
                }
                catch (DatabaseException de) {
                    throw (SQLException)new SQLException(LibMsg.MODIFICATION_NOT_SUPPORTED.toString()).initCause(de);
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    throw (SQLException)new SQLException(e.getMessage()).initCause(e);
                }
            }
            String[] stringArray = EMPTY_STRING_ARRAY;
            return stringArray;
        }
        finally {
            if (this.getConnection() != null) {
                try {
                    this.getConnection().close();
                }
                catch (SQLException ignore) {}
            }
            this.systemConnection_d = null;
        }
    }

    public String getCreateIndex(Schema sch, Schema.Table tab, Schema.Index ind) {
        StringBuilder str = new StringBuilder();
        str.append("CREATE ");
        if (ind.unique) {
            str.append("UNIQUE ");
        }
        str.append("INDEX ").append(this.getFullTableName(sch.name, ind.name.toUpperCase()));
        str.append(" ON ").append(this.getFullTableName(sch.name, this.upperCase(tab.name))).append(" ( ");
        str.append(this.asCSVString(ind.fields)).append(" )\n");
        return str.toString();
    }

    public String getCreateSchema(Schema schema) {
        String query = "CREATE SCHEMA AUTHORIZATION " + schema.name + "\n";
        return query;
    }

    public final String getCreateTable(Schema schema, Schema.Table table) {
        return this.getCreateTable(schema, table, true, true);
    }

    public String getCreateTable(Schema schema, Schema.Table table, boolean withForeignKeys, boolean withPrimaryKey) {
        StringBuilder str = new StringBuilder();
        str.append("CREATE TABLE ").append(this.getFullTableName(schema.name, this.upperCase(table.name))).append("\n(");
        boolean first = true;
        for (Schema.Field field : table.getFields()) {
            if (!first) {
                str.append(",");
            } else {
                first = false;
            }
            str.append("\n\t").append(this.getCreateField(field));
        }
        if (withPrimaryKey) {
            if (!table.getPrimaryKeyFieldNames().isEmpty()) {
                str.append(",\n\t").append(this.getCreatePrimaryKey(table));
            }
            if (!table.getUniqueFieldNames().isEmpty()) {
                str.append(",\n\t").append(this.getCreateUnique(table));
            }
        }
        if (withForeignKeys) {
            str.append(this.getCreateForeignKeys(schema.name, table));
        }
        str.append(")\n");
        return str.toString();
    }

    public String getDisabledConstraint() {
        return "";
    }

    public String getDropIndex(Schema schema, Schema.Table table, Schema.Index index) {
        return "DROP INDEX " + this.getFullTableName(schema.name, index.name.toUpperCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Schema.Field getFieldForColumn(String schemaName, String tableName, String columnName) throws SQLException {
        ResultSet rs = null;
        try {
            DatabaseMetaData md;
            if (this.getConnection() == null) {
                this.connect();
            }
            if ((rs = (md = this.getConnection().getMetaData()).getColumns(null, schemaName, tableName, columnName)).next()) {
                Schema.Field field = new Schema.Field();
                field.name = rs.getString("COLUMN_NAME");
                field.strType = rs.getString("TYPE_NAME");
                String size = rs.getString("COLUMN_SIZE");
                String decimals = rs.getString("DECIMAL_DIGITS");
                if (decimals != null && !"".equals(decimals) && !"0".equals(decimals)) {
                    size = size + "," + decimals;
                }
                field.restrictedSize = field.size = size;
                field.allowNull = !"NO".equals(rs.getString("IS_NULLABLE"));
                Schema.Field field2 = field;
                return field2;
            }
            Schema.Field field = null;
            return field;
        }
        catch (ClassNotFoundException e) {
            Log.logSevere(e);
            Schema.Field field = null;
            return field;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    public String getFromRowLocking() {
        return "";
    }

    public String getUpdLock() {
        return "";
    }

    public String getNoLock() {
        return "";
    }

    public String getFullTableName(String schemaName, String tableName) {
        if (schemaName != null && schemaName.length() > 0) {
            return schemaName + "." + tableName;
        }
        return tableName;
    }

    public ResultSet getIndexInfo(DatabaseMetaData metadata, String catalog, String schemaPattern, String tablePattern, boolean unique, boolean approximate) throws SQLException {
        if (metadata.storesUpperCaseIdentifiers()) {
            schemaPattern = schemaPattern != null ? schemaPattern.toUpperCase() : null;
            String string = tablePattern = tablePattern != null ? tablePattern.toUpperCase() : null;
        }
        if (metadata.storesLowerCaseIdentifiers()) {
            schemaPattern = schemaPattern != null ? schemaPattern.toLowerCase() : null;
            tablePattern = tablePattern != null ? tablePattern.toLowerCase() : null;
        }
        return metadata.getIndexInfo(catalog, schemaPattern, tablePattern, unique, approximate);
    }

    public ResultSet getProcedures(DatabaseMetaData metadata, String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        if (metadata.storesUpperCaseIdentifiers()) {
            String string = schemaPattern = schemaPattern != null ? schemaPattern.toUpperCase() : null;
        }
        if (metadata.storesLowerCaseIdentifiers()) {
            schemaPattern = schemaPattern != null ? schemaPattern.toLowerCase() : null;
        }
        return metadata.getProcedures(catalog, schemaPattern, procedureNamePattern);
    }

    public boolean isRowLockedException(SQLException e) {
        return false;
    }

    public boolean isSchemaExistsException(SQLException e) {
        return "42710".equals(e.getSQLState());
    }

    public final String getSchemaForIntrospecting() {
        BaseJDBCConnector connector = this.getConnector();
        if (connector == null) {
            return null;
        }
        String schema = connector.getProperty("jdbc.schema");
        if (schema != null && schema.length() > 0) {
            return schema;
        }
        return null;
    }

    public String getSchemaName() {
        String strSchema = this.getConnector().getProperty("jdbc.schema");
        if (strSchema == null || strSchema.equals("")) {
            strSchema = this.getConnector().getProperty("user");
        }
        return strSchema;
    }

    public String getSchemaNameToAddColumns() {
        return this.getSchemaName();
    }

    public ResultSet getTables(DatabaseMetaData metadata, String catalog, String schemaPattern, String tablePattern, String[] types) throws SQLException {
        if (metadata.storesUpperCaseIdentifiers()) {
            String string = schemaPattern = schemaPattern != null ? schemaPattern.toUpperCase() : null;
        }
        if (metadata.storesLowerCaseIdentifiers()) {
            schemaPattern = schemaPattern != null ? schemaPattern.toLowerCase() : null;
        }
        return metadata.getTables(catalog, schemaPattern, tablePattern, types);
    }

    public boolean isTimeoutException(SQLException e) {
        String sqlState = e.getSQLState();
        return "72000".equals(sqlState) && e.getErrorCode() == 1013;
    }

    public boolean isUniqueConstraint(SQLException e) {
        String sqlState = e.getSQLState();
        return "23000".equals(sqlState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addColumns(String tableName, List<Schema.Field> columnList) throws SQLException, ClassNotFoundException {
        block12: {
            ArrayList<Schema.Field> newColumns = new ArrayList<Schema.Field>();
            ArrayList<Schema.Field> modifiedColumns = new ArrayList<Schema.Field>();
            String schemaName = this.getSchemaNameToAddColumns();
            try {
                this.connect();
                this.classifyColumns(schemaName, tableName, columnList, newColumns, modifiedColumns);
                if (newColumns.size() <= 0 && modifiedColumns.size() <= 0) break block12;
                try {
                    String[] query = this.getAddColumns(schemaName, tableName, newColumns, modifiedColumns);
                    for (int i = 0; i < query.length; ++i) {
                        this.runStatement(this.getConnection(), query[i]);
                    }
                }
                catch (DatabaseException de) {
                    throw new SQLException(LibMsg.SQL_00040.toString());
                }
                catch (RuntimeException e) {
                    throw new SQLException(e.getMessage());
                }
            }
            finally {
                if (this.getConnection() != null) {
                    try {
                        this.getConnection().close();
                    }
                    catch (SQLException ignore) {}
                }
                this.systemConnection_d = null;
            }
        }
    }

    public boolean canReuseStatements() {
        return this.getConnectorInterface().supports(8L);
    }

    public void cleanDatabase(Schema schema, String systemUser, String systemPassword) throws DatabaseException {
        boolean failed = true;
        schema.name = this.getSchemaName();
        String url = this.getConnector().getURL();
        try {
            ConnectorTransaction.start();
            Connection conn = JDBCHelper.getConnection(this.getConnector().getName());
            Statement st = conn.createStatement();
            ListIterator<Schema.Table> listIterator = schema.getTables().listIterator(schema.getTables().size());
            while (listIterator.hasPrevious()) {
                Schema.Table table = listIterator.previous();
                if (!table.delete) continue;
                st.executeUpdate("DELETE FROM " + this.upperCase(table.name));
            }
            failed = false;
        }
        catch (Exception e) {
            if (Log.isDebugging()) {
                Log.logDebug(e);
            }
            throw new DatabaseException(url, (Throwable)e);
        }
        finally {
            try {
                if (!failed) {
                    ConnectorTransaction.current().commit();
                } else {
                    ConnectorTransaction.current().rollback();
                }
            }
            catch (Exception e) {
                throw new DatabaseException(url, (Throwable)e);
            }
        }
    }

    public Connection createConnection() throws SQLException, ClassNotFoundException {
        BaseJDBCConnector connector = this.getConnector();
        Connection connection = DriverManager.getConnection(connector.getURL(), connector.getConnectionProperties());
        DatabaseManager.unlockConnection(connection);
        return connection;
    }

    public void createDatabase(Schema schema, String systemUser, String systemPassword) throws DatabaseException {
        schema.name = this.getSchemaName();
        this.createDatabase(schema, systemUser, systemPassword, this.getConnector().getProperties());
    }

    public void createDatabase(Schema schema, String systemUser, String systemPassword, Properties properties) throws DatabaseException {
        try {
            block31: {
                if (!this.getConnector().supports(512L)) {
                    this.systemConnect(systemUser, systemPassword, properties);
                } else {
                    this.connect();
                }
                this.getConnection().setAutoCommit(true);
                try {
                    String crSchema = this.getCreateSchema(schema);
                    if (crSchema != null && !crSchema.equals("")) {
                        this.runStatement(this.getConnection(), crSchema);
                    }
                }
                catch (SQLException e) {
                    if (this.isSchemaExistsException(e)) break block31;
                    throw e;
                }
            }
            if (!Boolean.getBoolean(DO_NOT_CREATE_PROCEDURES)) {
                for (Schema.Procedure procedure : schema.getProcedures()) {
                    this.runStatement(this.getConnection(), this.getCreateProcedure(schema, procedure));
                }
            }
            for (Schema.Table table : schema.getTables()) {
                this.runStatement(this.getConnection(), this.getCreateTable(schema, table));
                if (!this.hasInterTableTriggerDependencies()) {
                    this.createTriggers(schema, table);
                }
                this.createIndexes(table, schema);
                for (String s : table.getInitializers()) {
                    try {
                        Class<TableInitializer> clazz = Cast.toClass(TableInitializer.class, Class.forName(s));
                        if (clazz == null) {
                            throw new IllegalArgumentException(s);
                        }
                        this.runStatement(this.getConnection(), clazz.newInstance().getSql(table, this));
                    }
                    catch (InstantiationException e) {
                        throw new RuntimeExceptionShell(e);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeExceptionShell(e);
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeExceptionShell(e);
                    }
                }
            }
            if (this.hasInterTableTriggerDependencies()) {
                for (Schema.Table table : schema.getTables()) {
                    this.createTriggers(schema, table);
                }
            }
            for (Schema.Statement statement : schema.getStatements()) {
                this.runStatement(this.getConnection(), this.getInsertStatement(schema, statement));
            }
            for (Schema.View view : schema.getViews()) {
                this.runStatement(this.getConnection(), this.getCreateView(schema, view));
            }
            this.executeRawSentences(schema);
            for (Schema.Sequence sequence : schema.getSequences()) {
                this.createSequence(this.getConnection(), sequence);
            }
            this.getConnection().setAutoCommit(false);
        }
        catch (ClassNotFoundException cnfe) {
            throw new DriverNotFoundException(this.getConnector().getURL(), cnfe);
        }
        catch (SQLException e) {
            throw new DatabaseException(this.getConnector().getURL(), (Throwable)e);
        }
        finally {
            if (this.getConnection() != null) {
                try {
                    this.getConnection().close();
                }
                catch (SQLException ignore) {}
            }
            this.systemConnection_d = null;
        }
    }

    public void createUser(String systemUser, String systemPassword) throws DatabaseException {
        this.createUser(systemUser, systemPassword, this.getConnector().getProperties());
    }

    public String dropDatabase(Schema schema, String systemUser, String systemPassword) throws DatabaseException {
        schema.name = this.getSchemaName();
        return this.dropDatabase(schema, systemUser, systemPassword, this.getConnector().getProperties());
    }

    public String dropDatabase(Schema schema, String systemUser, String systemPassword, Properties properties) throws DatabaseException {
        StringBuilder errors = null;
        try {
            if (this.getConnector().supports(512L)) {
                this.connect();
            } else {
                this.systemConnect(systemUser, systemPassword, properties);
            }
            this.getConnection().setAutoCommit(true);
            for (Schema.Table table : schema.getTablesInReverseOrder()) {
                try {
                    this.runStatement(this.getConnection(), this.getDropTable(schema, table));
                }
                catch (SQLException e) {
                    errors = DatabaseManager.appendError(errors, e);
                }
            }
            for (Schema.Procedure procedure : schema.getProcedures()) {
                try {
                    this.runStatement(this.getConnection(), this.getDropProcedure(schema, procedure));
                }
                catch (SQLException e) {
                    errors = DatabaseManager.appendError(errors, e);
                }
            }
            for (Schema.View view : schema.getViews()) {
                try {
                    this.runStatement(this.getConnection(), this.getDropView(schema, view));
                }
                catch (SQLException e) {
                    errors = DatabaseManager.appendError(errors, e);
                }
            }
            for (Schema.Sequence sequence : schema.getSequences()) {
                try {
                    this.dropSequence(this.getConnection(), sequence);
                }
                catch (SQLException e) {
                    errors = DatabaseManager.appendError(errors, e);
                }
            }
            String drSchema = this.getDropSchema(schema);
            if (drSchema != null && !drSchema.equals("")) {
                try {
                    this.runStatement(this.getConnection(), drSchema);
                }
                catch (SQLException e) {
                    errors = DatabaseManager.appendError(errors, e);
                }
            }
            this.getConnection().setAutoCommit(false);
        }
        catch (ClassNotFoundException cnfe) {
            throw new DriverNotFoundException(this.getConnector().getURL(), cnfe);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new DatabaseException(this.getConnector().getURL(), (Throwable)e);
        }
        finally {
            if (this.getConnection() != null) {
                try {
                    this.getConnection().close();
                }
                catch (SQLException ignore) {}
            }
            this.systemConnection_d = null;
        }
        return errors == null ? null : errors.toString();
    }

    public String dropSchema(Schema schema, String systemUser, String systemPassword) throws DatabaseException {
        schema.name = this.getSchemaName();
        StringBuilder errors = null;
        try {
            if (!this.getConnector().supports(512L)) {
                this.systemConnect(systemUser, systemPassword, this.getConnector().getProperties());
            } else {
                this.connect();
            }
            this.getConnection().setAutoCommit(true);
            ResultSet tables = this.getTables(this.getConnection().getMetaData(), null, schema.name, "%", new String[]{"TABLE"});
            while (tables.next()) {
                Schema.Table t = new Schema.Table(tables.getString("TABLE_NAME"));
                try {
                    this.runStatement(this.getConnection(), this.getDropTable(schema, t));
                }
                catch (SQLException e) {
                    errors = DatabaseManager.appendError(errors, e);
                }
            }
            ResultSet procedures = this.getProcedures(this.getConnection().getMetaData(), null, schema.name, "%");
            while (procedures.next()) {
                Schema.Procedure p = new Schema.Procedure(procedures.getString("PROCEDURE_NAME"));
                try {
                    this.runStatement(this.getConnection(), this.getDropProcedure(schema, p));
                }
                catch (SQLException e) {
                    errors = DatabaseManager.appendError(errors, e);
                }
            }
            ResultSet views = this.getTables(this.getConnection().getMetaData(), null, schema.name, "%", new String[]{"VIEW"});
            while (views.next()) {
                Schema.View v = new Schema.View(tables.getString("TABLE_NAME"), "");
                try {
                    this.runStatement(this.getConnection(), this.getDropView(schema, v));
                }
                catch (SQLException e) {
                    errors = DatabaseManager.appendError(errors, e);
                }
            }
            for (Schema.Sequence sequence : schema.getSequences()) {
                try {
                    this.dropSequence(this.getConnection(), sequence);
                }
                catch (SQLException e) {
                    errors = DatabaseManager.appendError(errors, e);
                }
            }
            String drSchema = this.getDropSchema(schema);
            if (drSchema != null && !drSchema.equals("")) {
                try {
                    this.runStatement(this.getConnection(), drSchema);
                }
                catch (SQLException e) {
                    errors = DatabaseManager.appendError(errors, e);
                }
            }
            this.getConnection().setAutoCommit(false);
        }
        catch (ClassNotFoundException cnfe) {
            throw new DriverNotFoundException(this.getConnector().getURL(), cnfe);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new DatabaseException(this.getConnector().getURL(), (Throwable)e);
        }
        finally {
            if (this.getConnection() != null) {
                try {
                    this.getConnection().close();
                }
                catch (SQLException ignore) {}
            }
            this.systemConnection_d = null;
        }
        return errors != null ? errors.toString() : null;
    }

    public void dropUser(String systemUser, String systemPassword) throws DatabaseException {
        this.dropUser(systemUser, systemPassword, this.getConnector().getProperties());
    }

    public PreparedStatement prepareQueryObjectStatement(Connection conn, String sqlText) throws SQLException {
        return conn.prepareStatement(sqlText);
    }

    public final String showCreateTables(Schema schema, String user, String password) {
        return this.showCreateTables(schema, user, password, this.getConnector().getProperties());
    }

    public final String showCreateTables(Schema schema, String user, String password, Properties props) {
        schema.name = this.getSchemaName();
        StringBuffer sql = new StringBuffer("-- You need to execute these sentences connected as the user created before (this user will be the one used by BEA to connect to this database).\n");
        String crSchema = this.getCreateSchema(schema);
        if (crSchema != null && !crSchema.equals("")) {
            sql.append(crSchema).append(this.getSQLSentencesSeparator());
        }
        for (Schema.Table table : schema.getTables()) {
            String[] triggers;
            sql.append(this.getCreateTable(schema, table)).append(this.getSQLSentencesSeparator());
            for (String trigger : triggers = this.getCreateTriggers(schema, table)) {
                sql.append(trigger).append(this.getSQLSentencesSeparator());
            }
            for (Schema.Index ind : table.getIndexes()) {
                sql.append(this.getCreateIndex(schema, table, ind)).append(this.getSQLSentencesSeparator());
            }
            for (String s : table.getInitializers()) {
                try {
                    Class<TableInitializer> clazz = Cast.toClass(TableInitializer.class, Class.forName(s));
                    if (clazz == null) {
                        throw new IllegalArgumentException(s);
                    }
                    sql.append(clazz.newInstance().getSql(table, this)).append(this.getSQLSentencesSeparator());
                }
                catch (InstantiationException e) {
                    throw new RuntimeExceptionShell(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeExceptionShell(e);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeExceptionShell(e);
                }
            }
        }
        for (Schema.Statement statement : schema.getStatements()) {
            sql.append(this.getInsertStatement(schema, statement));
            sql.append(this.getSQLSentencesSeparator());
        }
        for (Schema.Procedure procedure : schema.getProcedures()) {
            sql.append(this.getCreateProcedure(schema, procedure));
            sql.append(this.getSQLSentencesSeparator());
        }
        for (Schema.View view : schema.getViews()) {
            sql.append(this.getCreateView(schema, view));
            sql.append(this.getSQLSentencesSeparator());
        }
        for (Schema.Sequence sequence : schema.getSequences()) {
            String[] statements = this.getCreateSequence(sequence);
            for (String statement : statements) {
                sql.append(statement);
                sql.append(this.getSQLSentencesSeparator());
            }
        }
        return sql.toString();
    }

    public String[] getCreateSequence(Schema.Sequence sequence) {
        String createTable = "CREATE TABLE SEQ_" + sequence.getName() + " (nextval INTEGER)";
        String insert = "INSERT INTO SEQ_" + sequence.getName() + " (NEXTVAL) VALUES (" + (sequence.getInitialValue() - 1) + ")";
        return new String[]{this.upperCase(createTable), this.upperCase(insert)};
    }

    public String getDropSequence(Schema.Sequence sequence) {
        return this.upperCase("DROP TABLE SEQ_" + sequence.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextValForSequence(String sequenceName, Connection connection) throws SQLException {
        Statement st = null;
        String tableName = "SEQ_" + sequenceName.toUpperCase();
        try {
            st = connection.prepareStatement("UPDATE " + tableName + " SET NEXTVAL = NEXTVAL + 1");
            int i = st.executeUpdate();
            assert (i == 1) : "Inconsistency updating sequence: " + i;
            st.close();
            st = connection.prepareStatement("SELECT NEXTVAL FROM " + tableName);
            ResultSet resultSet = st.executeQuery();
            resultSet.next();
            int n = resultSet.getInt(1);
            return n;
        }
        finally {
            try {
                if (st != null) {
                    st.close();
                }
                assert (connection instanceof FaultTolerantConnection) : "The cache values must be fault tolerant connections";
                FaultTolerantConnection ftconnection = (FaultTolerantConnection)connection;
                ftconnection.commit(this.getConnector());
                ftconnection.close();
            }
            catch (SQLException e) {
                Log.logSevere(e);
            }
        }
    }

    public void createSequence(Connection conn, Schema.Sequence sequence) throws SQLException {
        String fullTableName = this.getFullTableName(sequence.getSchemaName(), "SEQ_" + sequence.getName());
        String createTable = "CREATE TABLE " + fullTableName + " (NEXTVAL INTEGER)";
        this.runStatement(conn, this.upperCase(createTable));
        String insert = "INSERT INTO " + fullTableName + " (NEXTVAL) VALUES (" + (sequence.getInitialValue() - 1) + ")";
        this.runStatement(conn, this.upperCase(insert));
    }

    public void dropSequence(Connection connection, Schema.Sequence sequence) throws SQLException {
        Statement st = connection.createStatement();
        String createTable = "DROP TABLE SEQ_" + sequence.getName();
        st.execute(this.upperCase(createTable));
    }

    public String showCreateUser(String user, String password) {
        return this.showCreateUser(user, password, this.getConnector().getProperties());
    }

    public String showCreateUser(String user, String password, Properties p) {
        return "-- You need to execute these sentences connected as dba user.\n";
    }

    public final String showDropTables(Schema schema) {
        return this.showDropTables(schema, this.getConnector().getProperties());
    }

    public final String showDropTables(Schema schema, Properties properties) {
        schema.name = this.getSchemaName();
        StringBuilder sb = new StringBuilder();
        sb.append("-- You need to execute these sentences connected as the user created before ");
        sb.append("(this user will be the one used by Fuego to connect to this database).\n");
        for (Schema.Table table : schema.getTables()) {
            sb.append(this.getDropTable(schema, table));
            sb.append(";\n");
        }
        for (Schema.Procedure procedure : schema.getProcedures()) {
            sb.append(this.getDropProcedure(schema, procedure));
            sb.append(";\n");
        }
        for (Schema.View view : schema.getViews()) {
            sb.append(this.getDropView(schema, view));
            sb.append(";\n");
        }
        String drSchema = this.getDropSchema(schema);
        if (drSchema != null && !drSchema.equals("")) {
            sb.append(drSchema);
            sb.append(";\n");
        }
        for (Schema.Sequence sequence : schema.getSequences()) {
            sb.append(this.getDropSequence(sequence));
        }
        return sb.toString();
    }

    public String showDropUser(String user, String password) {
        return this.showDropUser(user, password, this.getConnector().getProperties());
    }

    public String showDropUser(String user, String password, Properties p) {
        return "-- You need to execute these sentences connected as dba user.\n";
    }

    public boolean supportsOnDelete() {
        return this.getConnectorInterface().supports(0x800000L);
    }

    public boolean supportsCursors() {
        return this.getConnectorInterface().supports(16L);
    }

    public boolean supportsDBCreation() {
        return this.getConnectorInterface().supports(2L);
    }

    public boolean supportsDBDropping() {
        return this.getConnectorInterface().supports(32L);
    }

    public boolean supportsDSCreation() {
        return this.getConnectorInterface().supports(4L);
    }

    public boolean supportsDSDropping() {
        return this.getConnectorInterface().supports(64L);
    }

    public boolean supportsFuegoSequence() {
        return this.getConnectorInterface().supports(16384L);
    }

    public boolean supportsJDBC20() {
        return this.getConnectorInterface().supports(1024L);
    }

    public boolean supportsLockNoWait() {
        return this.getConnectorInterface().supports(32768L);
    }

    public boolean supportsProcedureCatalog() {
        return this.getConnectorInterface().supports(262144L);
    }

    public boolean supportsReadOnlyColumns() {
        return this.getConnectorInterface().supports(131072L);
    }

    public boolean supportsSubtract() {
        return this.getConnectorInterface().supports(0x400000L);
    }

    public boolean isDateEqualsTimestamp() {
        return false;
    }

    public String[] getAddColumns(String schemaName, String tableName, List<Schema.Field> newColumns, List<Schema.Field> modifiedColumns) throws DatabaseException {
        Schema.Field field;
        Iterator<Schema.Field> it;
        StringBuffer str = new StringBuffer();
        str.append("ALTER TABLE ");
        str.append(this.getFullTableName(schemaName, tableName));
        if (newColumns.size() > 0) {
            str.append(" ADD ");
            it = newColumns.iterator();
            while (it.hasNext()) {
                field = it.next();
                str.append(this.getCreateField(field));
                if (!it.hasNext()) continue;
                str.append(", ");
            }
        }
        if (modifiedColumns.size() > 0) {
            str.append(" MODIFY ");
            it = modifiedColumns.iterator();
            while (it.hasNext()) {
                field = it.next();
                str.append(this.getCreateField(field));
                if (!it.hasNext()) continue;
                str.append(", ");
            }
        }
        String[] queries = new String[]{str.toString()};
        return queries;
    }

    public String[] getCreateTriggers(Schema schema, Schema.Table table) {
        return EMPTY_STRING_ARRAY;
    }

    public final String getOnDeleteAction(int action) {
        if (action == 2) {
            return "SET NULL";
        }
        if (action == 1) {
            return "CASCADE";
        }
        return "";
    }

    public String getOrderByColumnCollation(String column, int kind, oracle.bpm.components.Locale locale) {
        String result = null;
        if (locale != null) {
            Locale javaLocale = locale.getLocale();
            DatabaseCollationSupport databaseCollationSupport = this.getDatabaseCollationSupport();
            if (javaLocale != null && databaseCollationSupport != null) {
                result = databaseCollationSupport.getOrderByColumnCollation(column, kind, javaLocale);
            }
        }
        return result == null ? column : result;
    }

    public int getNCHAR_SQLType() {
        throw new UnsupportedOperationException();
    }

    public int getNVARCHAR_SQLType() {
        throw new UnsupportedOperationException();
    }

    public int getNCLOB_SQLType() {
        throw new UnsupportedOperationException();
    }

    public final String upperCase(String name) {
        if (System.getProperty(DO_NOT_PASS_TABLE_TO_UPPERCASE) != null || this.connector_d.getAdditionalProperty(DO_NOT_PASS_TABLE_TO_UPPERCASE) != null) {
            return name;
        }
        return name.toUpperCase();
    }

    public boolean requiresUnionWorkaround() {
        return this.getConnectorInterface().supports(0x20000000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Schema.Field[] filterExistingFields(String table, Schema.Field[] fields) throws SQLException {
        boolean isNewConnection = false;
        try {
            if (this.getConnection() == null) {
                this.connect();
                isNewConnection = true;
            }
            ArrayList<Schema.Field> existingColumns = new ArrayList<Schema.Field>();
            for (int i = 0; i < fields.length; ++i) {
                Schema.Field fieldDescr = this.getFieldForColumn(this.getSchemaName(), table, fields[i].name);
                if (fieldDescr == null) continue;
                existingColumns.add(fields[i]);
            }
            Schema.Field[] fieldArray = existingColumns.toArray(new Schema.Field[existingColumns.size()]);
            return fieldArray;
        }
        catch (ClassNotFoundException e) {
            Log.logSevere(e);
            Schema.Field[] fieldArray = null;
            return fieldArray;
        }
        finally {
            if (this.getConnection() != null && isNewConnection) {
                try {
                    this.getConnection().close();
                }
                catch (SQLException ignore) {}
                this.systemConnection_d = null;
            }
        }
    }

    protected abstract boolean isFloat(String var1);

    protected abstract int getMaxDecimalPrecision();

    protected abstract boolean isNumeric(String var1);

    protected abstract boolean isString(String var1);

    protected abstract String convertType(Schema.Field var1);

    protected abstract String convertType(int var1);

    protected abstract void systemConnect(String var1, String var2, Properties var3) throws SQLException, ClassNotFoundException;

    protected static StringBuilder appendError(StringBuilder errors, SQLException exception) {
        if (errors == null) {
            errors = new StringBuilder();
        }
        errors.append(exception.getMessage()).append("\n");
        return errors;
    }

    protected String getSQLSentencesSeparator() {
        return ";\n";
    }

    protected boolean hasInterTableTriggerDependencies() {
        return false;
    }

    protected final void createTriggers(Schema schema, Schema.Table table) throws SQLException {
        String[] triggers;
        for (String trigger : triggers = this.getCreateTriggers(schema, table)) {
            this.runStatement(this.getConnection(), trigger);
        }
    }

    protected final void executeRawSentences(Schema schema) throws SQLException {
        String name = this.getConnectorInterface().getConfigType().getName();
        for (Schema.RawSentence sentence : schema.getRawSentences(name)) {
            this.runStatement(this.getConnection(), this.getRawSentence(sentence));
        }
    }

    protected Connection getConnection() {
        return this.systemConnection_d;
    }

    protected BaseJDBCConnector getConnector() {
        return this.connector_d;
    }

    protected JDBCConnectorInterface getConnectorInterface() {
        if (this.connector_d != null) {
            return this.connector_d;
        }
        return this.jdbcConnectorInterface_d;
    }

    protected String getDropProcedure(Schema schema, Schema.Procedure p) {
        return "DROP PROCEDURE " + this.getFullTableName(schema.name, this.upperCase(p.name)) + " CASCADE";
    }

    protected String getDropSchema(Schema schema) {
        return "DROP SCHEMA " + schema.name;
    }

    protected String getDropTable(Schema schema, Schema.Table table) {
        return "DROP TABLE " + this.getFullTableName(schema.name, this.upperCase(table.name));
    }

    protected String getDropView(Schema schema, Schema.View view) {
        return "DROP VIEW " + this.getFullTableName(schema.name, this.upperCase(view.name));
    }

    protected String getInsertStatement(Schema schema, Schema.Statement stmt) {
        StringBuilder ret = new StringBuilder();
        StringBuilder names = new StringBuilder();
        StringBuilder values = new StringBuilder();
        ret.append("INSERT INTO ");
        ret.append(this.getFullTableName(schema.name, this.upperCase(stmt.table)));
        for (Schema.NameValue nameValue : stmt.values) {
            if (names.length() > 0) {
                names.append(",");
                values.append(",");
            }
            names.append(this.upperCase(nameValue.name));
            values.append(nameValue.value);
        }
        ret.append("(");
        ret.append((CharSequence)names);
        ret.append(") VALUES(");
        ret.append((CharSequence)values);
        ret.append(")");
        return ret.toString();
    }

    protected String getRawSentence(Schema.RawSentence sentence) {
        return sentence.toString();
    }

    protected String getCreateForeignKeys(String schemaName, Schema.Table table) {
        StringBuilder s = new StringBuilder();
        for (Schema.ForeignKey foreignKey : table.getForeignKeys()) {
            s.append(",\n\tFOREIGN KEY(");
            s.append(this.upperCase(foreignKey.fields));
            s.append(") REFERENCES ");
            s.append(this.getFullTableName(schemaName, this.upperCase(foreignKey.referencedTable)));
            s.append("(");
            s.append(this.upperCase(foreignKey.referencedFields));
            s.append(")");
            if (!this.supportsOnDelete() || foreignKey.ondelete == -1) continue;
            s.append(" ON DELETE ");
            s.append(this.getOnDeleteAction(foreignKey.ondelete));
        }
        return s.toString();
    }

    protected String getCreatePrimaryKey(Schema.Table table) {
        StringBuilder str = new StringBuilder();
        str.append("PRIMARY KEY (");
        str.append(this.asCSVString(table.getPrimaryKeyFieldNames()));
        str.append(")\n");
        return str.toString();
    }

    protected String getCreateUnique(Schema.Table table) {
        StringBuilder str = new StringBuilder();
        str.append("UNIQUE (");
        str.append(this.asCSVString(table.getUniqueFieldNames()));
        str.append(")\n");
        return str.toString();
    }

    protected String getCreateProcedure(Schema schema, Schema.Procedure p) {
        StringBuilder str = new StringBuilder();
        str.append("CREATE PROCEDURE ");
        str.append(this.getFullTableName(schema.name, this.upperCase(p.name)));
        str.append("\n");
        if (p.arguments.size() > 0) {
            str.append("(");
            boolean first = true;
            for (Schema.Argument a : p.arguments) {
                if (first) {
                    first = false;
                } else {
                    str.append(", ");
                }
                str.append(this.getCreateProcedureArg(a));
            }
            str.append(")\n");
        }
        str.append("AS\n\t");
        str.append(p.code);
        str.append("\nEND;\n");
        return str.toString();
    }

    protected String getCreateProcedureArg(Schema.Argument a) {
        StringBuilder str = new StringBuilder();
        str.append(a.name);
        str.append(" ");
        str.append(this.convertArgType(a.argType));
        str.append(" ");
        str.append(this.convertType(a));
        return str.toString();
    }

    protected String getCreateView(Schema schema, Schema.View v) {
        StringBuilder str = new StringBuilder();
        str.append("CREATE VIEW ");
        str.append(this.getFullTableName(schema.name, this.upperCase(v.name)));
        str.append("\n");
        str.append("AS\n\t");
        str.append(this.upperCase(v.statement));
        str.append("\n");
        return str.toString();
    }

    protected String getDefaultNullSentence() {
        return "DEFAULT NULL";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] getTables(String schemaName) throws SQLException {
        StringList tabnames = StringList.create();
        DatabaseMetaData mdata = this.getConnection().getMetaData();
        String catalog = this.getConnection().getCatalog();
        String[] types = new String[]{"TABLE"};
        ResultSet tables = null;
        try {
            tables = mdata.getTables(catalog, null, "%", types);
            while (tables.next()) {
                String schema = tables.getString(2);
                if (schemaName != null && !schemaName.equalsIgnoreCase(schema)) continue;
                String name = tables.getString(3);
                tabnames.add(name);
            }
        }
        finally {
            if (tables != null) {
                try {
                    tables.close();
                }
                catch (SQLException ignore) {}
            }
        }
        return tabnames.toArray(EMPTY_STRING_ARRAY);
    }

    protected String asCSVString(StringList strings) {
        StringBuilder str = new StringBuilder();
        for (String field : strings) {
            if (str.length() > 0) {
                str.append(",");
            }
            str.append(this.upperCase(field));
        }
        return str.toString();
    }

    protected boolean compatibleTypes(String type1, String type2) {
        if (type1.equalsIgnoreCase(type2)) {
            return true;
        }
        if (this.isNumeric(type1) && this.isNumeric(type2)) {
            return true;
        }
        if (this.isFloat(type1) && this.isFloat(type2)) {
            return true;
        }
        return this.isString(type1) && this.isString(type2);
    }

    protected void connect() throws SQLException, ClassNotFoundException {
        try {
            String driver = this.getConnector().getDriverClass();
            Properties info = this.getConnector().getConnectionProperties();
            Class.forName(driver);
            this.systemConnection_d = DriverManager.getConnection(this.getConnector().getURL(), info);
            DatabaseManager.unlockConnection(this.systemConnection_d);
        }
        catch (UnsatisfiedLinkError e) {
            throw new ClassNotFoundException(e.getMessage());
        }
    }

    protected String convertArgType(int type) {
        if (type == 0) {
            return "IN";
        }
        if (type == 1) {
            return "OUT";
        }
        if (type == 2) {
            return "IN OUT";
        }
        return "";
    }

    protected void createIndexes(Schema.Table t, Schema schema) throws SQLException {
        for (Schema.Index ind : t.getIndexes()) {
            this.runStatement(this.getConnection(), this.getCreateIndex(schema, t, ind));
        }
    }

    protected String getCreateField(Schema.Field fld) {
        String size = fld.size;
        if (this.isNumeric(fld.strType) && size != null) {
            int precision;
            try {
                StringTokenizer stok = new StringTokenizer(size, ",");
                precision = Integer.parseInt(stok.nextToken());
            }
            catch (NoSuchElementException e) {
                precision = Integer.parseInt(size);
            }
            if (precision > this.getMaxDecimalPrecision()) {
                throw new RuntimeException(LibMsg.INVALID_DECIMAL_PRECISION("" + precision, "" + this.getMaxDecimalPrecision()).toString());
            }
        }
        StringBuilder str = new StringBuilder();
        str.append(this.upperCase(fld.name));
        str.append(" ");
        str.append(this.convertType(fld));
        if (fld.size != null) {
            str.append(" (");
            if (this.hasStringLimit() && fld.restrictedSize != null) {
                str.append(fld.restrictedSize);
            } else {
                str.append(fld.size);
            }
            str.append(") ");
        }
        str.append(this.getDefaultValue(fld));
        boolean ignoreNull = Boolean.getBoolean("oracle.bpm.jdbc.IgnoreNullOnFieldCreation");
        if (!ignoreNull) {
            if (fld.allowNull) {
                str.append(" ");
                str.append(this.getDefaultNullSentence());
            } else {
                str.append(" NOT NULL");
            }
        }
        return str.toString();
    }

    protected String getFieldDefaultValue(Schema.Field field) {
        return "";
    }

    protected boolean hasStringLimit() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void runStatement(Connection conn, String stmtText) throws SQLException {
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            if (Log.isDebugging()) {
                Log.logDebug(LibMsg.EXECUTING(stmtText));
            }
            stmt.execute(stmtText);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ignore) {}
            }
        }
    }

    protected void setDatabaseCollationSupport(DatabaseCollationSupport databaseCollationSupport) {
        this.databaseCollationSupport = databaseCollationSupport;
    }

    protected DatabaseCollationSupport getDatabaseCollationSupport() {
        return this.databaseCollationSupport;
    }

    private String getDefaultValue(Schema.Field fld) {
        String value = this.getFieldDefaultValue(fld);
        if ((value == null || "".equals(value.trim())) && fld.defaultValue != null && !"".equals(fld.defaultValue)) {
            value = " DEFAULT " + fld.defaultValue + " ";
        }
        return value;
    }

    private void classifyColumns(String schemaName, String tableName, List<Schema.Field> columnList, List<Schema.Field> newColumns, List<Schema.Field> modifiedColumns) throws SQLException {
        for (Schema.Field c : columnList) {
            Schema.Field column = c.clone();
            column.allowNull = true;
            Schema.Field existingCol = this.getFieldForColumn(schemaName, this.upperCase(tableName), this.upperCase(column.name));
            int kind = Kind.getKind(column.strType);
            String newCollumConvertedType = this.convertType(kind);
            if (existingCol == null) {
                column.strType = newCollumConvertedType;
                newColumns.add(column);
                continue;
            }
            if (!this.compatibleTypes(existingCol.strType, newCollumConvertedType)) {
                throw new ColumnAlreadyExistsWithDifferentTypeException(column.name, existingCol.strType, column.strType);
            }
            if (Kind.hasFixedSize(Kind.getKind(column.strType)) || !this.updateSize(column, existingCol)) continue;
            column.strType = newCollumConvertedType;
            modifiedColumns.add(column);
        }
    }

    private boolean updateSize(Schema.Field fld1, Schema.Field fld2) {
        if (fld1.strType.equals(Kind.getName(5))) {
            int fld2Size;
            int fld1Size = Integer.parseInt(fld1.size);
            if (fld1Size > (fld2Size = Integer.parseInt(fld2.size))) {
                return true;
            }
        } else if (fld1.strType.equals(Kind.getName(3))) {
            int decimalSize;
            int fld2Size;
            int fld1Size;
            int fld1DecimalSize = 0;
            try {
                StringTokenizer stok = new StringTokenizer(fld1.size, ",");
                fld1Size = Integer.parseInt(stok.nextToken());
                fld1DecimalSize = Integer.parseInt(stok.nextToken());
            }
            catch (NoSuchElementException e) {
                fld1Size = Integer.parseInt(fld1.size);
            }
            int fld2DecimalSize = 0;
            try {
                StringTokenizer stok = new StringTokenizer(fld2.size, ",");
                fld2Size = Integer.parseInt(stok.nextToken());
                fld2DecimalSize = Integer.parseInt(stok.nextToken());
            }
            catch (NoSuchElementException e) {
                fld2Size = Integer.parseInt(fld2.size);
            }
            int size = fld1Size > fld2Size ? fld1Size : fld2Size;
            int n = decimalSize = fld1DecimalSize > fld2DecimalSize ? fld1DecimalSize : fld2DecimalSize;
            if (size != fld2Size || decimalSize != fld2DecimalSize) {
                fld1.restrictedSize = fld1.size = "" + size + "," + decimalSize;
                return true;
            }
        }
        return false;
    }

    public static final class ColumnAlreadyExistsWithDifferentTypeException
    extends SQLException {
        private String column;
        private String existingType;
        private String requiredType;
        private static final long serialVersionUID = 7521560956683400162L;

        private ColumnAlreadyExistsWithDifferentTypeException(String colum, String existingType, String requiredType) {
            super(LibMsg.COLUMN_ALREADY_EXISTS(colum, existingType, requiredType).getString());
            this.column = colum;
            this.existingType = existingType;
            this.requiredType = requiredType;
        }

        public String getColumn() {
            return this.column;
        }

        public String getExistingType() {
            return this.existingType;
        }

        public String getRequiredType() {
            return this.requiredType;
        }
    }
}

