/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.io;

import java.io.IOException;
import java.io.InputStream;
import oracle.bpm.io.RemoteInputBlockWriter;
import oracle.bpm.io.TransportBlock;

public class RemoteClientInputStream
extends InputStream {
    protected TransportBlock block = null;
    protected int pos = 0;
    private RemoteInputBlockWriter ribw_d = null;

    public RemoteClientInputStream(TransportBlock tb) throws IOException {
        if (tb == null) {
            throw new IOException("Transport Block must not be null");
        }
        if (tb.hasNext) {
            throw new IOException("Must be a single block stream");
        }
        this.block = tb;
        this.ribw_d = null;
    }

    public RemoteClientInputStream(TransportBlock tb, RemoteInputBlockWriter ribw) throws IOException {
        if (tb == null) {
            throw new IOException("Transport Block must not be null");
        }
        this.block = tb;
        this.ribw_d = ribw;
    }

    @Override
    public int available() throws IOException {
        if (this.block == null) {
            throw new IOException("Invalid Operation on a closed stream");
        }
        return this.block.data.length - this.pos;
    }

    @Override
    public void close() throws IOException {
        if (this.block != null) {
            this.block = null;
            if (this.ribw_d != null) {
                this.ribw_d.sendResponse();
            }
        }
    }

    @Override
    public int read() throws IOException {
        if (this.block == null) {
            return -1;
        }
        if (this.pos >= this.block.data.length) {
            while (this.block.hasNext) {
                this.block = this.ribw_d.readBlock();
                this.pos = 0;
                if (this.block.data.length <= this.pos) continue;
                return this.block.data[this.pos++] & 0xFF;
            }
            this.close();
            return -1;
        }
        return this.block.data[this.pos++] & 0xFF;
    }

    protected void finalize() throws Exception {
        if (this.block != null) {
            this.close();
        }
    }
}

