/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.io;

import java.io.IOException;
import java.io.InputStream;

public class InputStreamView
extends InputStream {
    private boolean allowClose;
    private int count;
    private InputStream in;
    private int limit;

    public InputStreamView(int limit, InputStream in, boolean allowClose) {
        this.allowClose = allowClose;
        if (limit < 0) {
            throw new IllegalArgumentException("limit cannot be negative: " + limit);
        }
        if (in == null) {
            throw new NullPointerException("in cannot be null");
        }
        this.limit = limit;
        this.in = in;
    }

    @Override
    public int available() throws IOException {
        int available = this.in.available();
        return Math.min(available, this.limit - this.count);
    }

    @Override
    public void close() throws IOException {
        if (this.allowClose) {
            this.in.close();
        }
    }

    @Override
    public int read() throws IOException {
        if (this.count == this.limit) {
            return -1;
        }
        int datum = this.in.read();
        if (datum != -1) {
            ++this.count;
        }
        return datum;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result;
        if (b == null) {
            throw new NullPointerException("b cannot be null");
        }
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException("off=" + off + ", len=" + len);
        }
        if (this.count == this.limit) {
            return -1;
        }
        int available = this.limit - this.count;
        if (len > available) {
            len = available;
        }
        if ((result = this.in.read(b, off, len)) != -1) {
            this.count += len;
        }
        return result;
    }
}

