/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.io;

import java.io.IOException;
import java.io.InputStream;
import oracle.bpm.io.TransportBlock;

public class BlockReader {
    private int bs;
    private int index = -1;
    private InputStream is = null;
    public static final int DEFAULT_SIZE = 32768;
    public static final int MAX_SIZE = 0x1400000;
    public static final int DEFAULT_CIL_SIZE = 0x1400000;

    public BlockReader(InputStream inputStream) {
        this(inputStream, 32768);
    }

    public BlockReader(InputStream inputStream, int blockSize) {
        assert (inputStream != null) : "inputStream cannot be null";
        assert (blockSize > 0) : "block size must be greater than zero";
        this.is = inputStream;
        if (blockSize > 0x1400000) {
            blockSize = 0x1400000;
        }
        this.bs = blockSize;
    }

    public void setIndex(int i) {
        if (i <= 0) {
            throw new RuntimeException("Reader Index(" + i + ") should always be > 0");
        }
        this.index = i;
    }

    public int getIndex() {
        return this.index;
    }

    public void abort() throws IOException {
    }

    public void close() throws IOException {
        this.is.close();
        this.is = null;
    }

    public TransportBlock read() throws IOException {
        if (this.is == null) {
            throw new IllegalStateException("Invalid operation on a closed reader");
        }
        TransportBlock block = new TransportBlock(this.index, this.bs);
        int bytesRead = this.readFully(block.data, 0, this.bs);
        if (bytesRead >= this.bs) {
            block.hasNext = true;
        } else {
            byte[] lastBuffer;
            if (bytesRead == -1) {
                lastBuffer = new byte[]{};
            } else {
                lastBuffer = new byte[bytesRead];
                System.arraycopy(block.data, 0, lastBuffer, 0, bytesRead);
            }
            block.data = lastBuffer;
            block.hasNext = false;
            this.close();
        }
        return block;
    }

    protected void finalize() throws IOException {
        if (this.is != null) {
            this.close();
        }
    }

    private int readFully(byte[] b, int off, int len) throws IOException {
        int n;
        int count;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (n = 0; n < len && (count = this.is.read(b, off + n, len - n)) >= 0; n += count) {
        }
        return n;
    }
}

