/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Map;
import java.util.TreeMap;
import oracle.bpm.http.HttpException;
import oracle.bpm.http.HttpMessage;
import oracle.bpm.io.InputStreamView;
import oracle.bpm.util.StringTokenizer;

public class HttpRequest
extends HttpMessage {
    private Map<String, String> arguments;
    private InputStream input;
    private int major;
    private int method;
    private int minor;
    private String path;
    private static final ByteArrayInputStream BYTE_ARRAY_INPUT_STREAM = new ByteArrayInputStream(new byte[0]);
    private static final char CR = '\r';
    private static final char LF = '\n';
    private static final char SP = ' ';
    private static final char HT = '\t';
    private static final int MAX_URI_LEN = 65535;

    public HttpRequest() {
    }

    private HttpRequest(InputStream in) throws IOException, HttpException {
        this.parse(in);
    }

    public static HttpRequest createFrom(InputStream in) throws IOException, HttpException {
        return new HttpRequest(in);
    }

    public void setArguments(Map<String, String> args) {
        this.arguments = args;
    }

    public Map<String, String> getArguments() {
        return this.arguments;
    }

    public InputStream getInputStream() {
        return this.input;
    }

    public int getMajor() {
        return this.major;
    }

    public void setMethod(int method) {
        this.method = method;
    }

    public int getMethod() {
        return this.method;
    }

    public int getMinor() {
        return this.minor;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Method    : ");
        switch (this.method) {
            case 1: {
                buffer.append("GET");
                break;
            }
            case 2: {
                buffer.append("POST");
                break;
            }
            case 3: {
                buffer.append("HEAD");
            }
        }
        buffer.append("\n");
        buffer.append("File      : " + this.getPath() + "\n");
        buffer.append("Arguments : \n" + this.getArguments() + "\n");
        buffer.append("Headers   : \n" + this.getHeaders() + "\n");
        return buffer.toString();
    }

    private static boolean isChar(int c) {
        return (c & 0xFFFFFF80) == 0;
    }

    private static boolean isControl(int c) {
        return c >= 0 && c <= 31 || c == 127;
    }

    private static boolean isDigit(int c) {
        return HttpRequest.toChar(c) >= '0' && HttpRequest.toChar(c) <= '9';
    }

    private static boolean isEof(int c) {
        return c == -1;
    }

    private static boolean isLinearWhitespace(int c) {
        return ' ' == HttpRequest.toChar(c) || '\t' == HttpRequest.toChar(c);
    }

    private static boolean isSeparator(int c) {
        switch (HttpRequest.toChar(c)) {
            case '\t': 
            case ' ': 
            case '\"': 
            case '(': 
            case ')': 
            case ',': 
            case '/': 
            case ':': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '[': 
            case '\\': 
            case ']': 
            case '{': 
            case '}': {
                return true;
            }
        }
        return false;
    }

    private static boolean isText(int c) {
        return !HttpRequest.isEof(c) && !HttpRequest.isControl(c);
    }

    private static boolean isToken(int c) {
        return HttpRequest.isChar(c) && !HttpRequest.isSeparator(c) && !HttpRequest.isControl(c);
    }

    private static void consumeChar(InputStream in, char target) throws IOException, HttpException {
        int c = in.read();
        if (HttpRequest.toChar(c) != target) {
            throw new HttpException(400, "Unexpected char '" + HttpRequest.toChar(c) + "' expecting " + target);
        }
    }

    private static void consumeLineTerminator(PushbackInputStream pin) throws IOException, HttpException {
        int c = pin.read();
        if (HttpRequest.toChar(c) != '\r') {
            throw new HttpException(400, "Unexpected character: " + HttpRequest.toChar(c) + ", expecting CR");
        }
        c = pin.read();
        if (HttpRequest.toChar(c) != '\n') {
            throw new HttpException(400, "Unexpected character: " + HttpRequest.toChar(c) + ", expecting CR");
        }
    }

    private static String decode(String buffer) throws UnsupportedEncodingException {
        return URLDecoder.decode(buffer, "UTF-8");
    }

    private static int parseInteger(PushbackInputStream pin) throws IOException {
        int value = 0;
        int c = pin.read();
        while (HttpRequest.isDigit(c)) {
            value *= 10;
            value += HttpRequest.toChar(c) - 48;
            c = pin.read();
        }
        pin.unread(c);
        return value;
    }

    private static Map parseQuery(String query) throws UnsupportedEncodingException {
        TreeMap<String, String> arguments = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        if (query != null) {
            StringTokenizer st = new StringTokenizer(query, "&");
            while (st.hasMoreTokens()) {
                String value;
                String key;
                String arg = st.nextToken();
                int eq = arg.indexOf(61);
                if (eq == -1) {
                    key = HttpRequest.decode(arg);
                    value = null;
                } else {
                    key = HttpRequest.decode(arg.substring(0, eq));
                    value = HttpRequest.decode(arg.substring(eq + 1));
                }
                arguments.put(key, value);
            }
        }
        return arguments;
    }

    private static String parseToken(PushbackInputStream pin) throws IOException {
        StringBuffer buffer = new StringBuffer();
        int c = pin.read();
        while (HttpRequest.isToken(c)) {
            buffer.append(HttpRequest.toChar(c));
            c = pin.read();
        }
        pin.unread(c);
        return buffer.toString();
    }

    private static URI parseUri(PushbackInputStream pin) throws IOException, HttpException {
        StringBuffer buffer = new StringBuffer();
        int c = pin.read();
        while (HttpRequest.toChar(c) != ' ') {
            buffer.append(HttpRequest.toChar(c));
            if (buffer.length() > 65535) {
                throw new HttpException(414, "Request-URI Too Long");
            }
            c = pin.read();
        }
        pin.unread(c);
        return URI.create(buffer.toString());
    }

    private static String parseValue(PushbackInputStream pin) throws IOException, HttpException {
        StringBuffer buffer = new StringBuffer();
        int c = pin.read();
        while (HttpRequest.isText(c)) {
            buffer.append(HttpRequest.toChar(c));
            c = pin.read();
        }
        pin.unread(c);
        HttpRequest.consumeLineTerminator(pin);
        return buffer.toString();
    }

    private static void skipWhitespace(PushbackInputStream pin) throws IOException {
        int c;
        while (HttpRequest.isLinearWhitespace(c = pin.read())) {
        }
        pin.unread(c);
    }

    private static char toChar(int c) {
        return (char)(0x7F & c);
    }

    private void parse(InputStream in) throws IOException, HttpException {
        PushbackInputStream pin = new PushbackInputStream(in, 1);
        String method = HttpRequest.parseToken(pin);
        HttpRequest.consumeChar(pin, ' ');
        URI uri = HttpRequest.parseUri(pin);
        Map arguments = HttpRequest.parseQuery(uri.getRawQuery());
        HttpRequest.consumeChar(pin, ' ');
        this.parseHttpVersion(pin);
        HttpRequest.consumeLineTerminator(pin);
        if (method.equals("GET")) {
            this.method = 1;
        } else if (method.equals("POST")) {
            this.method = 2;
        } else {
            throw new HttpException(405, "BAD METHOD");
        }
        this.path = uri.getPath();
        this.arguments = arguments;
        this.parseHeaders(pin);
        if (this.method != 2) {
            this.input = BYTE_ARRAY_INPUT_STREAM;
        } else {
            try {
                int limit = Integer.parseInt(this.getHeader("Content-length"));
                this.input = new InputStreamView(limit, in, false);
            }
            catch (NumberFormatException e) {
                throw new HttpException(400, "Number format exception");
            }
        }
    }

    private void parseHeaders(PushbackInputStream pin) throws IOException, HttpException {
        int c;
        String key = null;
        String value = null;
        while (true) {
            if (HttpRequest.isEof(c = pin.read())) {
                throw new HttpException(400, "Unexpected end of stream");
            }
            if (HttpRequest.isToken(c)) {
                if (key != null) {
                    this.setHeader(key, value);
                }
                pin.unread(c);
                key = HttpRequest.parseToken(pin);
                c = pin.read();
                if (HttpRequest.toChar(c) != ':') {
                    throw new HttpException(400, "Unexpected character: " + HttpRequest.toChar(c) + ", expecting ':'");
                }
                HttpRequest.skipWhitespace(pin);
                value = HttpRequest.parseValue(pin);
                continue;
            }
            if (HttpRequest.isLinearWhitespace(c)) {
                value = value + HttpRequest.parseValue(pin);
                continue;
            }
            if (HttpRequest.toChar(c) == '\r') break;
        }
        pin.unread(c);
        HttpRequest.consumeLineTerminator(pin);
        if (key != null) {
            this.setHeader(key, value);
        }
        if (this.method != 2) {
            this.input = null;
        } else {
            try {
                int limit = Integer.parseInt(this.getHeader("Content-length"));
                this.input = new InputStreamView(limit, pin, false);
            }
            catch (NumberFormatException e) {
                throw new HttpException(400, "Number format exception");
            }
        }
    }

    private void parseHttpVersion(PushbackInputStream pin) throws IOException, HttpException {
        String http = HttpRequest.parseToken(pin);
        if (!"HTTP".equals(http)) {
            throw new HttpException(400, "expecting 'HTTP'");
        }
        HttpRequest.consumeChar(pin, '/');
        this.major = HttpRequest.parseInteger(pin);
        HttpRequest.consumeChar(pin, '.');
        this.minor = HttpRequest.parseInteger(pin);
    }
}

