/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.http;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import oracle.bpm.component.ExecutionThread;
import oracle.bpm.http.AbstractHttpCommand;
import oracle.bpm.http.HttpCommand;
import oracle.bpm.http.HttpExecution;
import oracle.bpm.http.HttpResponse;
import oracle.bpm.http.HttpWorker;
import oracle.bpm.lang.Str;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.log.Log;
import oracle.bpm.util.Dump;
import oracle.bpm.util.ObjectWatch;

public class HttpCommandServer
implements Runnable {
    private HttpCommand commandList;
    private Map<String, HttpCommand> commands;
    private Thread dispatcher;
    private IOException exception;
    private ThreadGroup group;
    private String keystoreFile;
    private String keystorePassword;
    private InetAddress lastClient;
    private int port;
    private ServerSocket serverSocket;
    private String sslProtocol;
    private int timeout;
    private boolean useFramework;
    private boolean useSsl;
    private int workerCount = 5;
    private HttpWorker[] workers;
    private static HttpCommandServer httpServer;
    private static final byte[] EOL;

    public HttpCommandServer() {
        this(8080);
    }

    public HttpCommandServer(int port) {
        this(port, false, null, null, null);
    }

    public HttpCommandServer(int port, boolean useFramework) {
        this(port, useFramework, null, null, null);
    }

    public HttpCommandServer(int port, boolean useFramework, String sslProtocol, String keystorefile, String keystorePassword) {
        this.port = port;
        this.commands = new TreeMap<String, HttpCommand>();
        this.commandList = new CommandList();
        this.useFramework = useFramework;
        if (sslProtocol != null) {
            this.useSsl = true;
            this.sslProtocol = sslProtocol;
            this.keystoreFile = keystorefile;
            this.keystorePassword = keystorePassword;
        }
    }

    public static HttpCommandServer getDefault() {
        if (httpServer == null) {
            httpServer = new HttpCommandServer();
        }
        return httpServer;
    }

    public static void main(String[] args) throws Throwable {
        HttpCommandServer server = HttpCommandServer.getDefault();
        server.setPort(Integer.parseInt(args[0]));
        Dump.registerCommands(server);
        ObjectWatch watch = new ObjectWatch("httpserver", "Http Command Server", server);
        server.register(watch);
        server.start();
        server.stop();
        server.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpCommand getCommandForPath(String path) {
        HttpCommand command = null;
        Map<String, HttpCommand> map = this.commands;
        synchronized (map) {
            for (Map.Entry<String, HttpCommand> entry : this.commands.entrySet()) {
                String key = entry.getKey();
                if (!path.startsWith(key)) continue;
                command = entry.getValue();
            }
        }
        if (command == null && path.equals("") || path.equals("/")) {
            command = this.commandList;
        }
        return command;
    }

    public InetAddress getLastClient() {
        return this.lastClient;
    }

    public synchronized void setPort(int port) throws IllegalStateException {
        if (this.isRunning()) {
            throw new IllegalStateException("Port cannot be changed while the http is running");
        }
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public synchronized boolean isRunning() {
        return this.dispatcher != null;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setWorkerCount(int count) {
        this.workerCount = count;
    }

    public int getWorkerCount() {
        return this.workerCount;
    }

    public boolean isRegistered(HttpCommand command) {
        return this.commands.containsKey("/" + command.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(HttpCommand command) {
        Map<String, HttpCommand> map = this.commands;
        synchronized (map) {
            this.commands.put("/" + command.getName(), command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.serverSocket = null;
        try {
            this.serverSocket = this.useSsl ? this.createSslServerSocket() : new ServerSocket(this.port);
        }
        catch (IOException e) {
            this.exception = e;
            return;
        }
        finally {
            HttpCommandServer httpCommandServer = this;
            synchronized (httpCommandServer) {
                this.notify();
            }
        }
        while (this.dispatcher != null && !this.dispatcher.isInterrupted()) {
            try {
                Socket client = this.serverSocket.accept();
                if (this.useFramework) {
                    HttpExecution execution = new HttpExecution(client, this);
                    ExecutionThread.processRequest(execution);
                    continue;
                }
                this.processSocket(client);
            }
            catch (SocketException e) {
            }
            catch (Throwable e) {
                Log.logWarning(e);
            }
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
                this.serverSocket = null;
            }
            catch (IOException e) {
                Log.logWarning(e);
            }
        }
        LibMsg.HTTP_SERVER_STOPPED(this.port).logInfo();
    }

    public synchronized void start() throws IOException {
        this.start(this.getPort());
    }

    public synchronized void start(int port) throws IllegalStateException, IOException {
        this.exception = null;
        LibMsg.HTTP_SERVER_STARTING(port).logInfo();
        if (this.isRunning()) {
            throw new IllegalStateException("Http server is already running on port:" + this.port);
        }
        this.setPort(port);
        if (this.group == null) {
            this.group = new ThreadGroup("Http Workers");
        }
        this.dispatcher = new Thread(this.group, this, "Http Command Dispatcher");
        this.dispatcher.setDaemon(true);
        this.dispatcher.start();
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.exception != null) {
            this.dispatcher = null;
            throw this.exception;
        }
    }

    public synchronized void stop() {
        LibMsg.HTTP_SERVER_STOPPING(this.port).logInfo();
        if (!this.isRunning()) {
            throw new IllegalStateException("Http server is not running");
        }
        Thread dispatcher = this.dispatcher;
        ServerSocket ss = this.serverSocket;
        try {
            this.dispatcher = null;
            this.group.interrupt();
            if (ss != null) {
                ss.close();
            }
            dispatcher.join(1000L);
            if (this.workers != null) {
                for (int i = 0; i < this.workers.length; ++i) {
                    if (this.workers[i] == null) continue;
                    this.workers[i].join(1000L);
                    this.workers[i] = null;
                }
            }
        }
        catch (InterruptedException e) {
            Log.logWarning(e);
        }
        catch (IOException e) {
            Log.logWarning(e);
        }
        this.dispatcher = null;
        this.workers = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(HttpCommand command) {
        Map<String, HttpCommand> map = this.commands;
        synchronized (map) {
            this.commands.remove(command.getName());
        }
    }

    private HttpWorker findFreeWorker() {
        if (this.workers == null) {
            this.workers = new HttpWorker[this.workerCount];
        }
        int index = -1;
        int length = this.workers.length;
        for (int i = 0; i < length; ++i) {
            if (this.workers[i] == null) {
                if (this.group == null) {
                    this.group = new ThreadGroup("Http Workers");
                }
                this.workers[i] = new HttpWorker(this.group, this);
                this.workers[i].start();
                index = i;
                break;
            }
            if (this.workers[i].isLocked()) continue;
            index = i;
            break;
        }
        return index != -1 ? this.workers[index] : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSocket(Socket client) throws IOException {
        this.lastClient = client.getInetAddress();
        HttpWorker worker = this.findFreeWorker();
        if (worker == null) {
            OutputStream out = null;
            try {
                out = client.getOutputStream();
                HttpResponse response = new HttpResponse();
                response.setStatus(503);
                response.send(out);
            }
            finally {
                if (out != null) {
                    out.close();
                }
                client.close();
            }
        } else {
            worker.setSocket(client);
        }
    }

    private ServerSocket createSslServerSocket() throws IOException {
        ServerSocket result = null;
        FileInputStream fis = null;
        try {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            fis = new FileInputStream(this.keystoreFile);
            char[] password = this.keystorePassword.toCharArray();
            ks.load(fis, password);
            kmf.init(ks, password);
            SSLContext ctx = SSLContext.getInstance(this.sslProtocol);
            ctx.init(kmf.getKeyManagers(), null, new SecureRandom());
            SSLServerSocketFactory factory = ctx.getServerSocketFactory();
            result = factory.createServerSocket(this.port);
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(ex);
            throw ex;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        return result;
    }

    static {
        EOL = new byte[]{13, 10};
    }

    class CommandList
    extends AbstractHttpCommand {
        CommandList() {
            super("commandlist", "command list");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(Map args, OutputStream output) throws IOException {
            PrintStream out = new PrintStream(output, false);
            TreeMap<String, ArrayList<HttpCommand>> groups = new TreeMap<String, ArrayList<HttpCommand>>();
            StringBuffer buffer = new StringBuffer();
            Map map = HttpCommandServer.this.commands;
            synchronized (map) {
                ArrayList<HttpCommand> commands;
                String group;
                for (HttpCommand httpCommand : HttpCommandServer.this.commands.values()) {
                    if ("commandlist".equals(httpCommand.getName())) continue;
                    group = httpCommand.getGroup();
                    if (group == null || group.equals("")) {
                        group = "default";
                    }
                    if ((commands = (List)groups.get(group)) == null) {
                        commands = new ArrayList<HttpCommand>();
                        groups.put(group, commands);
                    }
                    commands.add(httpCommand);
                }
                for (Map.Entry entry : groups.entrySet()) {
                    group = (String)entry.getKey();
                    commands = (ArrayList<HttpCommand>)entry.getValue();
                    buffer.append("\n<h2>" + group.trim() + "</h2>\n");
                    for (HttpCommand command : commands) {
                        buffer.append(this.item("/" + command.getName(), command.getDescription()));
                    }
                }
            }
            out.print("<html><body bgcolor=white><pre>" + buffer.toString() + "</pre></body></html>");
            out.flush();
        }

        private String item(String command, String descr) {
            String text = "<a href=\"" + command + "\">" + command + "</a>";
            if (command.length() < 20) {
                text = text + Str.valueOf(' ', 20 - command.length());
            }
            text = text + " - " + descr + "\n";
            return text;
        }
    }
}

