/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.holidays;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import oracle.bpm.holidays.Holiday;
import oracle.bpm.lang.Time;

public class HolidayCalendar
implements Serializable {
    private String description;
    private Holiday[] holidays;
    static final long serialVersionUID = 7535678217836534334L;
    static final long serialCheck = -6196381051363813893L;

    public HolidayCalendar(Holiday[] holidays) {
        this(null, holidays);
    }

    public HolidayCalendar(String description, Holiday[] holidays) {
        this.holidays = holidays == null ? new Holiday[]{} : holidays;
        this.description = description;
    }

    HolidayCalendar() {
    }

    private HolidayCalendar(String description, ArrayList holidayList) {
        this(description, new Holiday[holidayList.size()]);
        holidayList.toArray(this.holidays);
    }

    public static HolidayCalendar valueOf(String description, String holidays) {
        int ind;
        ArrayList holidayList = new ArrayList();
        while ((ind = holidays.indexOf(10)) != -1) {
            HolidayCalendar.add(holidays.substring(0, ind), holidayList);
            holidays = holidays.substring(ind + 1);
        }
        HolidayCalendar.add(holidays, holidayList);
        return new HolidayCalendar(description == null ? "" : description, holidayList);
    }

    public static HolidayCalendar copy(HolidayCalendar that) {
        return that == null ? null : new HolidayCalendar(that.getDescription(), that.getHolidays());
    }

    public final String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public final String toString() {
        StringBuffer result = new StringBuffer();
        for (Holiday holiday : this.holidays) {
            result.append(holiday.toString());
            result.append('\n');
        }
        return result.toString();
    }

    public boolean isEmpty() {
        return this.holidays == null || this.holidays.length == 0;
    }

    public Holiday getHoliday(int i) {
        if (this.holidays == null || i < 0 || i >= this.holidays.length) {
            throw new ArrayIndexOutOfBoundsException(i);
        }
        return this.holidays[i];
    }

    public boolean isHoliday(Calendar cal) {
        boolean result = false;
        for (int i = 0; !result && i < this.holidays.length; ++i) {
            result = this.holidays[i].match(cal);
        }
        return result;
    }

    public boolean isHoliday(Time time) {
        boolean result = false;
        for (int i = 0; !result && i < this.holidays.length; ++i) {
            result = this.holidays[i].match(time);
        }
        return result;
    }

    public void setHolidays(Holiday[] holidays) {
        this.holidays = holidays;
    }

    public Holiday[] getHolidays() {
        return this.holidays;
    }

    public void addHoliday(Holiday holiday) {
        if (!this.contains(holiday)) {
            Holiday[] h = new Holiday[this.holidays.length + 1];
            System.arraycopy(this.holidays, 0, h, 0, this.holidays.length);
            h[this.holidays.length] = holiday;
            this.holidays = h;
        }
    }

    public boolean contains(Holiday item) {
        boolean result = false;
        for (int i = 0; !result && i < this.holidays.length; ++i) {
            result = this.holidays[i].equals(item);
        }
        return result;
    }

    public Holiday find(String description) {
        int ind = this.indexOf(description);
        return ind == -1 ? null : this.holidays[ind];
    }

    public int indexOf(String description) {
        int result = -1;
        if (this.holidays != null) {
            for (int i = 0; result == -1 && i < this.holidays.length; ++i) {
                if (!this.holidays[i].getDescription().equalsIgnoreCase(description)) continue;
                result = i;
            }
        }
        return result;
    }

    public int size() {
        return this.holidays == null ? 0 : this.holidays.length;
    }

    public void update(String originalDescription, Holiday holiday) {
        int ind = this.indexOf(originalDescription);
        if (ind != -1) {
            this.holidays[ind] = holiday;
        }
    }

    private static void add(String holidaySpec, ArrayList holidayList) {
        if ((holidaySpec = holidaySpec.trim()).length() > 0) {
            holidayList.add(Holiday.valueOf(holidaySpec));
        }
    }
}

