/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.lang.Module;
import oracle.bpm.lang.ModulePropertiesProvider;

public class ModuleProperties
implements ModulePropertiesProvider,
Serializable,
Cloneable {
    public transient Map<String, String> properties;
    public ArrayList<TypeEntry> types = new ArrayList();
    public static final TypeEntry types_ELEMENT_ = null;
    static final long serialVersionUID = 20000302180000L;
    public static final String SERVER_CONNECTION_SYMBOL = "*";
    static final long serialCheck = -4621636820053918515L;

    @Override
    public String getProperty(String moduleType, String moduleName, String propertyName) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
            this.rebuildMap();
        }
        return this.properties.get(moduleType + "." + moduleName + "." + propertyName);
    }

    public TypeEntry getType(int index) {
        return this.types.get(index);
    }

    public TypeEntry getType(String name) {
        for (TypeEntry entry : this.types) {
            if (!entry.name.equals(name)) continue;
            return entry;
        }
        return null;
    }

    public int getTypeCount() {
        return this.types.size();
    }

    public TypeEntry addType(String name) {
        TypeEntry entry = new TypeEntry(name);
        this.types.add(entry);
        return entry;
    }

    public Object clone() {
        ModuleProperties newProperties = new ModuleProperties();
        for (TypeEntry entry : this.types) {
            newProperties.types.add(entry.clone());
        }
        newProperties.properties = new HashMap<String, String>();
        newProperties.rebuildMap();
        return newProperties;
    }

    public void putProperty(String moduleType, String moduleName, String propertyName, String value) {
        ModuleEntry module;
        TypeEntry type = this.getType(moduleType);
        if (type == null) {
            type = this.addType(moduleType);
        }
        if ((module = type.getModule(moduleName)) == null) {
            module = type.addModule(moduleName);
        }
        module.putProperty(propertyName, value);
    }

    private void rebuildMap() {
        int typeCount = this.getTypeCount();
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        for (int i = 0; i < typeCount; ++i) {
            TypeEntry type = this.getType(i);
            Module.ModuleFactory factory = Module.getFactory(type.getName());
            int moduleCount = type.getModuleCount();
            for (int j = 0; j < moduleCount; ++j) {
                ModuleEntry module = type.getModule(j);
                StringList propertyNames = factory.getPropertyNames();
                for (String propName : propertyNames) {
                    String value = module.getProperty(propName);
                    this.properties.put(type.getName() + "." + module.getName() + "." + propName, value);
                }
            }
        }
    }

    public static class TypeEntry
    implements Serializable,
    Cloneable {
        public ArrayList<ModuleEntry> modules;
        public String name;
        static final long serialCheck = 7164110446207555140L;
        public static final ModuleEntry modules_ELEMENT_ = null;
        static final long serialVersionUID = 20000302180000L;

        public TypeEntry() {
        }

        TypeEntry(String name) {
            this.name = name;
            this.modules = new ArrayList();
        }

        public ModuleEntry getModule(int index) {
            return this.modules.get(index);
        }

        public ModuleEntry getModule(String name) {
            for (ModuleEntry entry : this.modules) {
                if (!entry.name.equals(name)) continue;
                return entry;
            }
            return null;
        }

        public int getModuleCount() {
            return this.modules.size();
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public ModuleEntry addModule(String name) {
            ModuleEntry entry = new ModuleEntry(name);
            this.modules.add(entry);
            return entry;
        }

        public TypeEntry clone() {
            TypeEntry newType = new TypeEntry(this.name);
            for (ModuleEntry entry : this.modules) {
                newType.modules.add(entry.clone());
            }
            return newType;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class ModuleEntry
    implements Serializable {
        public String name;
        public Map<String, String> properties;
        static final long serialCheck = 7004452744179029231L;
        static final long serialVersionUID = 20000302180000L;

        public ModuleEntry() {
        }

        ModuleEntry(String name) {
            this.name = name;
            this.properties = new HashMap<String, String>();
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getProperty(String name) {
            return this.properties.get(name);
        }

        public ModuleEntry clone() {
            ModuleEntry newModule = new ModuleEntry(this.name);
            newModule.properties.putAll(this.properties);
            return newModule;
        }

        public void putProperty(String name, String value) {
            this.properties.put(name, value);
        }

        public String toString() {
            return this.name;
        }
    }
}

