/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.data;

import java.util.Locale;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;

public enum MeasurementType implements I18nProvider
{
    START(LibMsg.MT_START, "MEASUREMENT_START"),
    STOP(LibMsg.MT_STOP, "MEASUREMENT_STOP"),
    START_STOP(LibMsg.MT_START_STOP, "MEASUREMENT_START_STOP"),
    NONE(LibMsg.MT_NONE, "NONE"),
    ANY(LibMsg.ANY, "ANY");

    private transient Msg msg;
    private String value;

    private MeasurementType(Msg msg, String value) {
        this.msg = msg;
        this.value = value;
    }

    @Override
    public String getString() {
        return this.getMsg().getString();
    }

    @Override
    public String getString(Locale locale) {
        return this.getMsg().getString(locale);
    }

    public Msg getMsg() {
        return this.msg;
    }

    public int getIn() {
        return this.ordinal();
    }

    public static MeasurementType migrate(String value) {
        int wt = Integer.parseInt(value);
        MeasurementType[] types = MeasurementType.values();
        return wt >= 0 && wt < types.length ? types[wt] : null;
    }

    public String getValue() {
        return this.value;
    }
}

