/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.data;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import oracle.bpm.lang.CorruptCalendarRuleDataException;
import oracle.bpm.lang.DynamicObject;
import oracle.bpm.lang.WorkWeek;
import oracle.bpm.log.Log;
import oracle.bpm.xml.DeserializationException;
import oracle.bpm.xml.XMLDeserializer;

public class CalendarRuleData {
    public String holidayRule;
    public String timeZone;
    public WorkWeek workWeek;
    private static final String TIMEZONE = "timezone=";
    private static final String HOLIDAYS = "holidays=";

    public static CalendarRuleData valueOf(String text) {
        return text.trim().startsWith("<Calendar") ? CalendarRuleData.legacyLoad(text) : CalendarRuleData.load(text);
    }

    public boolean equals(Object o) {
        boolean result;
        boolean bl = result = this == o;
        if (!result && o instanceof CalendarRuleData) {
            CalendarRuleData that = (CalendarRuleData)o;
            result = (this.holidayRule.equals(that.holidayRule) || this.holidayRule != null && this.holidayRule.equals(that.holidayRule)) && (this.timeZone.equals(that.timeZone) || this.timeZone != null && this.timeZone.equals(that.timeZone)) && (this.workWeek == that.workWeek || this.workWeek != null && this.workWeek.equals(that.workWeek));
        }
        return result;
    }

    public int hashCode() {
        int result = this.holidayRule != null ? this.holidayRule.hashCode() : 0;
        result = 29 * result + (this.timeZone != null ? this.timeZone.hashCode() : 0);
        result = 29 * result + (this.workWeek != null ? this.workWeek.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(TIMEZONE);
        result.append(this.timeZone);
        result.append('\n');
        result.append(HOLIDAYS);
        result.append(this.holidayRule);
        result.append('\n');
        result.append(this.workWeek.toString());
        return result.toString();
    }

    public boolean hasWorkingDays() {
        return this.workWeek != null && this.workWeek.toString() != null && !this.workWeek.toString().equals("");
    }

    private static CalendarRuleData legacyLoad(String text) {
        CalendarRuleData result = new CalendarRuleData();
        try {
            ByteArrayInputStream istr = new ByteArrayInputStream(text.getBytes("ISO8859_1"));
            XMLDeserializer deserializer = new XMLDeserializer();
            DynamicObject data = deserializer.parse(istr);
            result.timeZone = data.getField("timeZone").toString();
            result.holidayRule = data.getField("holidayRule").toString();
            DynamicObject daySchedule = data.getField("workWeek").getField("daySchedules");
            if (daySchedule == DynamicObject.NULL) {
                daySchedule = data.getField("workWeek").getField("daySchedules_d");
            }
            result.workWeek = WorkWeek.legacyValueOf(daySchedule.asAssociativeArray());
        }
        catch (UnsupportedEncodingException e) {
            Log.logWarning(e);
        }
        catch (DeserializationException e) {
            Log.logWarning(e);
        }
        catch (UnsupportedOperationException e) {
            Log.logWarning(e);
        }
        return result;
    }

    private static CalendarRuleData load(String text) {
        CalendarRuleData result = new CalendarRuleData();
        try {
            int beg = text.indexOf(TIMEZONE) + TIMEZONE.length();
            int end = text.indexOf(10, beg);
            result.timeZone = text.substring(beg, end);
            beg = text.indexOf(HOLIDAYS, end) + HOLIDAYS.length();
            end = text.indexOf(10, beg);
            result.holidayRule = text.substring(beg, end);
            result.workWeek = WorkWeek.valueOf(text.substring(end + 1));
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new CorruptCalendarRuleDataException(text, (Throwable)e);
        }
        return result;
    }
}

