/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.data;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.lang.DynamicObject;
import oracle.bpm.xml.Serializer;
import oracle.bpm.xml.XMLDeserializer;
import oracle.bpm.xml.XMLSerializer;
import oracle.bpm.xml.XMLSerializerWriter;
import oracle.bpm.xml.XmlWriter;

public class BusinessVariableData {
    public List<Range> ranges = new ArrayList<Range>();

    public static BusinessVariableData create(String properties) {
        return BusinessVariableData.doImport(new StringReader(properties));
    }

    public boolean isEmpty() {
        return this.ranges == null || this.ranges.size() == 0;
    }

    public String getProperties() {
        if (this.isEmpty()) {
            return null;
        }
        StringWriter sw = new StringWriter();
        this.doExport(sw);
        return sw.toString();
    }

    public Range[] getRange() {
        return this.ranges.toArray(new Range[this.ranges.size()]);
    }

    public int getSize() {
        return this.ranges.size();
    }

    public Range addRange(String name, BigDecimal start, BigDecimal finish) {
        Range range = Range.create(name, start, finish);
        this.addRange(range);
        return range;
    }

    public void addRange(Range range) {
        this.ranges.add(range);
    }

    public void removeRange(int index) {
        if (index >= 0 && index < this.ranges.size()) {
            this.ranges.remove(index);
        }
    }

    public String toString() {
        String s = "";
        for (Range range : this.ranges) {
            s = s.concat(range.toString() + "\n");
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BusinessVariableData doImport(Reader reader) {
        XMLDeserializer deserializer = new XMLDeserializer();
        DynamicObject properties = deserializer.parse(reader);
        Thread currentThread = Thread.currentThread();
        ClassLoader prev = currentThread.getContextClassLoader();
        try {
            BusinessVariableData propsObj;
            currentThread.setContextClassLoader(BusinessVariableData.class.getClassLoader());
            BusinessVariableData businessVariableData = propsObj = properties.convertTo(BusinessVariableData.class);
            currentThread.setContextClassLoader(prev);
            return businessVariableData;
        }
        catch (Throwable throwable) {
            try {
                currentThread.setContextClassLoader(prev);
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    private void doExport(Writer writer) {
        XMLSerializerWriter pw = new XMLSerializerWriter(writer, (Serializer)new XMLSerializer());
        pw.write("BusinessVariableData", DynamicObject.valueOf(this));
    }

    public static class Range
    implements Serializable {
        private BigDecimal finish;
        private String name;
        private BigDecimal start;
        static final long serialVersionUID = 8261659472259263985L;
        static final long serialCheck = 1539438470147746407L;

        public Range() {
        }

        public Range(Range range) {
            this.name = range.getName();
            this.start = range.getStart();
            this.finish = range.getFinish();
        }

        private Range(String name, BigDecimal start, BigDecimal finish) {
            this.name = name;
            this.start = start;
            this.finish = finish;
        }

        public static Range create(String name, BigDecimal start, BigDecimal finish) {
            return new Range(name, start, finish);
        }

        public void setFinish(BigDecimal finish) {
            this.finish = finish;
        }

        public BigDecimal getFinish() {
            return this.finish;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setStart(BigDecimal start) {
            this.start = start;
        }

        public BigDecimal getStart() {
            return this.start;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Range)) {
                return false;
            }
            Range range = (Range)o;
            if (this.finish != null ? !this.finish.equals(range.finish) : range.finish != null) {
                return false;
            }
            if (this.name != null ? !this.name.equals(range.name) : range.name != null) {
                return false;
            }
            return !(this.start != null ? !this.start.equals(range.start) : range.start != null);
        }

        public int hashCode() {
            int result = this.finish != null ? this.finish.hashCode() : 0;
            result = 29 * result + (this.start != null ? this.start.hashCode() : 0);
            result = 29 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }

        public void serializeToXml(String id, XmlWriter writer) throws IOException {
            writer.setIgnoreEmpty(false);
            writer.startElement("Range");
            writer.printAttribute("id", id);
            writer.printAttribute("name", this.name);
            writer.printAttribute("start", this.start);
            writer.printAttribute("finish", this.finish);
            writer.setIgnoreEmpty(true);
            writer.endElement();
        }

        public String toString() {
            return this.name + " => [" + this.start + '-' + this.finish + ']';
        }
    }
}

