/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.connector.impl;

import java.util.Properties;
import oracle.bpm.configuration.exception.InvalidConfigurationException;
import oracle.bpm.configuration.spi.ConfigurationEditorBean;
import oracle.bpm.configuration.util.ValidationUtilities;
import oracle.bpm.lib.msg.LibMsg;

public class UddiRegistryConfiguration
implements ConfigurationEditorBean {
    private String inquiryPath;
    private String password;
    private String publishPath;
    private String securityPath;
    private String serverConnector;
    private String user;

    public UddiRegistryConfiguration(Properties properties) {
        this.serverConnector = properties.getProperty("server.connector");
        this.inquiryPath = properties.getProperty("uddi.inquiry.path");
        this.publishPath = properties.getProperty("uddi.publish.path");
        this.securityPath = properties.getProperty("uddi.security.path");
        this.user = properties.getProperty("user");
        this.password = ValidationUtilities.unscrambleText(properties.getProperty("password"));
    }

    public String getInquiryPath() {
        return this.inquiryPath == null ? "" : this.inquiryPath;
    }

    public void setInquiryPath(String inquiryPath) {
        this.inquiryPath = inquiryPath;
    }

    public String getPublishPath() {
        return this.publishPath == null ? "" : this.publishPath;
    }

    public void setPublishPath(String publishPath) {
        this.publishPath = publishPath;
    }

    public String getSecurityPath() {
        return this.securityPath == null ? "" : this.securityPath;
    }

    public void setSecurityPath(String securityPath) {
        this.securityPath = securityPath;
    }

    public void setServerConnector(String name) {
        this.serverConnector = name;
    }

    public String getPassword() {
        return this.password != null ? this.password : "";
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUser() {
        return this.user != null ? this.user : "";
    }

    public String getServerConnector() {
        return this.serverConnector == null ? "" : this.serverConnector;
    }

    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public Properties asProperties() {
        Properties properties = new Properties();
        properties.put("server.connector", this.getServerConnector());
        properties.put("uddi.inquiry.path", this.getInquiryPath());
        properties.put("uddi.publish.path", this.getPublishPath());
        properties.put("uddi.security.path", this.getSecurityPath());
        properties.put("user", this.getUser());
        properties.put("password", ValidationUtilities.scrambleText(this.getPassword()));
        return properties;
    }

    @Override
    public void check() throws Exception {
    }

    @Override
    public void validate() throws InvalidConfigurationException {
        String inquiryPath = this.getInquiryPath().trim();
        if ("".equals(inquiryPath)) {
            throw InvalidConfigurationException.validationFailed(LibMsg.UDDI_INQUIRY_PATH);
        }
        String publishPath = this.getPublishPath().trim();
        if ("".equals(publishPath)) {
            throw InvalidConfigurationException.validationFailed(LibMsg.UDDI_PUBLISH_PATH);
        }
        String connectorName = this.getServerConnector().trim();
        if ("".equals(connectorName)) {
            throw InvalidConfigurationException.validationFailed(LibMsg.SERVER_CONNECTOR);
        }
    }
}

