/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.connector.impl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import oracle.bpm.configuration.ConfigType;
import oracle.bpm.configuration.KnownConfigTypes;
import oracle.bpm.connector.ConnectorException;
import oracle.bpm.connector.ConnectorService;
import oracle.bpm.connector.impl.BaseRemoteConnector;
import oracle.bpm.connector.impl.RemoteJDBCDatabaseManager;
import oracle.bpm.connector.impl.RemoteJdbcConfigType;
import oracle.bpm.connector.spi.ConnectorFactory;
import oracle.bpm.connector.spi.JDBCConnectorInterface;
import oracle.bpm.jdbc.DatabaseManager;
import oracle.bpm.jdbc.FaultTolerantConnection;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.log.Log;
import oracle.bpm.resources.Msg;
import oracle.bpm.util.ExceptionFormatter;

public class RemoteJDBCConnector
extends BaseRemoteConnector
implements JDBCConnectorInterface {
    RemoteJDBCConnector(ConnectorFactory factory, ConnectorService manager, String name, Properties properties) {
        super(factory, manager, name, properties);
    }

    @Override
    public final Connection getConnection() throws SQLException {
        return this.getConnection(false, null);
    }

    @Override
    public Connection getConnection(Properties authenticationProperties) throws SQLException {
        return this.getConnection(false, authenticationProperties);
    }

    public Connection getConnection(boolean closeContext, Properties authProperties) throws SQLException {
        Connection conn;
        Object result;
        try {
            result = this.getReferencedObject(closeContext, authProperties);
        }
        catch (ConnectorException e) {
            Log.logSevere(e);
            throw (SQLException)new SQLException(e.getMessage()).initCause(e);
        }
        catch (NamingException e) {
            Log.logSevere(e);
            throw (SQLException)new SQLException(e.getMessage()).initCause(e);
        }
        if (result instanceof DataSource) {
            conn = ((DataSource)result).getConnection();
        } else if (result instanceof XADataSource) {
            conn = ((XADataSource)result).getXAConnection().getConnection();
        } else {
            throw new SQLException("the registered object is not a DataSource or XADataSource");
        }
        try {
            if (conn.getTransactionIsolation() < 2) {
                conn.setTransactionIsolation(2);
            }
        }
        catch (Exception e) {
            Msg msg = LibMsg.CANNOT_CHANGE_ISOLATION_LEVEL(conn.getTransactionIsolation(), ExceptionFormatter.fullTechLevel(e));
            msg.logSevere();
        }
        DatabaseManager.unlockConnection(conn);
        return FaultTolerantConnection.wrap(this, conn);
    }

    @Override
    public DatabaseManager getDatabaseManager() {
        return new RemoteJDBCDatabaseManager(this);
    }

    @Override
    public Object getResource() throws Exception {
        return this.getResource(null);
    }

    @Override
    public Object getResource(int resourceType) throws Exception {
        return this.getResource(resourceType, null);
    }

    @Override
    public Object getResource(Properties authenticationProperties) throws Exception {
        return this.getResource(0, authenticationProperties);
    }

    @Override
    public Object getResource(int resourceType, Properties authProperties) throws Exception {
        switch (resourceType) {
            case 1: {
                return this.getDatabaseManager();
            }
            case 2: {
                return this.getConnection(true, authProperties);
            }
        }
        return this.getConnection(authProperties);
    }

    @Override
    public ConfigType getConfigType() {
        return RemoteJdbcConfigType.get();
    }

    @Override
    public boolean handleServiceType(String type) {
        return false;
    }

    @Override
    public void restart() {
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean supports(long feature) {
        String subType = this.getProperty("jdbc.remote.type");
        return KnownConfigTypes.SQL.getSubType(subType).supports(feature);
    }
}

