/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.connector.impl;

import java.util.List;
import java.util.Properties;
import oracle.bpm.configuration.exception.InvalidConfigurationException;
import oracle.bpm.configuration.impl.BaseConfigurationEditorBean;
import oracle.bpm.configuration.spi.ConfigurationEditorBean;
import oracle.bpm.configuration.util.ValidationUtilities;
import oracle.bpm.connector.impl.JNDIFactory;
import oracle.bpm.connector.impl.PoolConfigurationBean;
import oracle.bpm.lib.msg.LibMsg;

public class JNDIConfiguration
extends BaseConfigurationEditorBean
implements ConfigurationEditorBean,
PoolConfigurationBean {
    private String binaryProperty;
    private int connectionIdleTime;
    private String contextFactory;
    private String credentials;
    private int entrySize;
    private String ldapDirectoryProperties;
    private int minNoDisposable;
    private String principal;
    private String referral;
    private int size;
    private String url;

    public JNDIConfiguration(Properties properties) {
        super(properties);
        this.principal = properties.getProperty("java.naming.security.principal");
        this.credentials = ValidationUtilities.unscrambleText(properties.getProperty("java.naming.security.credentials"));
        this.contextFactory = properties.getProperty("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        this.url = properties.getProperty("java.naming.provider.url");
        this.ldapDirectoryProperties = properties.getProperty("ldap.directory.propery");
        this.referral = properties.getProperty("java.naming.referral", "follow");
        this.size = Integer.parseInt(properties.getProperty("jdbc.pool.max", "10"));
        this.entrySize = Integer.parseInt(properties.getProperty("jdbc.pool.entry.max", "10"));
        this.minNoDisposable = Integer.parseInt(properties.getProperty("jdbc.pool.min", "0"));
        this.connectionIdleTime = Integer.parseInt(properties.getProperty("jdbc.pool.idle_timeout", "5"));
        this.binaryProperty = properties.getProperty("java.naming.ldap.attributes.binary", "");
    }

    public void setContextFactory(String contextFactory) {
        this.contextFactory = contextFactory;
    }

    public String getContextFactory() {
        if (this.contextFactory != null) {
            return this.contextFactory.trim();
        }
        return "";
    }

    public void setCredentials(String credentials) {
        this.credentials = credentials;
    }

    public String getCredentials() {
        if (this.credentials != null) {
            return this.credentials;
        }
        return "";
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public String getPrincipal() {
        if (this.principal != null) {
            return this.principal;
        }
        return "";
    }

    public void setReferral(String referral) {
        this.referral = referral;
    }

    public String getReferral() {
        if (this.referral != null) {
            return this.referral;
        }
        return "";
    }

    public List<String> getReferralOptions() {
        return JNDIFactory.getReferralOptions();
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        if (this.url != null) {
            return this.url;
        }
        return "";
    }

    public String getBinaryProperty() {
        return this.binaryProperty;
    }

    public void setBinaryProperty(String binaryProperty) {
        this.binaryProperty = binaryProperty;
    }

    @Override
    public Properties asProperties() {
        Properties properties = super.asProperties();
        properties.put("java.naming.security.principal", this.getPrincipal());
        properties.put("java.naming.security.credentials", this.getEncryptedCredentials());
        properties.put("java.naming.factory.initial", this.getContextFactory());
        properties.put("java.naming.provider.url", this.getUrl());
        properties.put("java.naming.referral", this.getReferral());
        properties.put("jdbc.pool.max", String.valueOf(this.getSize()));
        properties.put("jdbc.pool.entry.max", String.valueOf(this.getEntrySize()));
        properties.put("jdbc.pool.min", String.valueOf(this.getMinConnections()));
        properties.put("jdbc.pool.idle_timeout", String.valueOf(this.getConnectionIdleTime()));
        properties.put("java.naming.ldap.attributes.binary", this.getBinaryProperty());
        if (this.getLdapDirectoryProperty().length() > 0) {
            properties.put("ldap.directory.propery", this.getLdapDirectoryProperty());
        }
        return properties;
    }

    @Override
    public void check() throws Exception {
    }

    @Override
    public void validate() throws InvalidConfigurationException {
        if (this.getContextFactory().equals("")) {
            throw InvalidConfigurationException.validationFailed(LibMsg.JNDI_CTX_FACTORY.getString());
        }
        if (this.getUrl().trim().equals("")) {
            throw InvalidConfigurationException.validationFailed(LibMsg.URL.getString());
        }
        if (this.getReferral().equals("")) {
            throw InvalidConfigurationException.validationFailed(LibMsg.JNDI_REFERRAL.getString());
        }
        this.validatePoolValues();
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public int getMinConnections() {
        return this.minNoDisposable;
    }

    @Override
    public void setMinConnections(int min) {
        this.minNoDisposable = min;
    }

    @Override
    public int getConnectionIdleTime() {
        return this.connectionIdleTime;
    }

    @Override
    public void setConnectionIdleTime(int time) {
        this.connectionIdleTime = time;
    }

    @Override
    public int getEntrySize() {
        return this.entrySize;
    }

    @Override
    public void setEntrySize(int size) {
        this.entrySize = size;
    }

    @Override
    public Properties getDefaultConnectionProperties() {
        Properties properties = new Properties();
        properties.put("com.sun.jndi.ldap.connect.pool", "true");
        return properties;
    }

    public void setLdapDirectoryProperty(String ldapDirectoryProperties) {
        this.ldapDirectoryProperties = ldapDirectoryProperties;
    }

    public String getLdapDirectoryProperty() {
        if (this.ldapDirectoryProperties != null) {
            return this.ldapDirectoryProperties;
        }
        return "";
    }

    protected void validatePoolValues() throws InvalidConfigurationException {
        if (this.getSize() <= 0) {
            throw InvalidConfigurationException.validationFailed(LibMsg.POOL_MAX.getString());
        }
        if (this.getMinConnections() < 0) {
            throw InvalidConfigurationException.validationFailed(LibMsg.POOL_MIN.getString());
        }
        if (this.getConnectionIdleTime() < 0) {
            throw InvalidConfigurationException.validationFailed(LibMsg.POOL_IDLE_TIME.getString());
        }
    }

    private String getEncryptedCredentials() {
        if (this.getCredentials().equals("")) {
            return "";
        }
        return ValidationUtilities.scrambleText(this.getCredentials());
    }
}

