/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.connector.impl;

import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;
import oracle.bpm.configuration.ConfigType;
import oracle.bpm.connector.ConnectorService;
import oracle.bpm.connector.impl.BaseJ2EEConnector;
import oracle.bpm.connector.impl.GenericJ2eeConfigType;
import oracle.bpm.connector.impl.pool.PoolManager;
import oracle.bpm.connector.impl.pool.PooledFactory;
import oracle.bpm.connector.spi.ConnectorFactory;
import oracle.bpm.connector.spi.ConnectorInterface;
import oracle.bpm.jndi.FaultTolerantContext;
import oracle.bpm.log.Log;
import oracle.bpm.pool.CacheFactoryException;

public class GenericJ2EEConnector
extends BaseJ2EEConnector
implements PooledFactory<Context> {
    private PoolManager<Context> poolManager;

    GenericJ2EEConnector(ConnectorFactory factory, ConnectorService manager, String name, Properties properties) {
        super(factory, manager, name, properties);
        Properties cacheProperties = new Properties();
        cacheProperties.setProperty("fuego.cache.maxentrysize", String.valueOf(10000));
        cacheProperties.setProperty("fuego.cache.minnodisposable", String.valueOf(2));
        this.poolManager = PoolManager.create(this, this.getName(), cacheProperties, this.getProperties());
    }

    @Override
    public ConfigType getConfigType() {
        return GenericJ2eeConfigType.get();
    }

    @Override
    public void start() throws Exception {
        super.start();
        this.poolManager.start();
    }

    @Override
    public void stop() {
        this.poolManager.stop();
        super.stop();
    }

    @Override
    public Context createContext(Properties authenticationProperties) throws NamingException {
        Context context;
        try {
            context = this.poolManager.getPooledObject(authenticationProperties);
        }
        catch (Exception e) {
            NamingException namingException = new NamingException(e.getLocalizedMessage());
            namingException.initCause(e);
            throw namingException;
        }
        return context;
    }

    @Override
    public Context createStandaloneContext(Properties authenticationProperties) throws NamingException {
        return this.createInitialContext(authenticationProperties);
    }

    @Override
    public UserTransaction createUserTransaction() throws NamingException {
        String lookupName = this.getProperty("javax.user.UserTransaction");
        if (lookupName != null && !lookupName.equals("")) {
            return (UserTransaction)this.getContext().lookup(lookupName);
        }
        return null;
    }

    @Override
    public void releaseContext(Context context) {
        this.poolManager.unlock(context);
    }

    @Override
    public Context create(Properties authenticationProperties) throws CacheFactoryException {
        try {
            return this.createInitialContext(authenticationProperties);
        }
        catch (NamingException e) {
            throw new CacheFactoryException(e);
        }
    }

    @Override
    public boolean dispose(Context value) {
        try {
            value.close();
        }
        catch (NamingException e) {
            Log.logWarning(e);
            return false;
        }
        return true;
    }

    @Override
    public String getUserPropertyKey() {
        return "java.naming.security.principal";
    }

    @Override
    public String getPasswordPropertyKey() {
        return "java.naming.security.credentials";
    }

    protected Context createInitialContext(Properties authenticationProperties) throws NamingException {
        Properties environment = new Properties();
        environment.putAll((Map<?, ?>)this.getProperties());
        this.putProperty(environment, "java.naming.security.credentials", this.getEncryptedProperty("java.naming.security.credentials"));
        if (authenticationProperties != null) {
            this.putProperty(environment, "java.naming.security.principal", authenticationProperties.getProperty("java.naming.security.principal"));
            this.putProperty(environment, "java.naming.security.credentials", authenticationProperties.getProperty("java.naming.security.credentials"));
        }
        return new FaultTolerantContext(environment, (ConnectorInterface)this);
    }
}

