/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.connector.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class DriverManagerHack {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Connection getConnection(ClassLoader cl, String url, Properties properties) throws SQLException {
        if (cl == null) {
            return DriverManager.getConnection(url, properties);
        }
        try {
            Method m = DriverManagerHack.getMethod(cl);
            boolean oldAccesibleValue = m.isAccessible();
            try {
                m.setAccessible(true);
                Connection connection = (Connection)m.invoke(null, url, properties, cl);
                return connection;
            }
            catch (IllegalAccessException e) {
                throw (SQLException)new SQLException(e.getMessage()).initCause(e);
            }
            catch (IllegalArgumentException e) {
                throw (SQLException)new SQLException(e.getMessage()).initCause(e);
            }
            catch (InvocationTargetException e) {
                if (!(e.getTargetException() instanceof SQLException)) throw (SQLException)new SQLException(e.getMessage()).initCause(e);
                throw (SQLException)e.getTargetException();
            }
            finally {
                m.setAccessible(oldAccesibleValue);
            }
        }
        catch (NoSuchMethodException e) {
            return DriverManager.getConnection(url, properties);
        }
    }

    public static Method getMethod(ClassLoader cl) throws NoSuchMethodException {
        try {
            Class<?> clazz = Class.forName(DriverManager.class.getName(), false, cl);
            return clazz.getDeclaredMethod("getConnection", String.class, Properties.class, ClassLoader.class);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot find DriverManager class", e);
        }
    }
}

