/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.connector.impl;

import java.util.Properties;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.NamingException;
import oracle.bpm.connector.ConnectorException;
import oracle.bpm.connector.ConnectorService;
import oracle.bpm.connector.ConnectorTransactionCoordinator;
import oracle.bpm.connector.J2EEHelper;
import oracle.bpm.connector.impl.BaseConnector;
import oracle.bpm.connector.spi.ConnectorFactory;
import oracle.bpm.log.Log;

public abstract class BaseRemoteConnector
extends BaseConnector {
    protected final String contextProvider;
    protected final String lookupName = this.getProperty("lookupName");

    public BaseRemoteConnector(ConnectorFactory factory, ConnectorService manager, String name, Properties properties) {
        super(factory, manager, name, properties);
        this.contextProvider = this.getProperty("j2ee.provider");
    }

    public final String getContextProvider() {
        return this.contextProvider;
    }

    @Override
    public final String getCoordinatorKey() {
        return this.getContextProvider();
    }

    public String getLookupName() {
        return this.lookupName;
    }

    @Override
    public final ConnectorTransactionCoordinator createCoordinator() {
        return null;
    }

    @Override
    public void start() throws Exception {
        this.initRemote();
    }

    protected Context getContext(boolean readOnly, Properties authProperties) throws ConnectorException {
        if (!readOnly) {
            if (authProperties != null) {
                return J2EEHelper.getContext(this.contextProvider, authProperties.getProperty("java.naming.security.principal"), authProperties.getProperty("java.naming.security.credentials"));
            }
            return J2EEHelper.getContext(this.contextProvider);
        }
        if (authProperties != null) {
            return J2EEHelper.getReadOnlyContext(this.contextProvider, authProperties.getProperty("java.naming.security.principal"), authProperties.getProperty("java.naming.security.credentials"));
        }
        return J2EEHelper.getReadOnlyContext(this.contextProvider);
    }

    protected Object getReferencedObject(boolean closeContext, Properties authProperties) throws NamingException, ConnectorException {
        return this.getReferencedObject(closeContext, this.lookupName, authProperties);
    }

    protected Object getReferencedObject(boolean closeContext, String lookupName, Properties authProperties) throws NamingException, ConnectorException {
        Context context = this.getContext(closeContext, authProperties);
        Object result = context.lookup(lookupName);
        if (closeContext) {
            try {
                context.close();
            }
            catch (NamingException e) {
                Log.logInfo(e);
            }
        }
        return result;
    }

    protected void initRemote() throws NamingException {
        if (this.lookupName == null) {
            throw new ConfigurationException("no lookup name for Provider [" + this.getName() + "]");
        }
        if (this.contextProvider == null) {
            throw new ConfigurationException("no J2EE provider for Provider [" + this.getName() + "]");
        }
    }
}

