/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.connector;

import java.util.Properties;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import oracle.bpm.components.Mail;
import oracle.bpm.components.OutgoingServerDebug;
import oracle.bpm.configuration.KnownConfigTypes;
import oracle.bpm.connector.ConnectorException;
import oracle.bpm.connector.ConnectorTransaction;
import oracle.bpm.connector.spi.ConnectorInterface;

public final class MailHelper {
    private MailHelper() {
    }

    public static Session getSession(String connectorName) throws ConnectorException {
        return (Session)ConnectorTransaction.current().getResource(connectorName, KnownConfigTypes.INCOMING_MAIL, 0);
    }

    public static Session getSession(String connectorName, String user, String password) throws ConnectorException {
        Properties authProperties = MailHelper.buildAuthProperties(user, password);
        return (Session)ConnectorTransaction.current().getResource(connectorName, KnownConfigTypes.INCOMING_MAIL, 0, authProperties);
    }

    public static Store getStore(String connectorName, String folder, String user, String password) throws ConnectorException, NoSuchProviderException {
        int port;
        ConnectorInterface connectorInterface = ConnectorTransaction.getConnectorInterface(connectorName, KnownConfigTypes.INCOMING_MAIL);
        Properties connectionProperties = connectorInterface.getProperties();
        String protocol = connectorInterface.getConfigType().getName();
        String host = connectionProperties.getProperty("mail.server.host");
        String portString = connectionProperties.getProperty("mail.server.port");
        int n = port = portString == null || "".equals(portString) ? -1 : Integer.parseInt(portString);
        if (user == null && password == null) {
            user = connectionProperties.getProperty("user");
            password = connectionProperties.getProperty("password");
        }
        URLName url = new URLName(protocol, host, port, folder, user, password);
        Session session = MailHelper.getSession(connectorName, user, password);
        session.setDebug(false);
        return session.getStore(url);
    }

    public static Mail.OutgoingServer getOutgoingServer(String connectorName) throws ConnectorException {
        return MailHelper.getOutgoingServer(connectorName, null, null);
    }

    public static Mail.OutgoingServer getOutgoingServer(String connectorName, String user, String password) throws ConnectorException {
        ConnectorInterface connectorInterface = ConnectorTransaction.getConnectorInterface(connectorName, KnownConfigTypes.OUTGOING_MAIL);
        Properties connectorProperties = connectorInterface.getProperties();
        if (user != null && password != null) {
            MailHelper.overrideAuthProperties(connectorProperties, user, password);
        }
        String mailServerName = MailHelper.buildMailServerName(connectorProperties);
        OutgoingServerDebug.setMailServerName(mailServerName);
        return new OutgoingServerDebug();
    }

    private static void overrideAuthProperties(Properties connectorProperties, String user, String password) {
        connectorProperties.put("user", user);
        connectorProperties.put("password", password);
    }

    private static Properties buildAuthProperties(String user, String password) {
        Properties authProperties = new Properties();
        authProperties.put("user", user);
        authProperties.put("password", password);
        return authProperties;
    }

    private static String buildMailServerName(Properties connectionProperties) {
        String user = connectionProperties.getProperty("user");
        String host = connectionProperties.getProperty("mail.server.host");
        String password = connectionProperties.getProperty("password");
        return new StringBuilder(50).append(user).append("@").append(host).append(":").append(password).toString();
    }
}

