/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.connector;

import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import oracle.bpm.configuration.KnownConfigTypes;
import oracle.bpm.connector.ConnectorException;
import oracle.bpm.connector.ConnectorServiceInterface;
import oracle.bpm.connector.ConnectorTransaction;
import oracle.bpm.connector.JmsDestinationType;
import oracle.bpm.connector.spi.ConnectorInterface;
import oracle.bpm.connector.spi.JMSConnectorInterface;

public final class JMSHelper {
    private JMSHelper() {
    }

    public static Destination getDestination(String name) throws ConnectorException {
        ConnectorInterface connector = ConnectorTransaction.getConnectorInterface(name, KnownConfigTypes.JMS);
        try {
            return (Destination)connector.getResource(1);
        }
        catch (Exception e) {
            throw ConnectorException.exceptionOnGetResource(connector, e);
        }
    }

    public static Destination getDestination(String name, String principal, String credentials) throws ConnectorException {
        Properties authProperties = JMSHelper.buildAuthProperties(principal, credentials);
        ConnectorServiceInterface connectorService = ConnectorTransaction.getConnectorService();
        return (Destination)connectorService.getResource(name, KnownConfigTypes.JMS, 1, authProperties);
    }

    public static JmsDestinationType getJMSDestinationType(String name) throws ConnectorException {
        ConnectorServiceInterface connectorService = ConnectorTransaction.getConnectorService();
        JMSConnectorInterface connector = (JMSConnectorInterface)connectorService.getConnectorInterface(name, KnownConfigTypes.JMS);
        return connector.getDestinationType();
    }

    public static Session getSession(String name) throws ConnectorException {
        return (Session)ConnectorTransaction.current().getResource(name, KnownConfigTypes.JMS, 7);
    }

    public static Session getSession(String name, String principal, String credentials) throws ConnectorException {
        Properties authProperties = JMSHelper.buildAuthProperties(principal, credentials);
        return (Session)ConnectorTransaction.current().getResource(name, KnownConfigTypes.JMS, 7, authProperties);
    }

    public static ConnectionFactory getStandaloneConnectionFactory(String name) throws ConnectorException {
        ConnectorServiceInterface connectorService = ConnectorTransaction.getConnectorService();
        JMSConnectorInterface connector = (JMSConnectorInterface)connectorService.getConnectorInterface(name, KnownConfigTypes.JMS);
        return connector.getStandaloneConnectionFactory();
    }

    public static ConnectionFactory getStandaloneConnectionFactory(String name, String principal, String credentials) throws ConnectorException {
        Properties authProperties = JMSHelper.buildAuthProperties(principal, credentials);
        ConnectorServiceInterface connectorService = ConnectorTransaction.getConnectorService();
        JMSConnectorInterface connector = (JMSConnectorInterface)connectorService.getConnectorInterface(name, KnownConfigTypes.JMS);
        return connector.getStandaloneConnectionFactory(authProperties);
    }

    public static Destination getStandaloneDestination(String name) throws ConnectorException {
        ConnectorServiceInterface connectorService = ConnectorTransaction.getConnectorService();
        JMSConnectorInterface connector = (JMSConnectorInterface)connectorService.getConnectorInterface(name, KnownConfigTypes.JMS);
        return connector.getStandaloneDestination();
    }

    public static Destination getStandaloneDestination(String name, String principal, String credentials) throws ConnectorException {
        Properties authProperties = JMSHelper.buildAuthProperties(principal, credentials);
        ConnectorServiceInterface connectorService = ConnectorTransaction.getConnectorService();
        JMSConnectorInterface connector = (JMSConnectorInterface)connectorService.getConnectorInterface(name, KnownConfigTypes.JMS);
        return connector.getStandaloneDestination(authProperties);
    }

    public static Connection getStandaloneConnection(String name) throws ConnectorException {
        ConnectorServiceInterface connectorService = ConnectorTransaction.getConnectorService();
        JMSConnectorInterface connector = (JMSConnectorInterface)connectorService.getConnectorInterface(name, KnownConfigTypes.JMS);
        try {
            return (Connection)connector.getResource(8);
        }
        catch (Exception e) {
            throw ConnectorException.exceptionOnGetResource(connector, e);
        }
    }

    public static Connection getStandaloneConnection(String name, String principal, String credentials) throws ConnectorException {
        Properties authProperties = JMSHelper.buildAuthProperties(principal, credentials);
        ConnectorServiceInterface connectorService = ConnectorTransaction.getConnectorService();
        JMSConnectorInterface connector = (JMSConnectorInterface)connectorService.getConnectorInterface(name, KnownConfigTypes.JMS);
        try {
            return (Connection)connector.getResource(8, authProperties);
        }
        catch (Exception e) {
            throw ConnectorException.exceptionOnGetResource(connector, e);
        }
    }

    public static MessageConsumer createConsumer(String name) throws ConnectorException {
        ConnectorTransaction connectorTransaction = ConnectorTransaction.current();
        return (MessageConsumer)connectorTransaction.getResource(name, KnownConfigTypes.JMS, 5);
    }

    public static MessageConsumer createConsumer(String name, String principal, String credentials) throws ConnectorException {
        Properties authProperties = JMSHelper.buildAuthProperties(principal, credentials);
        ConnectorTransaction connectorTransaction = ConnectorTransaction.current();
        return (MessageConsumer)connectorTransaction.getResource(name, KnownConfigTypes.JMS, 5, authProperties);
    }

    public static MessageProducer createProducer(String name) throws ConnectorException {
        ConnectorTransaction connectorTransaction = ConnectorTransaction.current();
        return (MessageProducer)connectorTransaction.getResource(name, KnownConfigTypes.JMS, 6);
    }

    public static MessageProducer createProducer(String name, String principal, String credentials) throws ConnectorException {
        Properties authProperties = JMSHelper.buildAuthProperties(principal, credentials);
        ConnectorTransaction connectorTransaction = ConnectorTransaction.current();
        return (MessageProducer)connectorTransaction.getResource(name, KnownConfigTypes.JMS, 6, authProperties);
    }

    private static Properties buildAuthProperties(String principal, String credentials) {
        Properties authProperties = new Properties();
        authProperties.put("java.naming.security.principal", principal);
        authProperties.put("java.naming.security.credentials", credentials);
        return authProperties;
    }
}

