/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.connector;

import java.util.Properties;
import javax.naming.Context;
import javax.naming.directory.DirContext;
import oracle.bpm.configuration.KnownConfigTypes;
import oracle.bpm.connector.ConnectorException;
import oracle.bpm.connector.ConnectorTransaction;
import oracle.bpm.connector.spi.ConnectorInterface;

public final class J2EEHelper {
    private J2EEHelper() {
    }

    public static Context getContext(String name) throws ConnectorException {
        Object resource = ConnectorTransaction.current().getResource(name, KnownConfigTypes.J2EE, 1);
        return (Context)resource;
    }

    public static Context getContext(String name, String principal, String credentials) throws ConnectorException {
        Properties authProperties = J2EEHelper.buildAuthProperties(principal, credentials);
        Object resource = ConnectorTransaction.current().getResource(name, KnownConfigTypes.J2EE, 1, authProperties);
        return (Context)resource;
    }

    public static DirContext getDirContext(String name) throws ConnectorException {
        Object resource = ConnectorTransaction.current().getResource(name, KnownConfigTypes.J2EE, 0);
        return (DirContext)resource;
    }

    public static DirContext getDirContext(String name, String principal, String credentials) throws ConnectorException {
        Properties authProperties = J2EEHelper.buildAuthProperties(principal, credentials);
        Object resource = ConnectorTransaction.current().getResource(name, KnownConfigTypes.J2EE, 0, authProperties);
        return (DirContext)resource;
    }

    public static Context getReadOnlyContext(String name) throws ConnectorException {
        ConnectorInterface connector = ConnectorTransaction.getConnectorInterface(name, KnownConfigTypes.J2EE);
        try {
            return (Context)connector.getResource(3);
        }
        catch (Exception e) {
            throw ConnectorException.exceptionOnGetResource(connector, e);
        }
    }

    public static Context getReadOnlyContext(String name, String principal, String credentials) throws ConnectorException {
        ConnectorInterface connector = ConnectorTransaction.getConnectorInterface(name, KnownConfigTypes.J2EE);
        Properties authProperties = J2EEHelper.buildAuthProperties(principal, credentials);
        try {
            return (Context)connector.getResource(3, authProperties);
        }
        catch (Exception e) {
            throw ConnectorException.exceptionOnGetResource(connector, e);
        }
    }

    private static Properties buildAuthProperties(String principal, String credentials) {
        Properties authProperties = new Properties();
        authProperties.put("java.naming.security.principal", principal);
        authProperties.put("java.naming.security.credentials", credentials);
        return authProperties;
    }
}

