/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.connector;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import oracle.bpm.component.Component;
import oracle.bpm.configuration.Configuration;
import oracle.bpm.configuration.ConfigurationManager;
import oracle.bpm.configuration.KnownConfigTypes;
import oracle.bpm.connector.ClassLoaderServiceInterface;
import oracle.bpm.connector.ConnectorException;
import oracle.bpm.connector.ConnectorService;
import oracle.bpm.lang.Id;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.log.Log;
import oracle.bpm.util.FileUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ClassLoaderService
implements ClassLoaderServiceInterface {
    private boolean isClassLoaderRestarting = false;
    private List<File> jars;
    private Map<String, List<File>> jarsByConfiguration;
    private final Object lock = new Object();
    private ConnectorService service;
    private ClassLoader serviceClassLoader;
    private int status = 2;
    @NonNls
    private static final String JARS_CACHE_DIR_NAME = "jarsCache";

    public ClassLoaderService(ConnectorService service) {
        this.service = service;
    }

    @Override
    public boolean isStarting() {
        return this.status == 4;
    }

    @Override
    public boolean isStarted() {
        return false;
    }

    @Override
    public boolean isStopping() {
        return this.status == 3;
    }

    @Override
    public boolean isStopped() {
        return false;
    }

    @Override
    public void start() {
        this.status = 4;
        List<File> jarLists = this.buildJarsList();
        this.initClassLoader(jarLists.toArray(new File[jarLists.size()]));
        this.status = 1;
    }

    @Override
    public void start(boolean startonerror) throws ConnectorException {
        this.start();
    }

    @Override
    public List<File> getJars(String configuration) {
        List<File> result = this.jarsByConfiguration.get(configuration);
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    @Override
    public List<File> getJars() {
        if (this.jars == null) {
            this.jars = new ArrayList<File>();
            for (List<File> jarsList : this.jarsByConfiguration.values()) {
                this.jars.addAll(jarsList);
            }
        }
        return this.jars;
    }

    @Override
    public void stop() {
        this.status = 3;
        this.serviceClassLoader = null;
        this.status = 2;
        this.jars = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassLoader getServiceClassLoader() {
        Object object = this.lock;
        synchronized (object) {
            while (this.isClassLoaderRestarting) {
                try {
                    this.lock.wait(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            return this.serviceClassLoader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() throws ConnectorException {
        Object object = this.lock;
        synchronized (object) {
            this.isClassLoaderRestarting = true;
        }
        this.stop();
        this.start();
        object = this.lock;
        synchronized (object) {
            this.isClassLoaderRestarting = false;
            this.lock.notify();
        }
    }

    private List<File> buildJarsList() {
        this.jarsByConfiguration = new HashMap<String, List<File>>();
        File originalLibDir = ConfigurationManager.getLibDir(this.service.getEnvironment());
        if (originalLibDir.exists() && originalLibDir.isDirectory()) {
            for (Configuration configuration : this.service.getConfigurations()) {
                boolean versionable;
                String baseDir = configuration.getProperty("project.basedir");
                File libDir = originalLibDir;
                if (baseDir != null) {
                    libDir = new File(baseDir, "lib");
                }
                if (!configuration.getBaseConfigType().equals(KnownConfigTypes.JCL) || (versionable = Boolean.parseBoolean(configuration.getProperties().getProperty("jcl.versionable"))) && Component.isRunningOnServerSide()) continue;
                ArrayList<File> files = new ArrayList<File>();
                for (String fileName : ConfigurationManager.getFileNamesFromConfiguration(configuration)) {
                    File libraryFile = new File(libDir, fileName);
                    if (!libraryFile.exists() || !libraryFile.isFile()) {
                        Log.logWarning(ConnectorException.exceptionOnInitJavaClassLibraries(configuration, fileName, libDir));
                        continue;
                    }
                    if (Log.isDebugging()) {
                        Log.logDebug(LibMsg.ADD_LIBRARY_FILE(libraryFile.getName()));
                    }
                    files.add(libraryFile);
                }
                this.jarsByConfiguration.put(configuration.getName(), files);
            }
        }
        if (this.isAntiLockingJarEnabled()) {
            this.jarsByConfiguration = this.updateJarCache(this.jarsByConfiguration);
        }
        this.jars = null;
        return this.getJars();
    }

    private void deleteUselessJarsFromCached(@NotNull List<File> jarFiles) {
        File[] newCachedJars;
        if (jarFiles == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/connector/ClassLoaderService.deleteUselessJarsFromCached must not be null");
        }
        File cachedJarDir = this.getJarsCacheDir();
        if (!cachedJarDir.exists()) {
            cachedJarDir.mkdirs();
        }
        if (!cachedJarDir.isDirectory()) {
            throw new IllegalStateException(cachedJarDir + " must be a directory.");
        }
        HashSet<File> newCachedFiles = new HashSet<File>();
        for (File jarFile : jarFiles) {
            File newCachedJar = this.buildJarCacheFile(jarFile);
            newCachedFiles.add(newCachedJar);
        }
        for (File cachedJarFile : newCachedJars = cachedJarDir.listFiles()) {
            boolean canBeDeleted;
            if (newCachedFiles.contains(cachedJarFile) || (canBeDeleted = cachedJarFile.delete())) continue;
            cachedJarFile.deleteOnExit();
        }
    }

    private boolean isAntiLockingJarEnabled() {
        boolean result = false;
        try {
            result = Id.Product.FUEGO_STUDIO == Id.Product.getCurrent();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    private Map<String, List<File>> updateJarCache(@NotNull Map<String, List<File>> jarsByConfiguration) {
        if (jarsByConfiguration == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/connector/ClassLoaderService.updateJarCache must not be null");
        }
        ArrayList<File> jarsArray = new ArrayList<File>();
        for (List<File> jarsList : jarsByConfiguration.values()) {
            jarsArray.addAll(jarsList);
        }
        this.deleteUselessJarsFromCached(jarsArray);
        HashMap<String, List<File>> result = new HashMap<String, List<File>>();
        for (String configName : jarsByConfiguration.keySet()) {
            ArrayList<File> cachedJarsByConfig = new ArrayList<File>();
            for (File libraryFile : jarsByConfiguration.get(configName)) {
                boolean updatedRequered;
                File tmpJarFile = this.buildJarCacheFile(libraryFile);
                boolean bl = updatedRequered = !tmpJarFile.exists() || libraryFile.lastModified() != tmpJarFile.lastModified() || libraryFile.length() != tmpJarFile.length();
                if (updatedRequered) {
                    FileUtils.copyFileOrDirectory(libraryFile, tmpJarFile);
                    tmpJarFile.setLastModified(libraryFile.lastModified());
                }
                cachedJarsByConfig.add(tmpJarFile);
            }
            result.put(configName, cachedJarsByConfig);
        }
        return result;
    }

    private File buildJarCacheFile(File libraryFile) {
        File tmpDir = this.getJarsCacheDir();
        String jarName = libraryFile.getName();
        return new File(tmpDir, jarName);
    }

    private File getJarsCacheDir() {
        File systemDir = ConfigurationManager.getSystemDir(this.service.getEnvironment());
        return new File(systemDir, JARS_CACHE_DIR_NAME);
    }

    private void initClassLoader(File[] classPath) {
        URL[] urls = new URL[classPath.length];
        for (int i = 0; i < classPath.length; ++i) {
            File file = classPath[i];
            try {
                urls[i] = file.toURL();
                continue;
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }
        this.serviceClassLoader = new URLClassLoader(urls, this.getClass().getClassLoader());
    }
}

