/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.configuration;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.bpm.configuration.BaseConfiguration;
import oracle.bpm.configuration.ConfigurationManager;
import oracle.bpm.configuration.KnownConfigTypes;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.log.Log;
import oracle.bpm.util.FileUtils;

public class JarRepository<T extends BaseConfiguration> {
    private final File jarLibraryDir;
    private final ConfigurationManager<T> manager;
    public static FileFilter JAREXTENSIONFILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            if (pathname.isFile()) {
                String extension = FileUtils.getExtension(pathname);
                return ".jar".equalsIgnoreCase(extension) || ".zip".equalsIgnoreCase(extension);
            }
            return false;
        }
    };

    public JarRepository(File libDir, ConfigurationManager<T> manager) {
        assert (libDir != null && (!libDir.exists() || libDir.isDirectory())) : "Jars dir " + libDir + " is not a directory";
        this.jarLibraryDir = libDir;
        this.manager = manager;
    }

    public boolean isValid() {
        return this.jarLibraryDir != null && this.jarLibraryDir.exists();
    }

    public boolean isValid(File jarFile) {
        return JAREXTENSIONFILTER.accept(jarFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String addJarFile(File newJarFile) {
        if (!this.isValid(newJarFile)) {
            throw new IllegalArgumentException(LibMsg.INVALID_JAR(newJarFile.getAbsolutePath()).toString());
        }
        String jar = newJarFile.getName();
        File jarFile = this.getJarFile(jar);
        if (!jarFile.equals(newJarFile)) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(newJarFile);
                FileUtils.copyFileOrDirectory(newJarFile, jarFile);
            }
            catch (IOException e) {
                Log.logWarning(e);
                String string = null;
                StreamUtils.close(in);
                return string;
            }
            catch (Exception e2) {
                Log.logWarning(e2);
                String string = null;
                {
                    catch (Throwable throwable) {
                        StreamUtils.close(in);
                        throw throwable;
                    }
                }
                StreamUtils.close(in);
                return string;
            }
            StreamUtils.close(in);
        }
        return jar;
    }

    public boolean deleteJar(String jar) {
        File jarFile = this.getJarFile(jar);
        if (jarFile.exists()) {
            try {
                jarFile.delete();
            }
            catch (Exception e) {
                Log.logWarning(e);
                return false;
            }
        }
        return true;
    }

    public boolean existsJar(String jar) {
        return this.getJarFile(jar).exists();
    }

    public boolean existsJarInAnotherJCL(String jar) {
        for (BaseConfiguration configuration : this.manager.getConfigurations(KnownConfigTypes.JCL)) {
            if (!ConfigurationManager.getFileNamesFromConfiguration(configuration).contains(jar)) continue;
            return true;
        }
        return false;
    }

    public List<File> listJarFiles() {
        ArrayList<File> list = new ArrayList<File>();
        if (this.isValid()) {
            return Arrays.asList(this.jarLibraryDir.listFiles(JAREXTENSIONFILTER));
        }
        return list;
    }

    private File getJarFile(String jar) {
        return new File(this.jarLibraryDir, jar);
    }
}

