/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.configuration;

import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.bpm.configuration.BaseConfiguration;
import oracle.bpm.configuration.ConfigurationLoader;
import oracle.bpm.configuration.ConfigurationRuntimeException;
import oracle.bpm.lang.Literals;
import oracle.bpm.xml.XmlWriter;

public class ConfigurationSet<T extends BaseConfiguration>
implements Iterable<T> {
    private Map<String, T> entries;
    private Map<String, String> variables = new LinkedHashMap<String, String>();

    protected ConfigurationSet() {
        this.entries = new LinkedHashMap<String, T>();
    }

    public static <C extends BaseConfiguration> ConfigurationSet<C> create() {
        return new ConfigurationSet();
    }

    public static <C extends BaseConfiguration> ConfigurationSet<C> create(String xml) {
        return ConfigurationSet.create(xml, false);
    }

    public static <C extends BaseConfiguration> ConfigurationSet<C> create(String xml, boolean ignoreUnregistered) {
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(xml.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw ConfigurationRuntimeException.parseException(e);
        }
        return ConfigurationSet.create(is, ignoreUnregistered);
    }

    public static <C extends BaseConfiguration> ConfigurationSet<C> create(InputStream is) {
        return ConfigurationSet.create(is, false);
    }

    public static <C extends BaseConfiguration> ConfigurationSet<C> create(InputStream is, boolean ignoreUnregistered) {
        ConfigurationSet result = new ConfigurationSet();
        ConfigurationLoader reader = new ConfigurationLoader(result, is, ignoreUnregistered);
        reader.parse();
        return result;
    }

    public static <C extends BaseConfiguration> ConfigurationSet<C> create(ConfigurationLoader<C> configurationLoader) {
        ConfigurationSet result = new ConfigurationSet();
        configurationLoader.setContainer(result);
        configurationLoader.parse();
        return result;
    }

    public static <C extends BaseConfiguration> ConfigurationSet<C> create(Collection<C> configurations) {
        ConfigurationSet<BaseConfiguration> result = new ConfigurationSet<BaseConfiguration>();
        for (BaseConfiguration configuration : configurations) {
            result.addEntry(configuration);
        }
        return result;
    }

    public T getEntry(String name) {
        return (T)((BaseConfiguration)this.entries.get(name));
    }

    public String getXML() {
        CharArrayWriter writer = new CharArrayWriter();
        try {
            this.writeXML(writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ((Object)writer).toString();
    }

    public void addEntry(T entry) {
        if (this.entries.containsKey(entry.getName())) {
            StringBuilder sb = new StringBuilder();
            sb.append("Name: ").append(entry.getName()).append(";");
            sb.append(" Subtype:").append(entry.getConfigType()).append(";");
            if (entry.getConfigType() != null) {
                sb.append(" Type:").append(entry.getConfigType().getParent()).append(";");
            }
            if (entry.getProperties() != null) {
                sb.append(" Properties:").append(entry.getProperties());
            }
            throw ConfigurationRuntimeException.duplicateName(sb.toString());
        }
        this.entries.put(entry.getName(), entry);
    }

    public boolean contains(String name) {
        return this.entries.containsKey(name);
    }

    public T removeEntry(String name) {
        return (T)((BaseConfiguration)this.entries.remove(name));
    }

    public Collection<T> values() {
        return Collections.unmodifiableCollection(this.entries.values());
    }

    public void writeXML(File file) throws IOException {
        if (!file.isDirectory()) {
            this.writeXML(new OutputStreamWriter((OutputStream)new FileOutputStream(file), Literals.DEFAULT_ENCODING));
        }
    }

    public void writeXML(OutputStream outputStream, String encoding) throws IOException {
        this.writeXML(new OutputStreamWriter(outputStream, encoding), encoding);
    }

    public void writeXML(Writer writer) throws IOException {
        this.writeXML(writer, "UTF-8");
    }

    public void writeXML(XmlWriter xmlWriter) throws IOException {
        xmlWriter.startElement("set");
        for (String variableName : this.variables.keySet()) {
            xmlWriter.startElement("variable");
            xmlWriter.printAttribute("name", variableName);
            xmlWriter.printAttribute("value", this.variables.get(variableName));
            xmlWriter.endElement();
        }
        for (BaseConfiguration entry : this) {
            xmlWriter.startElement("configuration");
            xmlWriter.printAttribute("name", entry.getName());
            xmlWriter.printAttribute("type", entry.getBaseConfigType().getName());
            xmlWriter.printAttribute("subtype", entry.getConfigType().getName());
            Enumeration<Object> keys = entry.getProperties().keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = entry.getProperties().getProperty(key);
                if (value == null || "".equals(value)) continue;
                xmlWriter.startElement("property");
                xmlWriter.printAttribute("name", key);
                xmlWriter.printAttribute("value", value);
                xmlWriter.endElement();
            }
            xmlWriter.endElement();
        }
        xmlWriter.endElement();
        xmlWriter.flush();
    }

    @Override
    public Iterator<T> iterator() {
        return this.entries.values().iterator();
    }

    void addVariable(String key, String value) {
        this.variables.put(key, value);
    }

    private void writeXML(Writer writer, String encoding) throws IOException {
        XmlWriter xml = new XmlWriter(writer, encoding);
        xml.startDocument();
        this.writeXML(xml);
    }
}

