/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.configuration;

import fuego.directory.DirectorySession;
import java.io.File;
import oracle.bpm.configuration.ConfigType;
import oracle.bpm.lang.DefaultRuntimeException;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.resources.Msg;

public class ConfigurationRuntimeException
extends DefaultRuntimeException {
    static final long serialVersionUID = 7223814981849060128L;
    static final long serialCheck = -1704978091387432431L;

    public ConfigurationRuntimeException(Msg msgKey, Throwable cause) {
        super(msgKey, cause);
    }

    protected ConfigurationRuntimeException(Msg msgKey) {
        super(msgKey);
    }

    public static ConfigurationRuntimeException cannotCreateManager(File file) {
        return new ConfigurationRuntimeException(LibMsg.CANNOT_CREATE_MANAGER(file.getAbsolutePath()));
    }

    public static ConfigurationRuntimeException cannotCreateManager(File file, Exception cause) {
        return (ConfigurationRuntimeException)new ConfigurationRuntimeException(LibMsg.CANNOT_CREATE_MANAGER(file.getAbsolutePath())).initCause(cause);
    }

    public static ConfigurationRuntimeException cannotCreateManager(DirectorySession session, Exception cause) {
        return (ConfigurationRuntimeException)new ConfigurationRuntimeException(LibMsg.CANNOT_CREATE_MANAGER_FDI(session.getSchemaId())).initCause(cause);
    }

    public static ConfigurationRuntimeException configurationIsNull() {
        return new ConfigurationRuntimeException(LibMsg.FCI_00006);
    }

    public static ConfigurationRuntimeException duplicateName(String name) {
        return new ConfigurationRuntimeException(LibMsg.DUPLICATE_NAME(name));
    }

    public static ConfigurationRuntimeException exportException(Exception cause) {
        return (ConfigurationRuntimeException)new ConfigurationRuntimeException(LibMsg.EXCEPTION_EXPORT).initCause(cause);
    }

    public static ConfigurationRuntimeException invalidFormatForProperty(String qName) {
        return null;
    }

    public static ConfigurationRuntimeException parseException(Exception cause) {
        return (ConfigurationRuntimeException)new ConfigurationRuntimeException(LibMsg.EXCEPTION_PARSE).initCause(cause);
    }

    public static ConfigurationRuntimeException parseException(File file, Exception cause) {
        return new ConfigurationRuntimeException(LibMsg.EXCEPTION_PARSE2(file.getAbsolutePath()), (Throwable)cause);
    }

    public static ConfigurationRuntimeException parseException(File file, ConfigurationRuntimeException original) {
        Throwable cause = original.getCause() == null ? original : original.getCause();
        return (ConfigurationRuntimeException)new ConfigurationRuntimeException(LibMsg.EXCEPTION_PARSE2(file.getAbsolutePath())).initCause(cause);
    }

    public static ConfigurationRuntimeException parseException(DirectorySession session, ConfigurationRuntimeException original) {
        Throwable cause = original.getCause() == null ? original : original.getCause();
        return (ConfigurationRuntimeException)new ConfigurationRuntimeException(LibMsg.EXCEPTION_PARSE3(session.getSchemaId())).initCause(cause);
    }

    public static ConfigurationRuntimeException subTypeAlreadyRegistered(ConfigType subType) {
        return new ConfigurationRuntimeException(LibMsg.SUBTYPE_ALREADY_REGISTERED(subType.getName(), subType.getParent().getName()));
    }

    public static ConfigurationRuntimeException subTypeNotRegistered(ConfigType subType) {
        return new ConfigurationRuntimeException(LibMsg.SUBTYPE_NOT_REGISTERED(subType.toString(), subType.getParent().toString()));
    }

    public static ConfigurationRuntimeException subTypeNotRegistered(String type, String subType) {
        return new ConfigurationRuntimeException(LibMsg.SUBTYPE_NOT_REGISTERED(subType, type));
    }

    public static ConfigurationRuntimeException cannotCreateService(Throwable cause) {
        return (ConfigurationRuntimeException)new ConfigurationRuntimeException(LibMsg.CANNOT_CREATE_SERVICE).initCause(cause);
    }

    public static void assertTrue(boolean condition, Msg message) {
        if (!condition) {
            throw new ConfigurationRuntimeException(message);
        }
    }

    public static ConfigurationRuntimeException wrap(Msg msg, Throwable t) {
        return new ConfigurationRuntimeException(msg, t);
    }
}

