/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.configuration;

import fuego.directory.DirConfiguration;
import fuego.directory.DirectoryException;
import fuego.directory.DirectorySession;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.configuration.BaseConfiguration;
import oracle.bpm.configuration.ConfigType;
import oracle.bpm.configuration.Configuration;
import oracle.bpm.configuration.ConfigurationManagerListener;
import oracle.bpm.configuration.ConfigurationRuntimeException;
import oracle.bpm.configuration.ConfigurationSet;
import oracle.bpm.configuration.DirectoryManager;
import oracle.bpm.configuration.FileManager;
import oracle.bpm.configuration.KnownConfigTypes;
import oracle.bpm.io.FileSystem;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.lang.Environment;
import oracle.bpm.lang.exception.ReadOnlyException;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.log.Log;

public abstract class ConfigurationManager<T extends BaseConfiguration> {
    protected ConfigurationSet<T> configurations;
    protected Environment environment = null;
    protected List<ConfigurationManagerListener<T>> listeners = new ArrayList<ConfigurationManagerListener<T>>();
    private ConfigurationManagerPersistenceListener configurationManagerPersistenceListener;
    private File projectBaseDir;
    private boolean readOnly = false;
    private boolean reloadEnabled;
    public static final int CONFIGURATION_ADDED = 1;
    public static final int CONFIGURATION_DELETED = 2;
    public static final int CONFIGURATION_UPDATED = 3;
    public static final String PROJECT_SYSTEM_DIR = "system";
    public static final String PROJECT_LIB_DIR = "lib";

    protected ConfigurationManager(ConfigurationSet<T> configurations) {
        assert (configurations != null) : "Null configurations";
        this.configurations = configurations;
        this.configurationManagerPersistenceListener = new ConfigurationManagerPersistenceListener();
        this.configurationManagerPersistenceListener.setEnabled(true);
        this.addListenerToTheEnd(this.configurationManagerPersistenceListener);
        this.reloadEnabled = true;
    }

    public static <C extends BaseConfiguration> StringList getFileNamesFromConfiguration(C configuration) {
        assert (configuration != null && configuration.getBaseConfigType() == KnownConfigTypes.JCL);
        return StringList.createTokenizing(configuration.getProperty("FILE"), ":");
    }

    public static File getLibDir(Environment environment) {
        String baseDir = ConfigurationManager.getBaseDir(environment);
        assert (baseDir != null) : "The environment for the connectors/configurations must be initialized with a base dir";
        return new File(baseDir, PROJECT_LIB_DIR);
    }

    public static File getSystemDir(Environment environment) {
        String baseDir = ConfigurationManager.getBaseDir(environment);
        assert (baseDir != null) : "The environment for the connectors/configurations must be initialized with a base dir";
        boolean inStudio = environment.getBooleanProperty("studio", false);
        return new File(baseDir, PROJECT_SYSTEM_DIR + (!inStudio ? "" : File.separator + "cache"));
    }

    public static String getProperty(Environment environment, String key) {
        return environment.getProperty(key, null);
    }

    public static <C extends BaseConfiguration> ConfigurationManager<C> create(ConfigurationSet<C> configurations) {
        return new FileManager<C>(configurations, null, null);
    }

    public static ConfigurationManager<Configuration> createFromDirectory(DirectorySession session) {
        return ConfigurationManager.createFromDirectory(session, false);
    }

    public static ConfigurationManager<Configuration> createFromDirectory(DirectorySession session, boolean ignoreUnregistered) {
        try {
            ConfigurationSet<Object> configurations;
            DirConfiguration directoryConfigurations = DirConfiguration.fetch(session);
            if (directoryConfigurations == null || directoryConfigurations.getProperties().length() == 0) {
                System.out.println("configurations not stored in directory");
                configurations = new ConfigurationSet();
            } else {
                configurations = ConfigurationSet.create(directoryConfigurations.getProperties(), ignoreUnregistered);
            }
            return new DirectoryManager<Configuration>(configurations, session);
        }
        catch (DirectoryException e) {
            throw ConfigurationRuntimeException.cannotCreateManager(session, (Exception)e);
        }
        catch (ConfigurationRuntimeException e) {
            throw ConfigurationRuntimeException.parseException(session, e);
        }
    }

    public static <C extends BaseConfiguration> ConfigurationManager<C> createFromFile(String file) {
        return ConfigurationManager.createFromFile(new File(file), null);
    }

    public static <C extends BaseConfiguration> ConfigurationManager<C> createFromFile(String file, FileSystem fileSystem) {
        return ConfigurationManager.createFromFile(new File(file), fileSystem);
    }

    public static <C extends BaseConfiguration> ConfigurationManager<C> createFromFile(File file) {
        return ConfigurationManager.createFromFile(file, null);
    }

    public static <C extends BaseConfiguration> ConfigurationManager<C> createFromFile(File file, FileSystem fileSystem) {
        FileManager fileManager;
        if (!file.exists()) {
            return new FileManager(new ConfigurationSet(), file, fileSystem);
        }
        if (!file.isFile()) {
            throw ConfigurationRuntimeException.cannotCreateManager(file);
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            ConfigurationSet configurations = ConfigurationSet.create(inputStream);
            fileManager = new FileManager(configurations, file, fileSystem);
        }
        catch (IOException e) {
            try {
                throw ConfigurationRuntimeException.cannotCreateManager(file, (Exception)e);
            }
            catch (Throwable throwable) {
                StreamUtils.close(inputStream);
                throw throwable;
            }
        }
        StreamUtils.close(inputStream);
        return fileManager;
    }

    public File getProjectBaseDir() {
        return this.projectBaseDir;
    }

    public void setProjectBaseDir(File projectBaseDir) {
        this.projectBaseDir = projectBaseDir;
    }

    public File getLibDir() {
        File result = null;
        if (this.projectBaseDir != null) {
            result = new File(this.projectBaseDir, PROJECT_LIB_DIR);
        } else if (this.environment != null) {
            result = ConfigurationManager.getLibDir(this.environment);
        }
        return result;
    }

    public File getSystemDir() {
        assert (this.environment != null) : "The environment for the connectors/configurations must be initialized";
        assert (this.projectBaseDir != null) : "The baseDir for the connectors/configurations must be initialized";
        boolean inStudio = this.environment.getBooleanProperty("studio", false);
        return new File(this.projectBaseDir, PROJECT_SYSTEM_DIR + (!inStudio ? "" : File.separator + "cache"));
    }

    public final List<T> getConfigurations(ConfigType type) {
        return this.getConfigurations(type, false);
    }

    public final List<T> getConfigurations(ConfigType type, boolean useSubtype) {
        TreeMap<String, BaseConfiguration> result = new TreeMap<String, BaseConfiguration>();
        for (BaseConfiguration configuration : this.configurations.values()) {
            ConfigType currentType = useSubtype ? configuration.getConfigType() : configuration.getBaseConfigType();
            if (!currentType.equals(type)) continue;
            result.put(configuration.getName(), configuration);
        }
        return new ArrayList(result.values());
    }

    public T getConfiguration(String name) {
        return this.configurations.getEntry(name);
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setPersistenceListenerEnabled(boolean enabled) {
        this.configurationManagerPersistenceListener.setEnabled(enabled);
    }

    public boolean isPersistenceListenerEnabled() {
        return this.configurationManagerPersistenceListener.isEnabled();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReloadEnabled(boolean enabled) {
        this.reloadEnabled = enabled;
    }

    public boolean isReloadEnabled() {
        return this.reloadEnabled;
    }

    public List<File> getJarsFromJavaClassLibraries() {
        return this.getJarsFromJavaClassLibraries(false);
    }

    public List<File> getJarsFromJavaClassLibraries(boolean excludeNonVersionables) {
        ArrayList<File> javaClassLibraries = new ArrayList<File>();
        File libDir = this.getLibDir();
        boolean libDirOk = libDir.exists() && libDir.isDirectory();
        for (BaseConfiguration configuration : this.configurations) {
            boolean versionable;
            if (configuration.getBaseConfigType() != KnownConfigTypes.JCL || !(versionable = "true".equals(configuration.getProperty("jcl.versionable"))) && excludeNonVersionables) continue;
            assert (libDirOk) : "Invalid lib dir [" + libDir + "]";
            for (String fileName : ConfigurationManager.getFileNamesFromConfiguration(configuration)) {
                File libraryFile = new File(libDir, fileName);
                if (!libraryFile.exists() || !libraryFile.isFile()) continue;
                if (Log.isDebugging()) {
                    Log.logDebug(LibMsg.ADD_LIBRARY_FILE(libraryFile.getName()));
                }
                javaClassLibraries.add(libraryFile);
            }
        }
        return javaClassLibraries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ConfigurationManagerListener<T> listener) {
        if (listener != null) {
            ConfigurationManager configurationManager = this;
            synchronized (configurationManager) {
                ArrayList<ConfigurationManagerListener<T>> newList = new ArrayList<ConfigurationManagerListener<T>>();
                newList.addAll(this.listeners);
                newList.add(0, listener);
                this.listeners = newList;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListenerToTheEnd(ConfigurationManagerListener<T> listener) {
        if (listener != null) {
            ConfigurationManager configurationManager = this;
            synchronized (configurationManager) {
                ArrayList<ConfigurationManagerListener<T>> newList = new ArrayList<ConfigurationManagerListener<T>>();
                newList.addAll(this.listeners);
                newList.add(listener);
                this.listeners = newList;
            }
        }
    }

    public String getNewConfigurationName(String prefix) {
        int i = 1;
        String name = prefix;
        while (this.contains(name)) {
            name = prefix + i++;
        }
        return name;
    }

    public boolean contains(String name) {
        return this.configurations.contains(name);
    }

    public void destroy() {
        this.setReloadEnabled(false);
        this.listeners.clear();
    }

    public byte[] exportAsXML() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] xml = null;
        try {
            this.configurations.writeXML(baos, "UTF-8");
            xml = baos.toByteArray();
        }
        catch (IOException e) {
            try {
                throw ConfigurationRuntimeException.exportException(e);
            }
            catch (Throwable throwable) {
                StreamUtils.close(baos);
                throw throwable;
            }
        }
        StreamUtils.close(baos);
        return xml;
    }

    public StringList hasResourcesAssociated(String file) {
        assert (this.projectBaseDir != null) : "The projectBaseDir must be defined to use this method.";
        StringList configurationList = StringList.create();
        File libDir = this.getLibDir();
        boolean libDirOk = libDir.exists() && libDir.isDirectory();
        for (BaseConfiguration configuration : this.configurations) {
            if (configuration.getBaseConfigType() != KnownConfigTypes.JCL) continue;
            assert (libDirOk) : "Invalid lib dir [" + libDir + "]";
            StringList fileNames = ConfigurationManager.getFileNamesFromConfiguration(configuration);
            for (String fileName : fileNames) {
                File libraryFile = new File(libDir, fileName);
                if (!libraryFile.exists() || !libraryFile.isFile() || !libraryFile.getName().equalsIgnoreCase(file)) continue;
                configurationList.add(configuration.getName());
            }
        }
        return configurationList;
    }

    public Configuration newConfiguration(String name, ConfigType type) {
        return new Configuration(name, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadConfigurations() {
        if (this.isReloadEnabled()) {
            this.setPersistenceListenerEnabled(false);
            try {
                for (BaseConfiguration configuration : new ArrayList<T>(this.configurations.values())) {
                    this.internalRemoveConfiguration(configuration);
                }
                this.reloadNewConfigurations();
            }
            finally {
                this.setPersistenceListenerEnabled(true);
            }
        }
    }

    public boolean removeConfiguration(T configuration) {
        return this.removeConfiguration(configuration.getName());
    }

    public boolean removeConfiguration(String name) {
        if (this.isReadOnly()) {
            throw new ReadOnlyException(LibMsg.READ_ONLY_RESOURCE(name));
        }
        return this.internalRemoveConfiguration(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ConfigurationManagerListener<T> listener) {
        if (listener != null) {
            ConfigurationManager configurationManager = this;
            synchronized (configurationManager) {
                ArrayList<ConfigurationManagerListener<T>> newList = new ArrayList<ConfigurationManagerListener<T>>();
                newList.addAll(this.listeners);
                newList.remove(listener);
                this.listeners = newList;
            }
        }
    }

    public boolean saveConfiguration(T configuration) {
        if (this.isReadOnly()) {
            return false;
        }
        return this.internalSaveConfiguration(configuration);
    }

    public ConfigurationSet getConfigurationsSet() {
        return this.configurations;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setConfigurations(ConfigurationSet configurations) {
        this.configurations = configurations;
    }

    protected abstract void persistConfigurations();

    protected abstract void configRemoved(T var1);

    protected boolean internalRemoveConfiguration(T configuration) {
        return this.internalRemoveConfiguration(configuration.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean internalRemoveConfiguration(String name) {
        this.setReloadEnabled(false);
        try {
            if (!this.configurations.contains(name)) {
                boolean bl = false;
                return bl;
            }
            T deletedEntry = this.configurations.removeEntry(name);
            this.notifyListeners(deletedEntry, 2);
        }
        finally {
            this.setReloadEnabled(true);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean internalSaveConfiguration(T configuration) {
        this.setReloadEnabled(false);
        try {
            int type;
            if (!this.configurations.contains(configuration.getName())) {
                type = 1;
            } else {
                type = 3;
                this.configurations.removeEntry(configuration.getName());
            }
            this.configurations.addEntry(configuration);
            this.notifyListeners(configuration, type);
        }
        finally {
            this.setReloadEnabled(true);
        }
        return true;
    }

    protected void reloadNewConfigurations() {
    }

    private static String getBaseDir(Environment environment) {
        String baseDir = ConfigurationManager.getProperty(environment, "fuego.user.dir");
        if (baseDir == null) {
            baseDir = ConfigurationManager.getProperty(environment, "user.dir");
        }
        return baseDir;
    }

    private void notifyListeners(T configuration, int type) {
        for (ConfigurationManagerListener<T> listener : this.listeners) {
            switch (type) {
                case 1: {
                    listener.configurationAdded(configuration);
                    break;
                }
                case 2: {
                    listener.configurationDeleted(configuration);
                    break;
                }
                case 3: {
                    listener.configurationUpdated(configuration);
                }
            }
        }
    }

    class ConfigurationManagerPersistenceListener
    implements ConfigurationManagerListener<T> {
        private boolean enabled;

        ConfigurationManagerPersistenceListener() {
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public void configurationAdded(T configuration) {
            this.configurationChanged();
        }

        @Override
        public void configurationDeleted(T configuration) {
            this.configurationChanged();
            if (this.isEnabled()) {
                ConfigurationManager.this.configRemoved(configuration);
            }
        }

        @Override
        public void configurationUpdated(T configuration) {
            this.configurationChanged();
        }

        private void configurationChanged() {
            if (this.isEnabled()) {
                ConfigurationManager.this.persistConfigurations();
            }
        }
    }
}

